/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.rms.RecordStore;

public class SokobanCanvas
extends Canvas
implements CommandListener,
PlayerListener {
    private Command cmExit;
    private Sokoban midlet;
    private RecordStore levelsaved = null;
    private String namedb = "CurrentLevel";
    private int CurrentLevel;
    private int Direction = 0;
    private int isOver = 0;
    private int LevelMax = 19;
    private int[][] Box;
    private int isTap = 0;
    private int X = 0;
    private int Y = 0;
    private int K = 0;
    private int isDone = 0;
    private int Xworker;
    private int Yworker;
    private int NoBoxes;
    private int Screen;
    private int[][] Map;
    private int[] tmp;
    private String an = null;
    private Image background = null;
    private Image ball = null;
    private Image box = null;
    private Image boxdone = null;
    private Image newbrick = null;
    private Image down = null;
    private Image left = null;
    private Image nothing = null;
    private Image right = null;
    private Image up = null;
    private Image currentworker = null;
    private Image nen = null;
    private Image Tap = null;
    private Image AboutBT = null;
    private Image ContinueBT = null;
    private Image ContinueFreezeBT = null;
    private Image ExitBT = null;
    private Image HowBT = null;
    private Image OkBT = null;
    private Image NoBT = null;
    private Image NewBT = null;
    private Image BackBT = null;
    private Image MenuBT = null;
    private Image NextBT = null;
    private Image ResetBT = null;
    private Image Label = null;
    private Image no1 = null;
    private Image no2 = null;
    private Image CurrentScreen = null;
    private InputStream is = null;
    private Player p = null;

    public SokobanCanvas(Sokoban midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.initDatabase();
        this.initImage();
    }

    public void initDatabase() {
        this.openRecStore();
        try {
            if (this.levelsaved.getNumRecords() == 0) {
                this.writeRecord("0");
                this.writeRecord("0");
                this.CurrentLevel = 0;
            } else {
                this.readRecords();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.Screen = 0;
    }

    public void initLevel() {
        this.Direction = 0;
        this.tmp = new int[81];
        this.Map = new int[9][9];
        this.Box = new int[9][9];
        this.ReadFile();
        this.Rearrange();
    }

    public void ResetLevel() {
        this.initLevel();
    }

    public void NewGame() {
        this.CurrentLevel = 1;
        this.isDone = 0;
        this.initLevel();
    }

    public int CheckGame() {
        int kt = 1;
        for (int i = 0; i <= 8; ++i) {
            for (int j = 0; j <= 8; ++j) {
                if (this.Map[i][j] != 4 || this.Box[i][j] == 1) continue;
                kt = 0;
            }
        }
        return kt;
    }

    public void initImage() {
        try {
            this.background = Image.createImage((String)"/image/background.png");
            this.ball = Image.createImage((String)"/image/ball.png");
            this.box = Image.createImage((String)"/image/box.png");
            this.boxdone = Image.createImage((String)"/image/boxdone.png");
            this.newbrick = Image.createImage((String)"/image/newbrick.png");
            this.down = Image.createImage((String)"/screens/down.png");
            this.left = Image.createImage((String)"/screens/left.png");
            this.nothing = Image.createImage((String)"/image/nothing.png");
            this.right = Image.createImage((String)"/screens/right.png");
            this.up = Image.createImage((String)"/screens/up.png");
            this.nen = Image.createImage((String)"/screens/nen.png");
            this.Label = Image.createImage((String)"/screens/label.png");
            this.AboutBT = Image.createImage((String)"/screens/about.png");
            this.NewBT = Image.createImage((String)"/screens/new.png");
            this.ContinueBT = Image.createImage((String)"/screens/continue.png");
            this.HowBT = Image.createImage((String)"/screens/how.png");
            this.ExitBT = Image.createImage((String)"/screens/exit.png");
            this.BackBT = Image.createImage((String)"/screens/back.png");
            this.MenuBT = Image.createImage((String)"/screens/menu.png");
            this.ResetBT = Image.createImage((String)"/screens/reset.png");
            this.NextBT = Image.createImage((String)"/screens/next.png");
            this.OkBT = Image.createImage((String)"/screens/ok.png");
            this.NoBT = Image.createImage((String)"/screens/no.png");
            this.ContinueFreezeBT = Image.createImage((String)"/screens/continuefreeze.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cmExit = new Command("Exit", 7, 1);
        this.addCommand(this.cmExit);
        this.setCommandListener(this);
    }

    public void ReadFile() {
        String filename = "/levels/level" + String.valueOf(this.CurrentLevel) + ".txt";
        InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        int x = 0;
        int y = 0;
        try {
            int c;
            int count = 0;
            StringBuffer sb = new StringBuffer();
            while ((c = file.read()) != -1) {
                if (c < 48 || c > 57) continue;
                if (count < 81) {
                    this.tmp[count] = c - 48;
                    ++count;
                    continue;
                }
                if (count == 81) {
                    this.Xworker = c - 48;
                } else if (count == 82) {
                    this.Yworker = c - 48;
                } else if (count == 83) {
                    this.NoBoxes = c - 48;
                } else if (count % 2 == 0) {
                    x = c - 48;
                } else {
                    y = c - 48;
                    this.Box[x][y] = 1;
                }
                ++count;
            }
            this.an = "yes";
        }
        catch (IOException e) {
            this.an = "no";
        }
    }

    public void Rearrange() {
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.Map[i][j] = this.tmp[count];
                ++count;
            }
        }
    }

    public void DrawBoxes(Graphics g) {
        int j;
        int i;
        int maxx = 0;
        int maxy = 0;
        for (i = 8; i >= 0; --i) {
            for (j = 0; j < 9; ++j) {
                if (this.Map[i][j] != 1 || i <= maxx) continue;
                maxx = i;
            }
        }
        for (i = 8; i >= 0; --i) {
            for (j = 0; j < 9; ++j) {
                if (this.Map[j][i] != 1 || i <= maxy) continue;
                maxy = i;
            }
        }
        ++maxx;
        ++maxy;
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                if (this.Map[i][j] != 0) {
                    if (this.Map[i][j] == 1) {
                        g.drawImage(this.newbrick, j * 26 + 3 + (9 - maxy) * 13, i * 26 + (9 - maxx) * 13, 0);
                    } else if (this.Map[i][j] == 2) {
                        g.drawImage(this.background, j * 26 + 3 + (9 - maxy) * 13, i * 26 + (9 - maxx) * 13, 0);
                    } else if (this.Map[i][j] == 4) {
                        g.drawImage(this.ball, j * 26 + 3 + (9 - maxy) * 13, i * 26 + (9 - maxx) * 13, 0);
                    }
                }
                if (this.Box[i][j] != 1) continue;
                if (this.Map[i][j] == 4) {
                    g.drawImage(this.boxdone, j * 26 + 3 + (9 - maxy) * 13, i * 26 + (9 - maxx) * 13, 0);
                    continue;
                }
                g.drawImage(this.box, j * 26 + 3 + (9 - maxy) * 13, i * 26 + (9 - maxx) * 13, 0);
            }
        }
        try {
            if (this.Map[this.Yworker][this.Xworker] != 4) {
                if (this.Direction == 0) {
                    this.currentworker = Image.createImage((String)"/image/workerdown.png");
                } else if (this.Direction == 1) {
                    this.currentworker = Image.createImage((String)"/image/workerup.png");
                } else if (this.Direction == 2) {
                    this.currentworker = Image.createImage((String)"/image/workerleft.png");
                } else if (this.Direction == 3) {
                    this.currentworker = Image.createImage((String)"/image/workerright.png");
                }
            } else if (this.Direction == 0) {
                this.currentworker = Image.createImage((String)"/image/overdown.png");
            } else if (this.Direction == 1) {
                this.currentworker = Image.createImage((String)"/image/overup.png");
            } else if (this.Direction == 2) {
                this.currentworker = Image.createImage((String)"/image/overleft.png");
            } else if (this.Direction == 3) {
                this.currentworker = Image.createImage((String)"/image/overright.png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        g.drawImage(this.currentworker, this.Xworker * 26 + 3 + (9 - maxy) * 13, this.Yworker * 26 + (9 - maxx) * 13, 0);
    }

    public void DrawKeys(Graphics g) {
        g.drawImage(this.left, 0, 280, 0);
        g.drawImage(this.down, 60, 340, 0);
        g.drawImage(this.up, 60, 280, 0);
        g.drawImage(this.right, 180, 280, 0);
        g.drawImage(this.MenuBT, 0, 237, 0);
        g.drawImage(this.ResetBT, 159, 237, 0);
        int n = 8;
        if (this.CurrentLevel < 10) {
            try {
                this.no1 = Image.createImage((String)("/nums/" + String.valueOf(this.CurrentLevel) + ".png"));
            }
            catch (Exception e) {
                // empty catch block
            }
            g.drawImage(this.no1, 120, 235, 17);
        } else {
            try {
                this.no1 = Image.createImage((String)("/nums/" + String.valueOf(this.CurrentLevel / 10) + ".png"));
                this.no2 = Image.createImage((String)("/nums/" + String.valueOf(this.CurrentLevel % 10) + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            g.drawImage(this.no1, 110, 235, 17);
            g.drawImage(this.no2, 125, 235, 17);
        }
        if (this.isTap == 1) {
            g.drawImage(this.Tap, 0, 280, 0);
        } else if (this.isTap == 3) {
            g.drawImage(this.Tap, 60, 340, 0);
        } else if (this.isTap == 2) {
            g.drawImage(this.Tap, 60, 280, 0);
        } else if (this.isTap == 4) {
            g.drawImage(this.Tap, 180, 280, 0);
        } else if (this.isTap == 5) {
            g.drawImage(this.Tap, 0, 237, 0);
        } else if (this.isTap == 6) {
            g.drawImage(this.Tap, 159, 237, 0);
        }
    }

    public void DrawAboutScreen(Graphics g) {
        g.drawImage(this.nen, 0, 0, 0);
        g.drawImage(this.CurrentScreen, 120, 50, 17);
        if (this.isTap == 1) {
            g.drawImage(this.Tap, 120, 320, 17);
        } else {
            g.drawImage(this.BackBT, 120, 320, 17);
        }
    }

    public void DrawHowScreen(Graphics g) {
        g.drawImage(this.nen, 0, 0, 0);
        g.drawImage(this.CurrentScreen, 120, 50, 17);
        if (this.isTap == 1) {
            g.drawImage(this.Tap, 120, 320, 17);
        } else {
            g.drawImage(this.BackBT, 120, 320, 17);
        }
    }

    public void DrawDoneScreen(Graphics g) {
        g.drawImage(this.nen, 0, 0, 0);
        try {
            this.CurrentScreen = Image.createImage((String)"/screens/donescreen.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        g.drawImage(this.CurrentScreen, 120, 50, 17);
        if (this.isTap == 1) {
            g.drawImage(this.Tap, 120, 320, 17);
        } else {
            g.drawImage(this.MenuBT, 120, 320, 17);
        }
    }

    public void DrawFinishedScreen(Graphics g) {
        try {
            this.CurrentScreen = Image.createImage((String)"/screens/finishscreen.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        g.drawImage(this.nen, 0, 0, 0);
        g.drawImage(this.CurrentScreen, 120, 50, 17);
        g.drawImage(this.OkBT, 5, 355, 0);
        g.drawImage(this.NoBT, 195, 355, 0);
    }

    public void DrawPassScreen(Graphics g) {
        g.drawImage(this.nen, 0, 0, 0);
        try {
            this.CurrentScreen = Image.createImage((String)"/screens/passscreen.png");
        }
        catch (Exception e) {
            // empty catch block
        }
        g.drawImage(this.CurrentScreen, 120, 50, 17);
        int n = 88;
        if (this.CurrentLevel < 10) {
            try {
                this.no1 = Image.createImage((String)("/nums/" + String.valueOf(this.CurrentLevel) + ".png"));
            }
            catch (Exception e) {
                // empty catch block
            }
            g.drawImage(this.no1, 120, 175, 17);
        } else {
            try {
                this.no1 = Image.createImage((String)("/nums/" + String.valueOf(this.CurrentLevel / 10) + ".png"));
                this.no2 = Image.createImage((String)("/nums/" + String.valueOf(this.CurrentLevel % 10) + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            g.drawImage(this.no1, 110, 175, 17);
            g.drawImage(this.no2, 125, 175, 17);
        }
        if (this.isTap == 1) {
            g.drawImage(this.Tap, 120, 320, 17);
        } else {
            g.drawImage(this.NextBT, 120, 320, 17);
        }
    }

    public void DrawNewScreen(Graphics g) {
        g.drawImage(this.nen, 0, 0, 0);
        g.drawImage(this.CurrentScreen, 120, 50, 17);
        g.drawImage(this.OkBT, 5, 355, 0);
        g.drawImage(this.NoBT, 195, 355, 0);
    }

    public void DrawStartScreen(Graphics g) {
        g.drawImage(this.nen, 0, 0, 0);
        g.drawImage(this.Label, 0, 0, 0);
        if (this.CurrentLevel == 0) {
            g.drawImage(this.ContinueFreezeBT, 120, 120, 17);
        } else if (this.isTap == 1) {
            g.drawImage(this.Tap, 120, 120, 17);
        } else {
            g.drawImage(this.ContinueBT, 120, 120, 17);
        }
        if (this.isTap == 2) {
            g.drawImage(this.Tap, 120, 170, 17);
        } else {
            g.drawImage(this.NewBT, 120, 170, 17);
        }
        if (this.isTap == 3) {
            g.drawImage(this.Tap, 120, 220, 17);
        } else {
            g.drawImage(this.HowBT, 120, 220, 17);
        }
        if (this.isTap == 4) {
            g.drawImage(this.Tap, 120, 270, 17);
        } else {
            g.drawImage(this.AboutBT, 120, 270, 17);
        }
        if (this.isTap == 5) {
            g.drawImage(this.Tap, 120, 320, 17);
        } else {
            g.drawImage(this.ExitBT, 120, 320, 17);
        }
    }

    protected void paint(Graphics g) {
        if (this.Screen == 1 && this.CheckGame() == 1) {
            if (this.CurrentLevel == this.LevelMax) {
                this.Screen = 7;
                this.isDone = 1;
                try {
                    byte[] rec = new byte[10];
                    rec = String.valueOf(this.isDone).getBytes();
                    this.levelsaved.setRecord(1, rec, 0, rec.length);
                }
                catch (Exception exception) {}
            } else {
                this.Screen = 6;
            }
        }
        if (this.Screen == 0) {
            this.DrawStartScreen(g);
        } else if (this.Screen == 1) {
            g.drawImage(this.nen, 0, 0, 0);
            this.DrawBoxes(g);
            this.DrawKeys(g);
        } else if (this.Screen == 2) {
            this.DrawNewScreen(g);
        } else if (this.Screen == 3) {
            this.DrawHowScreen(g);
        } else if (this.Screen == 4) {
            this.DrawAboutScreen(g);
        } else if (this.Screen == 5) {
            this.DrawFinishedScreen(g);
        } else if (this.Screen == 6) {
            this.DrawPassScreen(g);
        } else if (this.Screen == 7) {
            this.DrawDoneScreen(g);
        }
    }

    public void MoveUp() {
        int c = this.Map[this.Yworker - 1][this.Xworker];
        int d = this.Box[this.Yworker - 1][this.Xworker];
        if (c != 1) {
            if (d != 1) {
                --this.Yworker;
                this.Direction = 0;
            } else if (this.Map[this.Yworker - 2][this.Xworker] != 1 && this.Box[this.Yworker - 2][this.Xworker] == 0) {
                this.Box[this.Yworker - 1][this.Xworker] = 0;
                this.Box[this.Yworker - 2][this.Xworker] = 1;
                --this.Yworker;
                this.Direction = 1;
            }
        }
    }

    public void MoveDown() {
        int c = this.Map[this.Yworker + 1][this.Xworker];
        int d = this.Box[this.Yworker + 1][this.Xworker];
        if (c != 1) {
            if (d != 1) {
                ++this.Yworker;
                this.Direction = 0;
            } else if (this.Map[this.Yworker + 2][this.Xworker] != 1 && this.Box[this.Yworker + 2][this.Xworker] == 0) {
                this.Box[this.Yworker + 1][this.Xworker] = 0;
                this.Box[this.Yworker + 2][this.Xworker] = 1;
                ++this.Yworker;
                this.Direction = 0;
            }
        }
    }

    public void MoveLeft() {
        int c = this.Map[this.Yworker][this.Xworker - 1];
        int d = this.Box[this.Yworker][this.Xworker - 1];
        if (c != 1) {
            if (d != 1) {
                --this.Xworker;
                this.Direction = 0;
            } else if (this.Map[this.Yworker][this.Xworker - 2] != 1 && this.Box[this.Yworker][this.Xworker - 2] == 0) {
                this.Box[this.Yworker][this.Xworker - 1] = 0;
                this.Box[this.Yworker][this.Xworker - 2] = 1;
                --this.Xworker;
                this.Direction = 2;
            }
        }
    }

    public void MoveRight() {
        int c = this.Map[this.Yworker][this.Xworker + 1];
        int d = this.Box[this.Yworker][this.Xworker + 1];
        if (c != 1) {
            if (d != 1) {
                ++this.Xworker;
                this.Direction = 0;
            } else if (this.Map[this.Yworker][this.Xworker + 2] != 1 && this.Box[this.Yworker][this.Xworker + 2] == 0) {
                this.Box[this.Yworker][this.Xworker + 1] = 0;
                this.Box[this.Yworker][this.Xworker + 2] = 1;
                ++this.Xworker;
                this.Direction = 3;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.Screen == 0) {
            if (x > 40 && x < 200 && y > 120 && y < 170) {
                try {
                    this.Tap = Image.createImage((String)"/screens/continuetap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.CurrentLevel != 0) {
                    this.isTap = 1;
                }
            }
            if (x > 40 && x < 200 && y > 170 && y < 220) {
                try {
                    this.CurrentScreen = Image.createImage((String)"/screens/newscreen.png");
                    this.Tap = Image.createImage((String)"/screens/newtap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 2;
            }
            if (x > 40 && x < 200 && y > 220 && y < 270) {
                try {
                    this.CurrentScreen = Image.createImage((String)"/screens/howscreen.png");
                    this.Tap = Image.createImage((String)"/screens/howtap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 3;
            }
            if (x > 40 && x < 200 && y > 270 && y < 320) {
                try {
                    this.CurrentScreen = Image.createImage((String)"/screens/aboutscreen.png");
                    this.Tap = Image.createImage((String)"/screens/abouttap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 4;
            }
            if (x > 40 && x < 200 && y > 320 && y < 370) {
                try {
                    this.Tap = Image.createImage((String)"/screens/exittap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 5;
            }
        } else if (this.Screen == 1) {
            if (x > 0 && x < 60 && y > 280) {
                try {
                    this.Tap = Image.createImage((String)"/screens/lefttap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 1;
            } else if (x > 60 && x < 180 && y > 280 && y < 340) {
                try {
                    this.Tap = Image.createImage((String)"/screens/uptap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 2;
            } else if (x > 60 && x < 180 && y > 340) {
                try {
                    this.Tap = Image.createImage((String)"/screens/downtap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 3;
            } else if (x > 180 && x < 240 && y > 280) {
                try {
                    this.Tap = Image.createImage((String)"/screens/righttap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 4;
            } else if (x > 0 && x < 81 && y > 227 && y < 277) {
                try {
                    this.Tap = Image.createImage((String)"/screens/menutap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 5;
            } else if (x > 159 && x < 240 && y > 227 && y < 277) {
                try {
                    this.Tap = Image.createImage((String)"/screens/resettap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 6;
            }
        } else if (this.Screen == 2) {
            if (x > 5 && x < 45 && y > 355 && y < 395) {
                this.isTap = 1;
            }
            if (x > 195 && x < 235 && y > 355 && y < 395) {
                this.isTap = 2;
            }
        } else if (this.Screen == 3) {
            if (x > 40 && x < 200 && y > 320 && y < 370) {
                try {
                    this.Tap = Image.createImage((String)"/screens/backtap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 1;
            }
        } else if (this.Screen == 4) {
            if (x > 40 && x < 200 && y > 320 && y < 370) {
                try {
                    this.Tap = Image.createImage((String)"/screens/backtap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 1;
            }
        } else if (this.Screen == 5) {
            if (x > 5 && x < 45 && y > 355 && y < 395) {
                this.isTap = 1;
            }
            if (x > 195 && x < 235 && y > 355 && y < 395) {
                this.isTap = 2;
            }
        } else if (this.Screen == 6) {
            if (x > 40 && x < 200 && y > 320 && y < 370) {
                try {
                    this.Tap = Image.createImage((String)"/screens/nexttap.png");
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.isTap = 1;
            }
        } else if (this.Screen == 7 && x > 40 && x < 200 && y > 320 && y < 370) {
            try {
                this.Tap = Image.createImage((String)"/screens/menutap.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isTap = 1;
        }
        this.repaint();
    }

    public void pointerReleased(int x, int y) {
        if (this.Screen == 0) {
            if (this.isTap == 1) {
                if (this.isDone == 0) {
                    this.initLevel();
                    this.Screen = 1;
                } else if (this.CurrentLevel != 0) {
                    this.Screen = 5;
                }
            } else if (this.isTap == 2) {
                if (this.CurrentLevel > 0) {
                    this.Screen = 2;
                } else {
                    this.NewGame();
                    this.Screen = 1;
                }
            } else if (this.isTap == 3) {
                this.Screen = 3;
            } else if (this.isTap == 4) {
                this.Screen = 4;
            } else if (this.isTap == 5) {
                this.saveRecStore();
                this.closeRecStore();
                this.midlet.exitMIDlet();
            }
        } else if (this.Screen == 2) {
            if (this.isTap == 1) {
                this.NewGame();
                try {
                    byte[] rec = new byte[10];
                    rec = String.valueOf(this.CurrentLevel).getBytes();
                    this.levelsaved.setRecord(2, rec, 0, rec.length);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.Screen = 1;
            }
            if (this.isTap == 2) {
                this.Screen = 0;
            }
        } else if (this.Screen == 3) {
            if (this.isTap == 1) {
                this.Screen = 0;
            }
        } else if (this.Screen == 4) {
            if (this.isTap == 1) {
                this.Screen = 0;
            }
        } else if (this.Screen == 1) {
            if (this.isTap == 2) {
                this.MoveUp();
            } else if (this.isTap == 3) {
                this.MoveDown();
            } else if (this.isTap == 1) {
                this.MoveLeft();
            } else if (this.isTap == 4) {
                this.MoveRight();
            } else if (this.isTap == 5) {
                this.Screen = 0;
            } else if (this.isTap == 6) {
                this.ResetLevel();
            }
        } else if (this.Screen == 5) {
            if (this.isTap == 1) {
                this.NewGame();
                this.Screen = 1;
            }
            if (this.isTap == 2) {
                this.Screen = 0;
            }
        } else if (this.Screen == 6) {
            if (this.isTap == 1) {
                this.Screen = 1;
                ++this.CurrentLevel;
                try {
                    byte[] rec = new byte[10];
                    rec = String.valueOf(this.CurrentLevel).getBytes();
                    this.levelsaved.setRecord(2, rec, 0, rec.length);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.initLevel();
            }
        } else if (this.Screen == 7 && this.isTap == 1) {
            this.Screen = 0;
        }
        this.isTap = 0;
        this.repaint();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.cmExit) {
            this.saveRecStore();
            this.closeRecStore();
            this.midlet.exitMIDlet();
        }
    }

    public void openRecStore() {
        try {
            this.levelsaved = RecordStore.openRecordStore((String)this.namedb, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeRecStore() {
        try {
            this.levelsaved.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeRecord(String str) {
        byte[] rec = str.getBytes();
        try {
            this.levelsaved.addRecord(rec, 0, rec.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readRecords() {
        try {
            byte[] recData = new byte[50];
            String tmp = null;
            recData = this.levelsaved.getRecord(1);
            tmp = new String(recData, 0, recData.length);
            this.isDone = Integer.parseInt(tmp);
            recData = this.levelsaved.getRecord(2);
            tmp = new String(recData, 0, recData.length);
            this.CurrentLevel = Integer.parseInt(tmp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteRecStore() {
        if (RecordStore.listRecordStores() != null) {
            try {
                RecordStore.deleteRecordStore((String)this.namedb);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void saveRecStore() {
        try {
            byte[] rec = new byte[10];
            rec = String.valueOf(this.isDone).getBytes();
            this.levelsaved.setRecord(1, rec, 0, rec.length);
            rec = String.valueOf(this.CurrentLevel).getBytes();
            this.levelsaved.setRecord(2, rec, 0, rec.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void PlaySoundMove() {
        try {
            this.is = ((Object)((Object)this)).getClass().getResourceAsStream("move.wav");
            this.p = Manager.createPlayer((InputStream)this.is, (String)"audio/X-wav");
            this.p.realize();
            this.p.prefetch();
            this.p.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void PlaySoundSelect() {
    }

    public void PlaySoundPass() {
    }

    public void PlaySoundDone() {
    }
}

