/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ColorManagement {
    int[][] color;
    int[][] lum;
    static int TYPE_HUE = 0;
    static int TYPE_SATURATION = 1;
    static int TYPE_VALUE = 2;
    Random rnd = new Random();
    int bgColor = 0;
    int gridX = 10;
    int gridY = 10;
    int[] colorNumber;
    int colorMaximum = 5;
    int mostUsedColor = 0;
    int avgLum = 0;
    int someColor;

    ColorManagement() {
    }

    int getBGColor() {
        return this.bgColor;
    }

    public Image changeWallColor(Image imgImplementation, int percent) {
        int i;
        int[] rgbImplementationData = new int[imgImplementation.getHeight() * imgImplementation.getWidth()];
        imgImplementation.getRGB(rgbImplementationData, 0, imgImplementation.getWidth(), 0, 0, imgImplementation.getWidth(), imgImplementation.getHeight());
        int finalColor = this.nearAvgLum(percent);
        int finalRed = finalColor >> 16 & 0xFF;
        int finalGreen = finalColor >> 8 & 0xFF;
        int finalBlue = finalColor >> 0 & 0xFF;
        System.out.println("FINAL   RED=" + finalRed + "   GREEN= " + finalGreen + "   BLUE= " + finalGreen);
        int IMAGE_BRIGHTNESS = 0;
        int lightColor = 0;
        for (i = 0; i < imgImplementation.getWidth() * imgImplementation.getHeight(); ++i) {
            int red = rgbImplementationData[i] >> 16 & 0xFF;
            int green = rgbImplementationData[i] >> 8 & 0xFF;
            int blue = rgbImplementationData[i] >> 0 & 0xFF;
            IMAGE_BRIGHTNESS += (red + green + blue) / 3;
            if (lightColor >= (red + green + blue) / 3) continue;
            lightColor = (red + green + blue) / 3;
        }
        System.out.println("DARK  COLOR" + lightColor);
        IMAGE_BRIGHTNESS /= imgImplementation.getWidth() * imgImplementation.getHeight();
        for (i = 0; i < imgImplementation.getWidth() * imgImplementation.getHeight(); ++i) {
            int color = rgbImplementationData[i];
            int a2 = color >> 24 & 0xFF;
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color >> 0 & 0xFF;
            int avg = (red + green + blue) / 3;
            int per = 100;
            int finalAvg = (finalRed + finalGreen + finalBlue) / 3;
            if (avg > 0) {
                per = 100 + (avg - lightColor) * 100 / avg;
            }
            int r = finalRed + finalAvg * per / 100;
            int g = finalGreen + finalAvg * per / 100;
            int b = finalBlue + finalAvg * per / 100;
            r = r > 255 ? 255 : r;
            r = r < 0 ? 0 : r;
            g = g > 255 ? 255 : g;
            g = g < 0 ? 0 : g;
            b = b > 255 ? 255 : b;
            b = b < 0 ? 0 : b;
            color = a2 > 254 ? 0xFF000000 | r << 16 | g << 8 | b : 0;
            rgbImplementationData[i] = color;
        }
        return Image.createRGBImage((int[])rgbImplementationData, (int)imgImplementation.getWidth(), (int)imgImplementation.getHeight(), (boolean)true);
    }

    public Image changeMultiColor(Image imgImplementation, int top) {
        int[] rgbImplementationData = new int[imgImplementation.getHeight() * imgImplementation.getWidth()];
        imgImplementation.getRGB(rgbImplementationData, 0, imgImplementation.getWidth(), 0, 0, imgImplementation.getWidth(), imgImplementation.getHeight());
        int finalColor = this.nearAvgLum(10);
        int finalRed = finalColor >> 16 & 0xFF;
        int finalGreen = finalColor >> 8 & 0xFF;
        int finalBlue = finalColor >> 0 & 0xFF;
        System.out.println("Red= " + finalRed + " Green=  " + finalGreen + "  Blue= " + finalBlue);
        float[] fC = this.RGBtoHSV(finalColor);
        System.out.println("HUE OF SELECTED COLOR  " + fC[0]);
        int H = (int)((240.0f - fC[0]) * 100.0f / 240.0f);
        int S = (int)((1.0f - fC[1]) * 100.0f);
        for (int i = 0; i < imgImplementation.getWidth() * imgImplementation.getHeight(); ++i) {
            int color = rgbImplementationData[i];
            int a2 = color >> 24 & 0xFF;
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color >> 0 & 0xFF;
            float[] f = this.RGBtoHSV(color);
            f[0] = f[0] * (float)H / 100.0f;
            f[0] = this.colorCheck(f[0]);
            f[2] = this.colorCheck(f[2]);
            if (a2 > 254) {
                color = this.HSVtoRGB(f[0], f[1], f[2]);
                red = color >> 16 & 0xFF;
                green = color >> 8 & 0xFF;
                blue = color >> 0 & 0xFF;
                color = 0xFF000000 | red << 16 | green << 8 | blue;
            } else {
                color = 0;
            }
            rgbImplementationData[i] = color;
        }
        if (top == 1) {
            int avgR = 128;
            int avgG = 128;
            int avgB = 128;
            for (int i = 0; i < imgImplementation.getWidth() * 20; ++i) {
                int color = rgbImplementationData[i];
                int red = color >> 16 & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color >> 0 & 0xFF;
                avgR = (avgR + red) / 2;
                avgG = (avgG + green) / 2;
                avgB = (avgB + blue) / 2;
            }
            this.bgColor = 0xFF000000 | avgR << 16 | avgG << 8 | avgB;
        }
        return Image.createRGBImage((int[])rgbImplementationData, (int)imgImplementation.getWidth(), (int)imgImplementation.getHeight(), (boolean)true);
    }

    int nearAvgLum(int percent) {
        int newLum = this.avgLum * (100 + percent) / 100;
        System.out.println("new LUM   " + newLum);
        int closeLum = 255;
        int closeColor = 0;
        int finalLum = 0;
        int locX = 0;
        int locY = 0;
        for (int x = 0; x < this.gridX; ++x) {
            for (int y = 0; y < this.gridY; ++y) {
                if (this.abs(this.lum[x][y] - newLum) > closeLum) continue;
                closeLum = this.abs(this.lum[x][y] - newLum);
                closeColor = this.color[x][y];
                finalLum = this.lum[x][y];
                locX = x;
                locY = y;
            }
        }
        System.out.println("locX =  " + locX + "  locY=  " + locY);
        return closeColor;
    }

    void getMaximumColor(Image imgSource) {
        int[] rgbData = new int[imgSource.getHeight() * imgSource.getWidth()];
        imgSource.getRGB(rgbData, 0, imgSource.getWidth(), 0, 0, imgSource.getWidth(), imgSource.getHeight());
        int width = imgSource.getWidth();
        int height = imgSource.getHeight();
        int n = -1;
        int[] nRepeat = new int[width * height];
        int avgR = 0;
        int avgG = 0;
        int avgB = 0;
        int pp = 0;
        this.colorNumber = new int[this.colorMaximum];
        this.color = new int[this.gridX][this.gridY];
        this.lum = new int[this.gridX][this.gridY];
        for (int i = 0; i < width * height; i += 4) {
            int c = rgbData[i];
            int red = c >> 16 & 0xFF;
            int green = c >> 8 & 0xFF;
            int blue = c >> 0 & 0xFF;
            int x = i % width;
            int y = i / width;
            int locX = x / (width / this.gridX + 1);
            int locY = y / (height / this.gridY + 1);
            int c1 = this.color[locX][locY];
            int red1 = c1 >> 16 & 0xFF;
            int green1 = c1 >> 8 & 0xFF;
            int blue1 = c1 >> 0 & 0xFF;
            int red2 = (red + red1) / 2;
            int green2 = (green + green1) / 2;
            int blue2 = (blue + blue1) / 2;
            avgR += red1;
            avgG += green1;
            avgB += blue;
            int lum1 = 299 * red1 / 1000 + 587 * green1 / 1000 + 114 * blue1 / 1000;
            this.color[locX][locY] = 0xFF000000 | red2 << 16 | green2 << 8 | blue2;
            this.lum[locX][locY] = lum1;
            this.avgLum += lum1;
            ++pp;
        }
        this.avgLum /= pp;
        System.out.println("AVG   LUM" + this.avgLum);
        this.mostUsedColor = 0xFF000000 | avgR << 16 | avgG << 8 | avgB;
    }

    int getHighestColor() {
        int x = this.rnd.nextInt(this.gridX);
        int y = this.rnd.nextInt(this.gridY);
        return this.color[x][y];
    }

    void printValue(int color, int i) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color >> 0 & 0xFF;
        System.out.println(i + "    RED === " + red + "   GREEN === " + green + "   Blue === " + blue);
    }

    void drawGrid(Graphics g) {
        for (int x = 0; x < this.gridX; ++x) {
            for (int y = 0; y < this.gridY; ++y) {
                g.setColor(this.color[x][y]);
                g.fillRect(x * 24, y * 24, 24, 24);
                g.setColor(255, 255, 255);
                g.drawString("" + this.lum[x][y], x * 24, y * 24, 0);
                if (this.lum[x][y] != 105) continue;
                int color1 = this.color[x][y];
                int red = color1 >> 16 & 0xFF;
                int green = color1 >> 8 & 0xFF;
                int blue = color1 >> 0 & 0xFF;
            }
        }
    }

    int abs(int n) {
        if (n < 0) {
            return n * -1;
        }
        return n;
    }

    int colorCheck(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 360) {
            n = 360;
        }
        return n;
    }

    float colorCheck(float n) {
        if (n < 0.0f) {
            n = 0.0f;
        }
        if (n > 360.0f) {
            n = 360.0f;
        }
        return n;
    }

    float colorShift(float n) {
        if (n < 0.0f) {
            n = 255.0f + n;
        }
        if (n > 254.0f) {
            n -= 254.0f;
        }
        return n;
    }

    float[] RGBtoHSV(int color) {
        float max;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        float[] hsv = new float[3];
        float min = Math.min(Math.min(r, g), b);
        float v = max = (float)Math.max(Math.max(r, g), b);
        float delta = max - min;
        if (max == 0.0f) {
            float h;
            float s = 0.0f;
            hsv[0] = h = -1.0f;
            hsv[1] = s;
            hsv[2] = v;
            return hsv;
        }
        float s = delta / max;
        float h = (float)r == max ? (float)(g - b) / delta : ((float)g == max ? 2.0f + (float)(b - r) / delta : 4.0f + (float)(r - g) / delta);
        h *= 60.0f;
        if (h < 0.0f) {
            h += 360.0f;
        }
        hsv[0] = h;
        hsv[1] = s;
        hsv[2] = v;
        return hsv;
    }

    public int HSVtoRGB(float h, float s, float v) {
        float b;
        float g;
        float r;
        if (s == 0.0f) {
            float b2;
            float g2 = b2 = v;
            float r2 = b2;
            return 0xFF000000 | (int)r2 << 16 | (int)g2 << 8 | (int)b2;
        }
        int i = (int)Math.floor(h /= 60.0f);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            default: {
                r = v;
                g = p;
                b = q;
            }
        }
        return 0xFF000000 | (int)r << 16 | (int)g << 8 | (int)b;
    }
}

