/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.cubeMatch.gamePlay.modes;

import java.util.Vector;
import tv.ingames.cubeMatch.application.ScreenParametersApplication;
import tv.ingames.cubeMatch.gamePlay.SettingsGamePlay;
import tv.ingames.cubeMatch.gamePlay.levels.LevelsActionPlus;
import tv.ingames.cubeMatch.gamePlay.modes.AbstractGamePlayMode;
import tv.ingames.j2dm.display.textfield.J2DM_NumberField;
import tv.ingames.j2dm.display.textfield.J2DM_TextField;
import tv.ingames.j2dm.gameplay.IStatePlaying;
import tv.ingames.j2dm.matchLibrary.ballType.J2DM_TypeColorBall;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_Ball;
import tv.ingames.j2dm.media.languaje.J2DM_Language;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.stage.J2DM_Stage;
import tv.ingames.j2dm.utils.J2DM_StringTools;

public class PlayingModeActionPlus
extends AbstractGamePlayMode {
    private int[] _vectorCubesLeftPerColor;
    private J2DM_TextField _textfieldTimeLeft;
    private int _timeLimit;

    public PlayingModeActionPlus(IStatePlaying statePlaying, J2DM_Image imageBackGround, J2DM_Graphics graphicsBackGround) {
        super(statePlaying, imageBackGround, graphicsBackGround);
        this._levelManager = new LevelsActionPlus();
        SettingsGamePlay.getInstance().setTotalLevels(this._levelManager.getCantLevels());
    }

    protected boolean canClick() {
        return !this.checkIfThereIsAnyBallMoving();
    }

    protected boolean canMoveHorizontal() {
        return false;
    }

    protected boolean canAddNewBrickonExplode() {
        return true;
    }

    protected void callInitLevel_2() {
        this._timeLimit = this._dataLevel.timeDownGameOver;
        this._vectorCubesLeftPerColor = new int[this._dataLevel.cantColors];
        int i = 0;
        while (i < this._dataLevel.cantColors) {
            this._vectorCubesLeftPerColor[i] = this._dataLevel.cantMatchColorBalls;
            ++i;
        }
        this.showCubesShape(ScreenParametersApplication.PLY_MAXX_CUBES_LEFT);
        J2DM_TextField textField = new J2DM_TextField(ScreenParametersApplication.FONT_GAME, J2DM_Language.getInstance().getTextByKey(91));
        textField.setX(ScreenParametersApplication.PLY_TXT_TIME_LEFT_X);
        textField.setY(ScreenParametersApplication.PLY_TXT_TIME_LEFT_Y);
        textField.setAnchorX(1);
        textField.setAnchorY(2);
        textField.draw(this._graphicsBackGround);
        textField.destroy();
        textField = null;
        this._textfieldTimeLeft = new J2DM_TextField(ScreenParametersApplication.FONT_GAME, J2DM_StringTools.getTimeFromMilliseconds(this._timeLimit));
        this._textfieldTimeLeft.setX(ScreenParametersApplication.PLY_VALUE_TIME_LEFT_X);
        this._textfieldTimeLeft.setY(ScreenParametersApplication.PLY_VALUE_TIME_LEFT_Y);
        this._textfieldTimeLeft.setAnchorX(1);
        this._textfieldTimeLeft.setAnchorY(2);
        J2DM_Stage.getInstance().addElement(this._textfieldTimeLeft, 2);
    }

    protected boolean canDestroyOneBall() {
        return false;
    }

    protected void callDestroyVectorOfBalls(Vector structBalls) {
        if (structBalls == null) {
            return;
        }
        int i = 0;
        while (i < structBalls.size()) {
            J2DM_Ball ball = (J2DM_Ball)structBalls.elementAt(i);
            int color = ((J2DM_TypeColorBall)ball.getTypeBall())._color;
            if (color < this._vectorCubesLeftPerColor.length && this._vectorCubesLeftPerColor[color] > 0) {
                int n = color;
                this._vectorCubesLeftPerColor[n] = this._vectorCubesLeftPerColor[n] - 1;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this._tfCubes.size()) {
            J2DM_NumberField numberField = (J2DM_NumberField)this._tfCubes.elementAt(i2);
            numberField.setTextNumber(this._vectorCubesLeftPerColor[i2]);
            ++i2;
        }
    }

    public void destroy() {
        J2DM_Stage.getInstance().removeElement(this._textfieldTimeLeft, 2);
        this._textfieldTimeLeft.destroy();
        this._textfieldTimeLeft = null;
        super.destroy();
    }

    protected boolean hasLevelFinished() {
        if (!this.checkIfThereIsAnyBallMoving()) {
            int i = 0;
            while (i < this._vectorCubesLeftPerColor.length) {
                if (this._vectorCubesLeftPerColor[i] > 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected void takeScreenShot(J2DM_Graphics graphics) {
        super.takeScreenShot(graphics);
        int i = 0;
        while (i < this._tfCubes.size()) {
            J2DM_NumberField numberField = (J2DM_NumberField)this._tfCubes.elementAt(i);
            numberField.draw(graphics);
            ++i;
        }
        this._textfieldTimeLeft.draw(graphics);
    }

    protected boolean isGameOver() {
        long timeNow = System.currentTimeMillis();
        int timeLeft = (int)((long)this._timeLimit - (timeNow - this._timePause - this._timeStart));
        if (timeLeft < 0) {
            timeLeft = 0;
        }
        this._textfieldTimeLeft.setText(J2DM_StringTools.getTimeFromMilliseconds(timeLeft));
        if (!this.checkIfThereIsAnyBallMoving() && timeLeft <= 0) {
            int i = 0;
            while (i < this._vectorCubesLeftPerColor.length) {
                if (this._vectorCubesLeftPerColor[i] > 0) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

