/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.cubeMatch.gamePlay.modes;

import java.util.Vector;
import tv.ingames.cubeMatch.application.ScreenParametersApplication;
import tv.ingames.cubeMatch.gamePlay.SettingsGamePlay;
import tv.ingames.cubeMatch.gamePlay.levels.LevelsClassic;
import tv.ingames.cubeMatch.gamePlay.modes.AbstractGamePlayMode;
import tv.ingames.cubeMatch.loaders.ExternalFiles;
import tv.ingames.j2dm.display.J2DM_Sprite;
import tv.ingames.j2dm.gameplay.IStatePlaying;
import tv.ingames.j2dm.loader.J2DM_Loader;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.stage.J2DM_Stage;

public class PlayingModeClassic
extends AbstractGamePlayMode {
    public static final int SCORE_NEW_LIVE = 10000;
    public static final int INIT_NUMBER_MAGIC_HANDS = 6;
    public static final int MAX_NUMBER_MAGIC_HANDS = 9;
    private Vector _magicHandsSprites;
    private int _maxMagicHands;

    public PlayingModeClassic(IStatePlaying statePlaying, J2DM_Image imageBackGround, J2DM_Graphics graphicsBackGround) {
        super(statePlaying, imageBackGround, graphicsBackGround);
        this._levelManager = new LevelsClassic();
        SettingsGamePlay.getInstance().setTotalLevels(this._levelManager.getCantLevels());
    }

    protected boolean canClick() {
        return !this.checkIfThereIsAnyBallMoving();
    }

    protected void callInitLevel_1() {
        this._maxMagicHands = 9;
        this._magicHandsSprites = new Vector();
        J2DM_Image imageMagicHand = J2DM_Loader.getInstance().getImageById(ExternalFiles.MAGIC_HAND);
        int i = 0;
        while (i < this._maxMagicHands) {
            J2DM_Sprite magicHand = new J2DM_Sprite(imageMagicHand);
            this._magicHandsSprites.addElement(magicHand);
            ++i;
        }
    }

    protected void callInitLevel_2() {
        J2DM_Image imageMagicHand = J2DM_Loader.getInstance().getImageById(ExternalFiles.MAGIC_HAND);
        int i = 0;
        while (i < this._maxMagicHands) {
            J2DM_Sprite magicHand = (J2DM_Sprite)this._magicHandsSprites.elementAt(i);
            J2DM_Stage.getInstance().addElement(magicHand, 2);
            magicHand.setX(ScreenParametersApplication.PLY_MAGIC_HAND_X0 + ScreenParametersApplication.PLY_MAGIC_HAND_DELTAX * (i % 3) - imageMagicHand.getWidth() / 2 + (int)((double)ScreenParametersApplication.PLY_MAGIC_HAND_DELTAX * 0.5));
            magicHand.setY(ScreenParametersApplication.PLY_MAGIC_HAND_Y0 + ScreenParametersApplication.PLY_MAGIC_HAND_DELTAY * (i / 3) - imageMagicHand.getHeight() / 2);
            if (i >= SettingsGamePlay.getInstance().getMagicHands()) {
                magicHand.setVisible(false);
            }
            ++i;
        }
    }

    protected boolean canDestroyOneBall() {
        return SettingsGamePlay.getInstance().getMagicHands() > 0;
    }

    protected void callDestroyOneBall() {
        this.delMagicHand();
    }

    private void addMagicHand() {
        SettingsGamePlay.getInstance().setMagicHands(SettingsGamePlay.getInstance().getMagicHands() + 1);
        ((J2DM_Sprite)this._magicHandsSprites.elementAt(SettingsGamePlay.getInstance().getMagicHands() - 1)).setVisible(true);
        this.playSoundWinMagicHand();
    }

    private void delMagicHand() {
        ((J2DM_Sprite)this._magicHandsSprites.elementAt(SettingsGamePlay.getInstance().getMagicHands() - 1)).setVisible(false);
        SettingsGamePlay.getInstance().setMagicHands(SettingsGamePlay.getInstance().getMagicHands() - 1);
        this.playSoundUseMagicHand();
    }

    public void destroy() {
        super.destroy();
        int i = 0;
        while (i < this._maxMagicHands) {
            J2DM_Sprite magicHand = (J2DM_Sprite)this._magicHandsSprites.elementAt(i);
            J2DM_Stage.getInstance().removeElement(magicHand, 2);
            magicHand.destroy();
            Object var2_2 = null;
            ++i;
        }
        this._magicHandsSprites.removeAllElements();
        this._magicHandsSprites = null;
        this._levelManager = null;
    }

    protected boolean hasLevelFinished() {
        if (!this.checkIfThereIsAnyBallMoving()) {
            return !this.checkIfThereIsAnyBallInMatrix();
        }
        return false;
    }

    protected boolean isGameOver() {
        return !this.checkIfThereIsAnyBallMoving() && SettingsGamePlay.getInstance().getMagicHands() == 0 && !this.checkIfThereIsAnyBallWithFreeMatching();
    }

    protected void callActualizeScore(int value) {
        int deltaOld = this._score / 10000;
        int deltaNew = (this._score + value) / 10000;
        if (deltaOld != deltaNew && SettingsGamePlay.getInstance().getMagicHands() < this._maxMagicHands) {
            this.addMagicHand();
            this.playSoundUseMagicHand();
        }
    }

    protected void takeScreenShot(J2DM_Graphics graphics) {
        super.takeScreenShot(graphics);
        int i = 0;
        while (i < SettingsGamePlay.getInstance().getMagicHands()) {
            J2DM_Sprite magicHand = (J2DM_Sprite)this._magicHandsSprites.elementAt(i);
            magicHand.draw(graphics);
            ++i;
        }
    }
}

