/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.cubeMatch.gamePlay.modes;

import java.util.Vector;
import tv.ingames.cubeMatch.application.ScreenParametersApplication;
import tv.ingames.cubeMatch.gamePlay.SettingsGamePlay;
import tv.ingames.cubeMatch.gamePlay.levels.LevelsPuzzle;
import tv.ingames.cubeMatch.gamePlay.modes.AbstractGamePlayMode;
import tv.ingames.j2dm.display.textfield.J2DM_NumberField;
import tv.ingames.j2dm.display.textfield.J2DM_TextField;
import tv.ingames.j2dm.gameplay.IStatePlaying;
import tv.ingames.j2dm.media.languaje.J2DM_Language;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.stage.J2DM_Stage;

public class PlayingModePuzzle
extends AbstractGamePlayMode {
    private int _cubesLeft;
    private J2DM_NumberField _textfieldCubesLeft;

    public PlayingModePuzzle(IStatePlaying statePlaying, J2DM_Image imageBackGround, J2DM_Graphics graphicsBackGround) {
        super(statePlaying, imageBackGround, graphicsBackGround);
        this._levelManager = new LevelsPuzzle();
        SettingsGamePlay.getInstance().setTotalLevels(this._levelManager.getCantLevels());
    }

    protected boolean canClick() {
        return !this.checkIfThereIsAnyBallMoving();
    }

    protected boolean canMoveHorizontal() {
        return true;
    }

    protected boolean canAddNewBrickonExplode() {
        return false;
    }

    protected void callInitLevel_2() {
        this._cubesLeft = this._dataLevel.cantBallsToDestroy;
        J2DM_TextField textField = new J2DM_TextField(ScreenParametersApplication.FONT_GAME, J2DM_Language.getInstance().getTextByKey(90));
        textField.setX(ScreenParametersApplication.PLY_TXT_CUBES_LEFT_X);
        textField.setY(ScreenParametersApplication.PLY_TXT_CUBES_LEFT_Y);
        textField.setAnchorX(1);
        textField.setAnchorY(2);
        textField.draw(this._graphicsBackGround);
        textField.destroy();
        textField = null;
        this._textfieldCubesLeft = new J2DM_NumberField(ScreenParametersApplication.NUMBER_FONT_GAME, this._cubesLeft);
        this._textfieldCubesLeft.setX(ScreenParametersApplication.PLY_VALUE_CUBES_LEFT_X);
        this._textfieldCubesLeft.setY(ScreenParametersApplication.PLY_VALUE_CUBES_LEFT_Y);
        this._textfieldCubesLeft.setAnchorX(1);
        this._textfieldCubesLeft.setAnchorY(2);
        J2DM_Stage.getInstance().addElement(this._textfieldCubesLeft, 2);
    }

    protected boolean canDestroyOneBall() {
        return false;
    }

    protected void callDestroyVectorOfBalls(Vector balls) {
        if (balls != null) {
            this._cubesLeft -= balls.size();
            if (this._cubesLeft < 0) {
                this._cubesLeft = 0;
            }
        }
        this._textfieldCubesLeft.setTextNumber(this._cubesLeft);
    }

    public void destroy() {
        J2DM_Stage.getInstance().removeElement(this._textfieldCubesLeft, 2);
        this._textfieldCubesLeft.destroy();
        this._textfieldCubesLeft = null;
        super.destroy();
    }

    protected boolean hasLevelFinished() {
        if (!this.checkIfThereIsAnyBallMoving()) {
            boolean ballsInMatrix = this.checkIfThereIsAnyBallInMatrix();
            if (!ballsInMatrix) {
                return true;
            }
            boolean isAnyMatchingBall = this.checkIfThereIsAnyBallWithFreeMatching();
            if (!isAnyMatchingBall && this._cubesLeft <= 0) {
                return true;
            }
        }
        return false;
    }

    protected boolean isGameOver() {
        return !this.checkIfThereIsAnyBallMoving() && !this.checkIfThereIsAnyBallWithFreeMatching() && this._cubesLeft > 0;
    }

    protected void takeScreenShot(J2DM_Graphics graphics) {
        super.takeScreenShot(graphics);
        this._textfieldCubesLeft.draw(graphics);
    }
}

