/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.core;

import tv.ingames.j2dm.core.ICommonBehavior;
import tv.ingames.j2dm.core.J2DM_AbstractGameLoop;
import tv.ingames.j2dm.core.J2DM_AbstractStateParameters;
import tv.ingames.j2dm.loader.ILoader;
import tv.ingames.j2dm.loader.J2DM_AbstractLoaderProgress;
import tv.ingames.j2dm.loader.J2DM_DefaultLoaderProgress;
import tv.ingames.j2dm.loader.J2DM_Loader;
import tv.ingames.j2dm.loader.items.J2DM_ItemLoader;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.system.input.IListenKeyboard;

public class J2DM_AbstractState
implements ICommonBehavior,
IListenKeyboard,
ILoader {
    protected J2DM_AbstractStateParameters _params;
    protected J2DM_AbstractGameLoop _gameLoop;
    protected int[] _itemsLoaderIds;
    protected int _state;
    private boolean _implementPreload;
    protected J2DM_AbstractLoaderProgress _loaderProgress;
    private static boolean _useGc = false;

    public J2DM_AbstractState() {
        this.init();
    }

    public J2DM_AbstractState(J2DM_AbstractStateParameters params) {
        this.setParameters(params);
        this.init();
    }

    private void init() {
        J2DM_AbstractState.gc();
        J2DM_Loader.getInstance().suscribeElement(this);
    }

    public static void setUseGC(boolean value) {
        _useGc = value;
    }

    public static boolean getUseGC() {
        return _useGc;
    }

    public static void gc() {
        if (_useGc) {
            System.gc();
        }
    }

    public static void gcCommit() {
        System.gc();
    }

    public void create() {
    }

    public void destroy() {
        J2DM_Loader.getInstance().unsuscribeElement(this);
    }

    public void update() {
    }

    public void setParameters(J2DM_AbstractStateParameters params) {
        this._params = params;
        if (this._params.getGameLoop() == null) {
            J2DM_Console.getInstance().addLog("J2DM_AbstractState::Constructor", "gameloop parameter is null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        } else {
            this._gameLoop = this._params.getGameLoop();
        }
    }

    public final void loadResources(int[] itemsLoaderIds, boolean showPreloader) {
        this.loadResources(itemsLoaderIds, showPreloader, null);
    }

    public final void loadResources(int[] itemsLoaderIds, boolean showPreloader, J2DM_AbstractLoaderProgress preloader) {
        this._itemsLoaderIds = itemsLoaderIds;
        this._state = 1;
        this._implementPreload = showPreloader;
        if (this._implementPreload) {
            this._loaderProgress = preloader != null ? preloader : new J2DM_DefaultLoaderProgress();
            this._loaderProgress.show();
        }
        J2DM_Loader.getInstance().loadResources(this._itemsLoaderIds);
    }

    public void onFinishState(int typeButton) {
    }

    public void onFinishState() {
    }

    public void onItemLoaderFinish(J2DM_ItemLoader item) {
        boolean isComplete = J2DM_Loader.getInstance().checkCompleteStateByVector(this._itemsLoaderIds);
        if (isComplete && this._state != 0) {
            this._state = 0;
            if (this._loaderProgress != null) {
                this._loaderProgress.destroy();
            }
            this.loadResourcesComplete();
        }
    }

    protected void loadResourcesComplete() {
    }

    public void keyPressed(char key) {
    }

    public void keyReleased(char key) {
    }

    public void keyRepeated(char key) {
    }

    public void specialKeyPressed(int keyCode) {
    }

    public void specialKeyReleased(int keyCode) {
    }

    public void specialKeyRepeated(int keyCode) {
    }
}

