/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.display.textfield;

import tv.ingames.j2dm.display.J2DM_GameObject;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.system.fonts.J2DM_Font;
import tv.ingames.j2dm.system.fonts.J2DM_FontsManager;
import tv.ingames.j2dm.utils.J2DM_Rect;
import tv.ingames.j2dm.utils.J2DM_StringTools;

public class J2DM_TextField
extends J2DM_GameObject {
    protected J2DM_Font _font;
    protected String[] _text;
    protected int _anchorX;
    protected int _anchorY;
    protected int _interLine;
    protected int _size;

    public J2DM_TextField(String fontName, String text, String name) {
        super(name);
        this.create(fontName);
        this.setText(text);
    }

    public J2DM_TextField(String fontName, String text) {
        this.create(fontName);
        this.setText(text);
    }

    public J2DM_TextField(String fontName, String[] text) {
        this.create(fontName);
        this.setText(text);
    }

    private void create(String fontName) {
        this.setFont(fontName);
        this._anchorX = 1;
        this._anchorY = 16;
        if (this._font != null) {
            this._interLine = this._font.getInterline();
            this._size = this._font.getSize();
        }
    }

    public void setText(String text) {
        this._text = J2DM_StringTools.split(text, "|");
    }

    public void setText(String[] text) {
        this._text = text;
    }

    public String[] getText() {
        return this._text;
    }

    public int getInterline() {
        return this._interLine;
    }

    public void setInterline(int interLine) {
        this._interLine = interLine;
    }

    public int getAnchorX() {
        return this._anchorX;
    }

    public void setAnchorX(int anchorX) {
        this._anchorX = anchorX;
    }

    public int getAnchorY() {
        return this._anchorY;
    }

    public void setAnchorY(int anchorY) {
        this._anchorY = anchorY;
    }

    public void setFont(String fontName) {
        this._font = J2DM_FontsManager.getInstance().getFont(fontName);
        if (this._font == null) {
            J2DM_Console.getInstance().addLog("J2DM_TextField::setFont", "Font is null, fontName:" + fontName, J2DM_ConsoleMessageTypes.ERROR);
            return;
        }
    }

    public void clean() {
        if (this._text != null) {
            int cantLines = this._text.length;
            int i = 0;
            while (i < cantLines) {
                this._text[i] = null;
                ++i;
            }
        }
    }

    public void SetFullState(int x, int y, int anchorX, int anchorY, String[] texts) {
        this._x = x;
        this._y = y;
        this._anchorX = anchorX;
        this._anchorY = anchorY;
        this.setText(texts);
    }

    public void SetFullState(int x, int y, int anchorX, int anchorY, String text) {
        this._x = x;
        this._y = y;
        this._anchorX = anchorX;
        this._anchorY = anchorY;
        this.clean();
        this.setText(text);
    }

    public void draw(J2DM_Graphics g, int xValue, int yValue, int anchorX, int anchorY) {
        this.setX(xValue);
        this.setY(yValue);
        this.setAnchorX(anchorX);
        this.setAnchorY(anchorY);
        this.draw(g);
    }

    public void draw(J2DM_Graphics g) {
        if (this._text == null || this._font == null || !this._font.isReady()) {
            return;
        }
        if (this._enabled) {
            g.setGlobalAlpha(this._alpha);
        } else {
            g.setGlobalAlpha(this._alphaDisable);
        }
        String abc = this._font.getAbc();
        J2DM_Rect[] rect = this._font.getRect();
        J2DM_Image image = this._font.getImage();
        int ycar = 0;
        int cantLines = this._text.length;
        int y0 = this.getYinitFromAnchor(this._text, this._anchorY);
        int i = 0;
        while (i < cantLines) {
            if (this._text[i] != null) {
                int x0 = this.getXinitFromAnchor(this._text[i], this._anchorX);
                int cantLetters = this._text[i].length();
                int xcar = 0;
                int j = 0;
                while (j < cantLetters) {
                    int indLetter = abc.indexOf(this._text[i].charAt(j));
                    if (indLetter >= 0) {
                        int xActual = this._x + this._xGlobal + x0 + xcar;
                        int yActual = this._y + this._yGlobal + y0 + ycar;
                        g.drawImage(xActual, yActual, rect[indLetter]._width, rect[indLetter]._height, image, rect[indLetter]._x, rect[indLetter]._y);
                        xcar += rect[indLetter]._width;
                    }
                    ++j;
                }
                ycar += this._interLine;
            }
            ++i;
        }
    }

    private int getXinitFromAnchor(String text, int anchorX) {
        int xInit = 0;
        int cantLetters = text.length();
        int widthInPixels = 0;
        String abc = this._font.getAbc();
        J2DM_Rect[] rect = this._font.getRect();
        int i = 0;
        while (i < cantLetters) {
            int indLetter = abc.indexOf(text.charAt(i));
            if (indLetter >= 0) {
                widthInPixels += rect[indLetter]._width;
            }
            ++i;
        }
        switch (anchorX) {
            case 4: {
                xInit = 0;
                break;
            }
            case 8: {
                xInit = -widthInPixels;
                break;
            }
            case 1: {
                xInit = -widthInPixels / 2;
            }
        }
        return xInit;
    }

    private int getYinitFromAnchor(String[] text, int anchorY) {
        int yInit = 0;
        int cantRows = text.length;
        int heightInPixels = cantRows * this._size;
        switch (anchorY) {
            case 16: {
                yInit = 0;
                break;
            }
            case 32: {
                yInit = -heightInPixels;
                break;
            }
            case 2: {
                yInit = -heightInPixels / 2;
            }
        }
        return yInit;
    }

    public void destroy() {
        super.destroy();
        this._font = null;
        this._text = null;
    }
}

