/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.media;

import java.util.Hashtable;
import tv.ingames.j2dm.display.sprite.bitmapRender.J2DM_SpriteAnimation;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.utils.J2DM_Point;
import tv.ingames.j2dm.utils.J2DM_Rect;
import tv.ingames.j2dm.utils.J2DM_StringTools;

public class J2DM_AnimationLibrary {
    private static J2DM_AnimationLibrary _instance;
    private static Hashtable _library;

    private J2DM_AnimationLibrary() {
    }

    public static J2DM_AnimationLibrary getInstance() {
        if (_instance == null) {
            _instance = new J2DM_AnimationLibrary();
        }
        return _instance;
    }

    public boolean addAnimationToKey(String key, J2DM_Image image, String animationName, J2DM_Rect[] rectArray, int anchorX, int anchorY) {
        if (this.checkAddAnimationToKey(key, image, animationName)) {
            Hashtable subLibrary = (Hashtable)_library.get(key);
            subLibrary.put(animationName, new J2DM_SpriteAnimation(animationName, image, rectArray, anchorX, anchorY));
            return true;
        }
        return false;
    }

    public boolean addAnimationToKey(String key, J2DM_Image image, String animationName, J2DM_Rect[] rectArray, J2DM_Point point) {
        if (this.checkAddAnimationToKey(key, image, animationName)) {
            J2DM_Point[] pointArray = new J2DM_Point[rectArray.length];
            int i = 0;
            while (i < rectArray.length) {
                pointArray[i] = new J2DM_Point(point._x, point._y);
                ++i;
            }
            Hashtable subLibrary = (Hashtable)_library.get(key);
            subLibrary.put(animationName, new J2DM_SpriteAnimation(animationName, image, rectArray, pointArray));
            return true;
        }
        return false;
    }

    public boolean addAnimationToKey(String key, J2DM_Image image, String animationName, J2DM_Rect[] rectArray, J2DM_Point[] pointArray) {
        if (this.checkAddAnimationToKey(key, image, animationName)) {
            Hashtable subLibrary = (Hashtable)_library.get(key);
            subLibrary.put(animationName, new J2DM_SpriteAnimation(animationName, image, rectArray, pointArray));
            return true;
        }
        return false;
    }

    private boolean checkAddAnimationToKey(String key, J2DM_Image image, String animationName) {
        Hashtable subLibrary;
        if (_library == null) {
            _library = new Hashtable();
        }
        if (!_library.containsKey(key)) {
            _library.put(key, new Hashtable());
        }
        if ((subLibrary = (Hashtable)_library.get(key)).contains(animationName)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimationLibrary::addAnimationToKey", "The animation already exists, key:" + key + " animationName:" + animationName, J2DM_ConsoleMessageTypes.WARNING);
            return false;
        }
        if (image == null) {
            J2DM_Console.getInstance().addLog("J2DM_AnimationLibrary::addAnimationToKey", "Image is null, key:" + key + " animationName:" + animationName, J2DM_ConsoleMessageTypes.ERROR);
            return false;
        }
        return true;
    }

    public boolean removeAnimationFromKey(String key, String animationName) {
        if (_library == null) {
            J2DM_Console.getInstance().addLog("J2DM_AnimationLibrary::removeAnimationFromKey", "There are no animations in the library", J2DM_ConsoleMessageTypes.WARNING);
            return false;
        }
        if (!_library.containsKey(key)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimationLibrary::removeAnimationFromKey", "That key doesn't exists, key:" + key, J2DM_ConsoleMessageTypes.WARNING);
            return false;
        }
        Hashtable subLibrary = (Hashtable)_library.get(key);
        if (!subLibrary.contains(animationName)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimationLibrary::removeAnimationFromKey", "That animation doesn't exists, animationName:" + animationName, J2DM_ConsoleMessageTypes.WARNING);
            return false;
        }
        ((J2DM_SpriteAnimation)subLibrary.get(animationName)).destroy();
        subLibrary.remove(animationName);
        return true;
    }

    public J2DM_SpriteAnimation getAnimation(String key, String subkey) {
        if (_library == null) {
            J2DM_Console.getInstance().addLog("J2DM_AnimationLibrary::getAnimation", "The library is not initialized", J2DM_ConsoleMessageTypes.WARNING);
            return null;
        }
        if (!J2DM_StringTools.validateString(key) || !J2DM_StringTools.validateString(subkey)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimationLibrary::getAnimation", "One of the paremeters is null or invalid, key=" + key + " subkey=" + subkey, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        if (!_library.containsKey(key) || !((Hashtable)_library.get(key)).containsKey(subkey)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimationLibrary::getAnimation", "The animation doesn't exists, key=" + key + " subkey=" + subkey, J2DM_ConsoleMessageTypes.WARNING);
            return null;
        }
        return (J2DM_SpriteAnimation)((Hashtable)_library.get(key)).get(subkey);
    }

    public Hashtable getAnimationBuffer(String key) {
        if (_library == null) {
            J2DM_Console.getInstance().addLog("J2DM_AnimationLibrary::getAnimationBuffer", "The library is not initialized", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        if (!J2DM_StringTools.validateString(key)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimationLibrary::getAnimationBuffer", "Invalid key:" + key, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        if (!_library.containsKey(key)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimationLibrary::getAnimationBuffer", "The animation doesn't exists, key=" + key, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        return (Hashtable)_library.get(key);
    }
}

