/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.system.input;

import java.util.Vector;

public class J2DM_InputKeyboard {
    private static J2DM_InputKeyboard _instance;
    private boolean[] _keys = new boolean[255];

    private J2DM_InputKeyboard() {
    }

    public static J2DM_InputKeyboard getInstance() {
        if (_instance == null) {
            _instance = new J2DM_InputKeyboard();
        }
        return _instance;
    }

    public void keyPressed(int keyCode) {
        if (keyCode < 0 || keyCode > 255) {
            return;
        }
        this._keys[keyCode] = true;
    }

    public void keyReleased(int keyCode) {
        if (keyCode < 0 || keyCode > 255) {
            return;
        }
        this._keys[keyCode] = false;
    }

    public boolean isKeyPressed(int keyCode) {
        if (keyCode < 0 || keyCode > 255) {
            return false;
        }
        return this._keys[keyCode];
    }

    public boolean isComboPressed(int[] keyCodes) {
        int i = 0;
        while (i < keyCodes.length) {
            if (keyCodes[i] < 0 || keyCodes[i] > 255) {
                return false;
            }
            if (!this._keys[keyCodes[i]]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Vector getKeyCodesPressed() {
        Vector<Integer> keyCodesPressed = new Vector<Integer>();
        int i = 0;
        while (i < this._keys.length) {
            if (this._keys[i]) {
                keyCodesPressed.addElement(new Integer(i));
            }
            ++i;
        }
        return keyCodesPressed;
    }
}

