/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad.scen;

import com.pipogame.Input;
import com.pipogame.components.GameSprite;
import com.pipogame.components.Point;
import com.pipogame.fad.MenuScreen;
import com.pipogame.fad.scen.NarratorScreen;
import com.pipogame.fad.stag.Lands;
import com.pipogame.util.Drawer;
import com.pipogame.util.ImageTool;
import javax.microedition.lcdui.Graphics;

public class MapScreen
extends NarratorScreen {
    private int bgImgWidth;
    private int bgImgHeight;
    private float corner_x;
    private float corner_y;
    private int timeIntroMapCounter;
    private Point[] places = new Point[]{new Point(69, 128), new Point(105, 151), new Point(154, 148), new Point(223, 152), new Point(228, 120), new Point(238, 118), new Point(248, 115), new Point(296, 125), new Point(320, 120), new Point(344, 117), new Point(357, 119), new Point(368, 121), new Point(392, 131), new Point(415, 97), new Point(421, 144), new Point(448, 151), new Point(482, 164)};
    private GameSprite[] lightSpotSprites;
    private float startFlashAtX = 160.0f;
    private static final float TIME = 8000.0f;
    private int timeFade;
    private static final int FADE_TIME = 500;

    public MapScreen() {
        super(43, null);
    }

    public void initialize() throws Exception {
        super.initialize();
        switch (this.screenManager.screenType) {
            case 3: {
                this.startFlashAtX = 160.0f;
                break;
            }
            case 1: 
            case 2: {
                this.startFlashAtX = 240.0f;
            }
        }
        this.playString = false;
    }

    public void loadContent() {
        this.loaded = true;
        this.lightSpotSprites = new GameSprite[this.places.length];
        try {
            this.bgrImage = this.loadImage(31);
            this.nextBtnImage = this.loadImage(29);
            this.backBtnImage = ImageTool.getImageByFrame(this.nextBtnImage, 4, 1, 0);
            this.nextBtnImage = ImageTool.getImageByFrame(this.nextBtnImage, 4, 1, 3);
            GameSprite gs = new GameSprite(this.loadImage(32), 5, 1);
            gs.setFrameSequence(new int[]{4, 0, 1, 2, 3, 2, 1, 0, 4});
            gs.setTimeSequence(110);
            for (int i = 0; i < this.lightSpotSprites.length; ++i) {
                this.lightSpotSprites[i] = new GameSprite(gs);
            }
            this.lightSpotSprites[this.lightSpotSprites.length - 1].setFrameSequence(new int[]{4, 0, 1, 2, 3, 2, 1, 0});
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bgImgHeight = this.bgrImage.getHeight();
        this.bgImgWidth = this.bgrImage.getWidth();
        this.corner_y = (float)(this.bgImgHeight - _height) / 2.0f;
    }

    public void handleInput(Input input, int frameTime) {
        if (input.isSoftLeftPrd()) {
            this.screenManager.addScreen(new MenuScreen());
            this.exitScreen();
        } else if (input.isSoftRightPrd() || input.isFirePrd()) {
            try {
                Lands.startTruongAn(this.screenManager);
                this.exitScreen();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void update(int frameTime, boolean covered) {
        switch (this.screenState) {
            case 2: {
                this.timeIntroMapCounter += frameTime;
                if ((float)this.timeIntroMapCounter > 8000.0f) {
                    this.timeIntroMapCounter = 8000;
                    this.lightSpotSprites[this.lightSpotSprites.length - 1].updateFrame(frameTime, true);
                    this.corner_x = (float)(this.bgImgWidth - _width) * ((float)this.timeIntroMapCounter / 8000.0f);
                    this.playString = true;
                    break;
                }
                this.corner_x = (float)(this.bgImgWidth - _width) * ((float)this.timeIntroMapCounter / 8000.0f);
                for (int i = 0; i < this.places.length; ++i) {
                    GameSprite s = this.lightSpotSprites[i];
                    s.setPosition(this.places[i].getX() - (int)this.corner_x - 9, this.places[i].getY() - (int)this.corner_y - 9);
                    if (!((float)this.places[i].getX() < this.corner_x + this.startFlashAtX) || i <= 0 || this.lightSpotSprites[i - 1].getFrame() <= 3) continue;
                    s.updateFrame(frameTime, false);
                    if (!s.isLastFrame()) continue;
                    s.setVisible(false);
                }
                this.lightSpotSprites[0].updateFrame(frameTime, false);
            }
        }
    }

    protected void drawBackground(Graphics g, int frameTime) {
        g.drawRegion(this.bgrImage, (int)this.corner_x, (int)this.corner_y, _width, _height, 0, 0, 0, 0);
        if (this.playString) {
            if (this.y > this.tran_bg_y) {
                this.timeFade += frameTime;
            } else if (this.y + this.intro.length * 17 < this.tran_bg_y) {
                this.timeFade -= frameTime;
            }
            if (this.timeFade > 500) {
                this.timeFade = 500;
            } else if (this.timeFade < 0) {
                this.timeFade = 0;
            }
            Drawer.drawBg(g, this.tran_bg_x, this.tran_bg_y, this.tran_bg_w, this.tran_bg_h, 136 * this.timeFade / 500 << 24 | 0x361800);
        }
        switch (this.screenState) {
            case 2: 
            case 4: {
                for (int i = 0; i < this.lightSpotSprites.length; ++i) {
                    this.lightSpotSprites[i].paint(g);
                }
                break;
            }
        }
    }
}

