/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame;

import com.pipogame.KeyCodeAdapter;
import com.pipogame.ScreenManager;
import com.pipogame.components.ISprite;
import com.pipogame.components.Point;
import com.pipogame.components.Rect;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.game.Sprite;

public class Input {
    private int keyState;
    private int oldKeyState;
    private int keyCode;
    private int oldKeyCode;
    private int keyCodeRepeated;
    private int keyCodeReleased;
    private int touchX;
    private int touchY;
    private int translateX;
    private int translateY;
    private boolean touched;
    private boolean touchUp;
    private int oldTouchX;
    private int oldTouchY;
    private int distanceDrag;
    public final boolean touchSupported;
    private KeyCodeAdapter adapter;

    public Input(ScreenManager gameCanvas, boolean touchSupported, Point translate) {
        this.adapter = KeyCodeAdapter.getInstance((Canvas)gameCanvas);
        this.touchSupported = touchSupported;
        this.translateX = translate.getX();
        this.translateY = translate.getY();
    }

    void setNewKeyState(int keyState) {
        this.keyState = keyState;
    }

    void setKeyCode(int keyCode) {
        this.keyCode = keyCode;
    }

    void setSoftkeyLeftPrd() {
        this.keyCode = this.adapter.SOFTKEY_LEFT;
    }

    void setSoftkeyRightPrd() {
        this.keyCode = this.adapter.SOFTKEY_RIGHT;
    }

    void setKeyReleased(int keyCodeReleased) {
        this.keyCodeReleased = keyCodeReleased;
    }

    void setKeyRepeated(int keyCodeRepeated) {
        this.keyCodeRepeated = keyCodeRepeated;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getKeyCodeReleased() {
        return this.keyCodeReleased;
    }

    public int getKeyCodeRepeated() {
        return this.keyCodeRepeated;
    }

    public boolean isKeyCodePressed(int keyCode) {
        return keyCode == this.keyCode;
    }

    public boolean isKeyCodeRepeated(int keyCode) {
        return keyCode == this.keyCodeRepeated;
    }

    public boolean isKeyCodeReleased(int keycode) {
        return keycode == this.keyCodeReleased;
    }

    void resetKey() {
        this.oldKeyState = this.keyState;
        this.oldKeyCode = this.keyCode;
        this.keyState = 0;
        this.keyCode = 0;
        this.keyCodeRepeated = 0;
        this.keyCodeReleased = 0;
        this.touchX = Integer.MIN_VALUE;
        this.touchY = Integer.MIN_VALUE;
        this.touchUp = false;
    }

    public boolean isLeftPrd() {
        return (this.keyState & 4) != 0;
    }

    public boolean isRightPrd() {
        return (this.keyState & 0x20) != 0;
    }

    public boolean isUpPrd() {
        return (this.keyState & 2) != 0;
    }

    public boolean isDownPrd() {
        return (this.keyState & 0x40) != 0;
    }

    public boolean isFirePrd() {
        return (this.keyState & 0x100) != 0;
    }

    public boolean isSomeKeyPrd() {
        return this.keyState != 0 || this.keyCode != 0;
    }

    public boolean isSoftLeftPrd() {
        return this.keyCode == this.adapter.SOFTKEY_LEFT;
    }

    public boolean isSoftRightPrd() {
        return this.keyCode == this.adapter.SOFTKEY_RIGHT;
    }

    public boolean isSameKeyState() {
        return this.keyState != 0 && this.keyState == this.oldKeyState;
    }

    public boolean isSameKeyCode() {
        return this.keyCode != 0 && this.keyCode == this.oldKeyCode;
    }

    void setTouchPosition(int x, int y) {
        this.touchX = x - this.translateX;
        this.touchY = y - this.translateY;
    }

    void setTouchUpPosition(int x, int y) {
        this.touchUp = true;
        this.touched = false;
        this.touchX = x - this.translateX;
        this.touchY = y - this.translateY;
    }

    public int getTouchX() {
        return this.touchX;
    }

    public int getTouchY() {
        return this.touchY;
    }

    public boolean isTouchSupported() {
        return this.touchSupported;
    }

    public boolean isTouched() {
        return this.touched;
    }

    public boolean isTouchUp() {
        return this.touchUp;
    }

    public boolean touched(int x, int y, int width, int height) {
        return x <= this.touchX && this.touchX <= x + width && y <= this.touchY && this.touchY <= y + height;
    }

    public boolean touched(Rect r) {
        return r.contains(this.touchX, this.touchY);
    }

    public boolean touched(Sprite sprite) {
        return this.touched(sprite.getX(), sprite.getY(), sprite.getWidth(), sprite.getHeight());
    }

    public boolean touched(ISprite sprite) {
        return this.touched(sprite.getX(), sprite.getY(), sprite.getWidth(), sprite.getHeight());
    }

    public String toString() {
        return "keystate " + this.keyState + "; key code " + this.keyCode;
    }

    public int getKeyState() {
        return this.keyState;
    }
}

