/*
 * Decompiled with CFR 0.152.
 */
package game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Button {
    int x;
    int y;
    int width;
    int height;
    byte buttonState = 0;
    byte collisionType = 1;
    Image[] imgButton;
    Sprite pointerSprite;
    int[] buttonColor = new int[]{0, 0xFF0000};
    String name = "button";
    int nameColor = 0;
    int nameX;
    int nameY;
    static byte noOfButton;
    boolean isMovable;
    int touchX;
    int touchY;

    public void setXY(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Button() {
        this.imgButton = new Image[2];
    }

    public Button(int x, int y, int width, int height, int color1, int color2) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.buttonColor[0] = color1;
        this.buttonColor[1] = color2;
        this.collisionType = 1;
        noOfButton = (byte)(noOfButton + 1);
        this.name = "button" + noOfButton;
        this.nameX = x + 5;
        this.nameY = y + 5;
    }

    public Button(int x, int y, String imagePath1, String imagePath2) {
        this.x = x;
        this.y = y;
        if (this.imgButton == null) {
            this.imgButton = new Image[2];
        }
        try {
            this.imgButton[0] = Image.createImage((String)imagePath1);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.imgButton[1] = Image.createImage((String)imagePath2);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.imgButton[1] == null && this.imgButton[0] != null) {
            this.imgButton[1] = this.imgButton[0];
        }
        if (this.imgButton[0] != null) {
            this.width = this.imgButton[0].getWidth();
            this.height = this.imgButton[0].getHeight();
        } else if (this.imgButton[1] != null) {
            this.width = this.imgButton[1].getWidth();
            this.height = this.imgButton[1].getHeight();
        }
        this.collisionType = 1;
        noOfButton = (byte)(noOfButton + 1);
        this.name = "button" + noOfButton;
    }

    public void setMovable(boolean mov) {
        this.isMovable = mov;
    }

    public boolean isPressed(int x1, int y1) {
        boolean result = false;
        if (this.buttonState == 0) {
            if (this.collisionType == 2 && this.imgButton != null) {
                if (this.pointerSprite == null) {
                    this.pointerSprite = new Sprite(Image.createImage((int)2, (int)2));
                }
                this.pointerSprite.setPosition(x1, y1);
                result = this.imgButton[0] != null ? this.pointerSprite.collidesWith(this.imgButton[0], this.x, this.y, true) : this.pointerSprite.collidesWith(this.imgButton[1], this.x, this.y, true);
            } else {
                boolean bl = result = x1 > this.x && x1 < this.x + this.width && y1 > this.y && y1 < this.y + this.height;
            }
            if (result) {
                this.buttonState = 1;
                this.touchX = x1;
                this.touchY = y1;
            }
        }
        return result;
    }

    public boolean isReleased(int x1, int y1) {
        if (this.buttonState == 1) {
            this.buttonState = 0;
            this.isPressed(x1, y1);
            if (this.buttonState == 1) {
                this.buttonState = 0;
                return true;
            }
            return false;
        }
        return false;
    }

    public void paint(Graphics g) {
        if (this.imgButton != null) {
            if (this.imgButton[this.buttonState] != null) {
                g.drawImage(this.imgButton[this.buttonState], this.x, this.y, 0x10 | 4);
            }
        } else {
            if (this.buttonColor[this.buttonState] != -1) {
                g.setColor(this.buttonColor[this.buttonState]);
                g.fillRect(this.x, this.y, this.width, this.height);
            }
            g.setColor(this.nameColor);
            g.drawString(this.name, this.nameX, this.nameY, 0x10 | 4);
        }
    }
}

