/*
 * Decompiled with CFR 0.152.
 */
package ClassFrame;

import ClassFrame.Player;
import GamePlay.CanvasGame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RMS {
    public RecordStore rs;
    public CanvasGame canvas;
    private ByteArrayOutputStream bos;
    private DataOutputStream dos;
    private ByteArrayInputStream bis;
    private DataInputStream dis;
    private byte[] writeByte;
    private static final String RECORD_STORE_NAME = "guocmocthanchuong";
    private static final int NUM_RECORD = 5;

    public RMS(CanvasGame canvas) {
        this.canvas = canvas;
    }

    public void open() {
        try {
            this.rs = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)true);
            if (this.rs.getNumRecords() == 0) {
                Player p = new Player(null, 0, 1, 700, 0, "Messi");
                this.insert(p);
                p = new Player(null, 0, 1, 500, 0, "Figo");
                this.insert(p);
                p = new Player(null, 0, 1, 300, 0, "Rooney");
                this.insert(p);
                p = new Player(null, 0, 1, 200, 0, "Nani");
                this.insert(p);
                p = new Player(null, 0, 1, 150, 0, "Torres");
                this.insert(p);
                p = new Player(null, 0, 0, 0, 0, "");
                this.insert(p);
            }
        }
        catch (RecordStoreException re) {
            System.out.println("Can't open RMS");
            System.out.println(re.getMessage());
        }
    }

    public void close() {
        try {
            this.rs.closeRecordStore();
        }
        catch (NullPointerException npe) {
            System.out.println("RMS 's reference is null");
            System.out.println(npe.getMessage());
        }
        catch (RecordStoreException e) {
            System.out.println("Can't close RMS");
            System.out.println(e.getMessage());
        }
    }

    public void insert(Player p) {
        try {
            this.bos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.bos);
            this.dos.writeUTF(p.getName());
            this.dos.writeInt(p.getScore());
            this.dos.writeInt(p.getLevel());
            this.dos.writeInt(p.getMoney());
            this.dos.flush();
            this.writeByte = this.bos.toByteArray();
            this.rs.addRecord(this.writeByte, 0, this.writeByte.length);
        }
        catch (IOException ioe) {
            System.out.println("Can't write data to RMS");
            System.out.println(ioe.getMessage());
        }
        catch (RecordStoreException rno) {
            System.out.println("Can't wirte data to RMS becase RMS closing");
            System.out.println(rno.getMessage());
        }
    }

    public void replaceWith(Player p) {
        try {
            for (int id = 1; id <= 5; ++id) {
                this.bis = new ByteArrayInputStream(this.rs.getRecord(id));
                this.dis = new DataInputStream(this.bis);
                String name = this.dis.readUTF();
                int score = this.dis.readInt();
                if (score >= p.getScore()) continue;
                for (int i = 5; i >= id + 1; --i) {
                    byte[] tbye1 = this.rs.getRecord(i - 1);
                    this.rs.setRecord(i, tbye1, 0, tbye1.length);
                }
                this.bos = new ByteArrayOutputStream();
                this.dos = new DataOutputStream(this.bos);
                this.dos.writeUTF(p.getName());
                this.dos.writeInt(p.getScore());
                this.dos.writeInt(p.getLevel());
                this.dos.writeInt(p.getMoney());
                this.dos.flush();
                this.writeByte = this.bos.toByteArray();
                this.rs.setRecord(id, this.writeByte, 0, this.writeByte.length);
                break;
            }
        }
        catch (IOException ioe) {
            System.out.println("Can't write data to RMS");
            System.out.println(ioe.getMessage());
        }
        catch (RecordStoreException rno) {
            System.out.println("Can't wirte data to RMS becase RMS closing");
            System.out.println(rno.getMessage());
        }
    }

    public Vector read() {
        Vector<Player> v = new Vector<Player>();
        try {
            for (int id = 1; id <= 5; ++id) {
                this.bis = new ByteArrayInputStream(this.rs.getRecord(id));
                this.dis = new DataInputStream(this.bis);
                String name = this.dis.readUTF();
                int score = this.dis.readInt();
                int level = this.dis.readInt();
                int miss = this.dis.readInt();
                Player p = new Player(null, 20, level, score, miss, name);
                v.addElement(p);
                System.out.println("tc" + p.getName() + " " + p.getScore());
            }
        }
        catch (IOException ioe) {
            System.out.println("Can't write data to RMS");
            System.out.println(ioe.getMessage());
        }
        catch (RecordStoreException rno) {
            System.out.println("Can't read data to RMS becase RMS closing");
            System.out.println(rno.getMessage());
        }
        for (int i = 0; i < v.size(); ++i) {
            Player p1 = (Player)v.elementAt(i);
            System.out.println("pho" + p1.getName() + " " + p1.getScore());
        }
        return v;
    }

    public void save(Player p, int index) {
        this.bos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.bos);
        try {
            this.dos.writeUTF(p.getName());
            this.dos.writeInt(p.getScore());
            this.dos.writeInt(p.getLevel());
            this.dos.writeInt(p.getMoney());
            this.dos.flush();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.writeByte = this.bos.toByteArray();
        try {
            this.rs.setRecord(index, this.writeByte, 0, this.writeByte.length);
        }
        catch (InvalidRecordIDException in) {
        }
        catch (RecordStoreNotOpenException re) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public Player read(int index) {
        Player p = null;
        try {
            this.bis = new ByteArrayInputStream(this.rs.getRecord(index));
            this.dis = new DataInputStream(this.bis);
            String name = this.dis.readUTF();
            int score = this.dis.readInt();
            int level = this.dis.readInt();
            int miss = this.dis.readInt();
            p = new Player(null, 20, level, score, miss, name);
        }
        catch (IOException ioe) {
            System.out.println("Can't write data to RMS");
            System.out.println(ioe.getMessage());
        }
        catch (RecordStoreException rno) {
            System.out.println("Can't read data to RMS becase RMS closing");
            System.out.println(rno.getMessage());
        }
        return p;
    }

    public boolean is_top(Player p) {
        boolean result = false;
        try {
            this.bis = new ByteArrayInputStream(this.rs.getRecord(5));
            this.dis = new DataInputStream(this.bis);
            String name = this.dis.readUTF();
            int score = this.dis.readInt();
            int level = this.dis.readInt();
            int miss = this.dis.readInt();
            if (score < p.getScore()) {
                result = true;
            }
        }
        catch (RecordStoreException rse) {
            System.out.println("in is_top method");
            System.out.println(rse.getMessage());
        }
        catch (IOException ioe) {
            System.out.println("error with reading data from input stream");
            System.out.println(ioe.getMessage());
        }
        return result;
    }
}

