/*
 * Decompiled with CFR 0.152.
 */
package GamePlay;

import ClassFrame.Button;
import ClassFrame.CImage;
import ClassFrame.Player;
import ClassFrame.RMS;
import ClassFrame.Resource;
import GamePlay.MIDletGame;
import Screen.IScreen;
import Screen.Pause;
import Screen.Splash;
import com.emobtech.googleanalyticsme.PageView;
import com.emobtech.googleanalyticsme.Tracker;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;

public class CanvasGame
extends Canvas
implements Runnable {
    public static final Font fonttextbox = Font.getFont((int)0, (int)1, (int)16);
    MIDletGame midletGame;
    public static final Font font = Font.getFont((int)0, (int)1, (int)16);
    public static final Font bmFont = Font.getFont((int)0, (int)1, (int)0);
    public static final Font blFont = Font.getFont((int)0, (int)1, (int)16);
    public static final int WHITE = 0xFFFFFF;
    public static final int BLACK = 0;
    public static final int RED = 0xFF0000;
    public static int MAX_CPS = 20;
    public static int MS_PER_FRAME = 1000 / MAX_CPS;
    public static boolean running;
    public static boolean active;
    public static int volume;
    public static int musicLevel;
    public static int effectLevel;
    public static boolean vibration;
    public static final int wScreen = 320;
    public static final int NONE = 0;
    public static final int SCR_SPLASH = 1;
    public static final int SCR_MENU = 2;
    public static final int SCR_SCORE = 3;
    public static final int SCR_SETTING = 4;
    public static final int SCR_GUIDE = 5;
    public static final int SCR_ABOUT = 6;
    public static final int SCR_EXIT = 7;
    public static final int SCR_GAME = 8;
    public static final int SCR_PAUSE = 9;
    public static final int SCR_NEXT = 10;
    public static final int SCR_WIN = 11;
    public static final int SCR_GAMEOVER = 12;
    public static int score_temp;
    public static int level_temp;
    private static int typeScreen;
    public Resource res;
    private IScreen screen;
    public static RMS rms;
    private CImage image;
    private int continuePlay = 0;
    private boolean first;
    public boolean isSplash = true;
    public static boolean mobileState;
    static /* synthetic */ Class class$Screen$Game;

    public CanvasGame(MIDletGame midletGame) {
        Runtime.getRuntime().gc();
        this.setFullScreenMode(true);
        this.isSplash = true;
        this.midletGame = midletGame;
        this.initCanvas();
        this.first = true;
        this.start();
    }

    private void initCanvas() {
        this.initComponents();
        active = true;
        running = true;
        typeScreen = 0;
        this.image = new CImage();
        rms = new RMS(this);
        rms.open();
        Player p = rms.read(6);
        if (p.getLevel() > 0) {
            this.continuePlay = -5;
            level_temp = p.getLevel();
            score_temp = p.getScore();
        }
        rms.close();
    }

    private void initComponents() {
        this.res = new Resource(this);
        this.res.loadSounds();
        if (this.screen == null) {
            this.screen = new Splash(this);
        }
        this.screen.load_screen();
    }

    public void keyEvent(int keycode, int event) {
        this.screen.keyEvent(keycode, event);
    }

    public void pointerEvent(int x, int y, int event) {
        if (typeScreen == 1) {
            int temp = x;
            x = y;
            y = this.getWidth() - temp;
        }
        this.screen.pointerEvent(x, y, event);
    }

    protected void paint(Graphics g) {
        this.screen.paint(g);
    }

    private void update() {
        if ((class$Screen$Game == null ? (class$Screen$Game = CanvasGame.class$("Screen.Game")) : class$Screen$Game) == this.screen.getClass()) {
            this.screen.update();
        }
    }

    public void run() {
        while (running) {
            long cycleStartTime = System.currentTimeMillis();
            long timeSinceStart = 0L;
            if (active) {
                this.repaint();
                if (mobileState) {
                    this.FixSound();
                }
                timeSinceStart = System.currentTimeMillis() - cycleStartTime;
            }
            try {
                if (timeSinceStart >= (long)(1000 / MAX_CPS)) continue;
                Thread.sleep((long)(1000 / MAX_CPS) - timeSinceStart);
            }
            catch (InterruptedException ex) {}
        }
        this.midletGame.destroyApp(true);
        this.midletGame = null;
        Runtime.getRuntime().gc();
    }

    public void freeComponents() {
        this.res.unLoadSounds();
        this.res = null;
        this.screen = null;
    }

    public final void start() {
        Thread runner = new Thread(this);
        runner.setPriority(10);
        runner.start();
    }

    protected void keyPressed(int keyCode) {
        this.keyEvent(keyCode, 2);
    }

    protected void keyReleased(int keyCode) {
        this.keyEvent(keyCode, 1);
    }

    protected void pointerPressed(int x, int y) {
        this.pointerEvent(x, y, 4);
    }

    protected void pointerReleased(int x, int y) {
        this.pointerEvent(x, y, 3);
    }

    protected void pointerDragged(int x, int y) {
        this.pointerEvent(x, y, 5);
    }

    public boolean checkRegion(int point_x, int point_y, int region_X, int region_Y, int region_W, int region_H) {
        if (point_x < region_X || point_x > region_X + region_W) {
            return false;
        }
        return point_y >= region_Y && point_y <= region_Y + region_H;
    }

    public boolean checkButton(int point_x, int point_y, Button aButton) {
        if (point_x < aButton.getX() || point_x > aButton.getX() + aButton.getW()) {
            return false;
        }
        return point_y >= aButton.getY() && point_y <= aButton.getY() + aButton.getH();
    }

    public void setScreen(IScreen screen) {
        try {
            this.screen.un_load_screen();
            this.screen = screen;
            this.screen.load_screen();
        }
        catch (NullPointerException npe) {
            System.out.println("screen is null");
            System.out.println(npe.getMessage());
        }
    }

    public Resource getResource() {
        return this.res;
    }

    public CImage getImage() {
        return this.image;
    }

    public RMS getRMS() {
        return rms;
    }

    public MIDletGame getMIDletGame() {
        return this.midletGame;
    }

    public IScreen getScreen() {
        return this.screen;
    }

    public int getContinuePlay() {
        return this.continuePlay;
    }

    public void setContinuePlay(int continuePlay) {
        this.continuePlay = continuePlay;
    }

    public static int getTypeScreen() {
        return typeScreen;
    }

    public static void setTypeScreen(int typeScreen) {
        CanvasGame.typeScreen = typeScreen;
    }

    protected void hideNotify() {
        mobileState = false;
        this.getResource().getSound(0).stop();
        if (this.screen.getClass() == (class$Screen$Game == null ? (class$Screen$Game = CanvasGame.class$("Screen.Game")) : class$Screen$Game)) {
            this.setScreen(new Pause(this));
        } else {
            this.setScreen(this.screen);
        }
    }

    protected void showNotify() {
        mobileState = true;
        if (this.first) {
            this.first = false;
        }
        Tracker tracker = Tracker.getInstance(this.getMIDletGame(), "UA-25640246-3");
        tracker.addToQueue(new PageView("GuocMocThanChuong_Java"));
        tracker.flush(true);
    }

    public void FixSound() {
        if (!this.isSplash) {
            this.getResource().getSound(0).setVolumeLevel(musicLevel);
            try {
                this.getResource().getSound(0).start();
            }
            catch (MediaException ex) {
                System.out.println("Oh shit!!! Can't start music");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        volume = 40;
        musicLevel = 0;
        effectLevel = 0;
        vibration = false;
        mobileState = true;
    }
}

