/*
 * Decompiled with CFR 0.152.
 */
package Object;

import GamePlay.CanvasGame;
import javax.microedition.lcdui.Graphics;

public abstract class AbstractObject {
    public static final int DOWN = 0;
    public static final int UP = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int STAND = 4;
    public static final int JUMP = 5;
    protected CanvasGame canvas;
    protected int image;
    protected int screen_x;
    protected int screen_y;
    protected int x;
    protected int y;
    protected int w;
    protected int h;
    protected int numFrame;
    protected int countFrame;
    protected int state;
    protected int direction;
    protected int vx;
    protected int vy;
    protected int t_jump;

    public AbstractObject(CanvasGame canvas, int screen_x, int screen_y, int image, int w, int h, int numFrame, int state, int direction, int vx, int vy, int t_jump) {
        this.canvas = canvas;
        this.image = image;
        this.screen_x = screen_x;
        this.screen_y = screen_y;
        this.x = 320 - (240 - this.screen_x);
        this.y = 240 - (320 - this.screen_y);
        this.w = w;
        this.h = h;
        this.numFrame = numFrame;
        this.countFrame = 0;
        this.state = state;
        this.direction = direction;
        this.vx = vx;
        this.vy = vy;
        this.t_jump = t_jump;
    }

    public int getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public int getCountFrame() {
        return this.countFrame;
    }

    public int getNumFrame() {
        return this.numFrame;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getScreenX() {
        return this.screen_x;
    }

    public int getScreenY() {
        return this.screen_y;
    }

    public CanvasGame getCanvasGame() {
        return this.canvas;
    }

    public int getState() {
        return this.state;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getVx() {
        return this.vx;
    }

    public int getVy() {
        return this.vy;
    }

    public int getTjump() {
        return this.t_jump;
    }

    public void setNumFrame(int num) {
        this.numFrame = num;
    }

    public void setCountFrame(int count) {
        this.countFrame = count;
    }

    public void setWidth(int width) {
        this.w = width;
    }

    public void setHeight(int height) {
        this.h = height;
    }

    public void setImage(int image) {
        this.image = image;
    }

    public void setState(int state) {
        this.state = state;
        this.countFrame = 0;
    }

    public void setDirection(int direction) {
        this.direction = direction;
        this.countFrame = 0;
    }

    public void setVx(int vx) {
        this.vx = vx;
    }

    public void setVy(int vy) {
        this.vy = vy;
    }

    public void setTjump(int t_jump) {
        this.t_jump = t_jump;
    }

    public boolean collided(AbstractObject abo) {
        if (this.x > abo.x + abo.w) {
            return false;
        }
        if (this.x + this.w < abo.x) {
            return false;
        }
        if (this.y > abo.y + abo.h) {
            return false;
        }
        return this.y + this.h >= abo.y;
    }

    public abstract void paint(Graphics var1);

    public abstract void setX(int var1);

    public abstract void setY(int var1);

    public abstract void setScreenX(int var1);

    public abstract void setScreenY(int var1);

    public abstract void update();
}

