/*
 * Decompiled with CFR 0.152.
 */
package com.emobtech.googleanalyticsme;

import com.emobtech.googleanalyticsme.Request;
import com.emobtech.googleanalyticsme.TrackingURL;
import com.emobtech.googleanalyticsme.io.HttpConnector;
import com.emobtech.googleanalyticsme.util.PropertyStore;
import com.emobtech.googleanalyticsme.util.StringUtil;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public final class Tracker {
    private static Hashtable trackerPool;
    private String appId;
    private Vector queue;
    private Timer timer;
    private Task task;
    private long flushInterval;
    private int userId;
    private long firstVisitTimestamp;
    private long lastVisitTimestamp;
    private final long currentVisitTimestamp;
    private MIDlet midlet;

    public static synchronized Tracker getInstance(MIDlet midlet, String appId) {
        return Tracker.getInstance(midlet, appId, 60L);
    }

    public static synchronized Tracker getInstance(MIDlet midlet, String appId, long flushInterval) {
        Tracker tracker;
        if (midlet == null) {
            throw new IllegalArgumentException("MIDlet must not be null.");
        }
        if (StringUtil.isEmpty(appId)) {
            throw new IllegalArgumentException("Application Id must not be empty.");
        }
        if (trackerPool == null) {
            trackerPool = new Hashtable();
        }
        if ((tracker = (Tracker)trackerPool.get(appId)) == null) {
            tracker = new Tracker(midlet, appId, flushInterval);
            trackerPool.put(appId, tracker);
        }
        return tracker;
    }

    private Tracker(MIDlet midlet, String appId, long flushInterval) {
        this.midlet = midlet;
        this.appId = appId;
        this.flushInterval = flushInterval *= 1000L;
        this.currentVisitTimestamp = System.currentTimeMillis();
        this.loadCookie();
        this.queue = new Vector(5);
        this.timer = new Timer();
        this.task = new Task();
        if (flushInterval > 0L) {
            this.timer.schedule((TimerTask)this.task, flushInterval, flushInterval);
        }
    }

    public void track(Request request) {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        this.fillRequestParams(request);
        try {
            this.process(request);
        }
        catch (IOException e) {
            this.addToQueue(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(Request request) {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        this.fillRequestParams(request);
        Vector vector = this.queue;
        synchronized (vector) {
            this.queue.addElement(request);
        }
    }

    public int queueSize() {
        return this.queue.size();
    }

    public void flush(boolean asynchronously) {
        if (this.queue.size() > 0) {
            if (asynchronously) {
                this.runTask(1000L);
            } else {
                this.processQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processQueue() {
        int size = this.queue.size();
        int head = 0;
        while (size-- > 0) {
            try {
                this.process((Request)this.queue.elementAt(head));
                Vector vector = this.queue;
                synchronized (vector) {
                    this.queue.removeElementAt(head);
                }
            }
            catch (IOException e) {
                ++head;
            }
        }
    }

    private synchronized void process(Request request) throws IOException {
        TrackingURL turl = request.trackingURL();
        HttpConnection conn = null;
        try {
            conn = HttpConnector.open(turl.getURL());
            conn.setRequestProperty("User-Agent", this.getUserAgent());
            if (conn.getResponseCode() != 200) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    private void runTask(long delay2) {
        if (!this.task.isRunning) {
            if (this.flushInterval > 0L) {
                long delayNextRun = this.task.endExecutionTime + this.flushInterval - System.currentTimeMillis();
                if (delayNextRun > delay2) {
                    this.task.cancel();
                    this.task = new Task();
                    this.timer.schedule((TimerTask)this.task, delay2, this.flushInterval);
                }
            } else {
                this.task = new Task();
                this.timer.schedule((TimerTask)this.task, delay2);
            }
        }
    }

    private void fillRequestParams(Request request) {
        request.setAppId(this.appId);
        request.setUserId(this.userId);
        request.setFirstVisitTimestamp(this.firstVisitTimestamp);
        request.setLastVisitTimestamp(this.lastVisitTimestamp);
        request.setCurrentVisitTimestamp(this.currentVisitTimestamp);
        Display display = Display.getDisplay((MIDlet)this.midlet);
        Displayable screen = display.getCurrent();
        if (screen != null) {
            request.setScreenWidth(screen.getWidth());
            request.setScreenHeight(screen.getHeight());
            request.setNumberOfColors(display.numColors());
        }
    }

    private void loadCookie() {
        PropertyStore prefs = new PropertyStore(this.appId);
        if (prefs.size() > 0) {
            this.userId = prefs.getInt("userId");
            this.firstVisitTimestamp = prefs.getLong("firstVisitTimestamp");
            this.lastVisitTimestamp = prefs.getLong("lastVisitTimestamp");
            prefs.putLong("lastVisitTimestamp", this.currentVisitTimestamp);
        } else {
            this.userId = new Random(Integer.MAX_VALUE).nextInt() - 1;
            this.firstVisitTimestamp = this.currentVisitTimestamp;
            this.lastVisitTimestamp = this.currentVisitTimestamp;
            prefs.putInt("userId", this.userId);
            prefs.putLong("firstVisitTimestamp", this.firstVisitTimestamp);
            prefs.putLong("lastVisitTimestamp", this.lastVisitTimestamp);
        }
        prefs.save();
    }

    private String getUserAgent() {
        String midletName = this.midlet.getAppProperty("MIDlet-Name");
        String midletVersion = this.midlet.getAppProperty("MIDlet-Version");
        String profile = this.midlet.getAppProperty("MicroEdition-Profile");
        String config = this.midlet.getAppProperty("MicroEdition-Configuration");
        String device = System.getProperty("microedition.platform");
        device = device != null ? StringUtil.extractDevice(device) : "Unknown";
        String userAgent = midletName + "/" + midletVersion + " (JavaME; " + device + "; " + "Profile/" + profile + " Configuration/" + config + ")";
        return userAgent;
    }

    private class Task
    extends TimerTask {
        public long endExecutionTime = System.currentTimeMillis();
        public boolean isRunning;

        private Task() {
        }

        public void run() {
            this.isRunning = true;
            Tracker.this.processQueue();
            this.isRunning = false;
            this.endExecutionTime = System.currentTimeMillis();
        }
    }
}

