/*
 * Decompiled with CFR 0.152.
 */
package ClassFrame;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class JFont {
    private static byte FONT;
    public static final byte FONT_1;
    public static final byte FONT_2;
    public static final byte FONT_3;
    private Image image;
    private int type;
    private int h;
    private int w;
    private int space;
    private boolean isDefault;
    public static final StringBuffer sb;
    public static final byte[] font_1_Width;
    public static final byte[] font_2_Width;

    public JFont(int type) {
        this.type = type;
        this.isDefault = true;
        if (FONT_1 == type) {
            try {
                this.image = Image.createImage((String)"/font1.png");
                this.h = 14;
                this.w = 11;
            }
            catch (IOException ex) {
                this.isDefault = false;
                System.out.println("Can't load image font font1.png");
            }
        } else if (FONT_2 == type) {
            try {
                this.image = Image.createImage((String)"/font2.png");
                this.h = 20;
                this.w = 21;
            }
            catch (IOException ex) {
                this.isDefault = false;
                System.out.println("Can't load image font font2.png");
            }
        } else if (FONT_3 == type) {
            // empty if block
        }
    }

    public int getSpace() {
        return this.space;
    }

    public void setSpace(int space) {
        this.space = space;
    }

    public int getIndex(char ch) {
        int index = sb.toString().indexOf(String.valueOf(ch));
        if (index < 0 || index >= sb.length()) {
            index = 95;
        }
        return index;
    }

    public int getWidth(char ch) {
        byte width = 0;
        if (FONT_1 == this.type) {
            width = font_1_Width[this.getIndex(ch)];
        } else if (FONT_2 == this.type) {
            width = font_2_Width[this.getIndex(ch)];
        }
        return width;
    }

    public int subStringWidth(String str, int start, int end) {
        int width = 0;
        for (int i = start; i <= end; ++i) {
            width += this.getWidth(str.charAt(i)) + this.space;
        }
        return width;
    }

    public int stringWidth(String str) {
        return this.subStringWidth(str, 0, str.length() - 1);
    }

    public void drawChar(Graphics g, char ch, int x, int y, int anchor, int angle) {
        g.drawRegion(this.image, this.w * this.getIndex(ch), 0, this.getWidth(ch), this.h, angle, x, y, anchor);
    }

    public void drawString(Graphics g, String str, int x, int y, int anchor, int angle) {
        if (!this.isDefault) {
            g.setColor(175, 131, 11);
            g.drawString(str, x, y, 20);
        } else {
            switch (angle) {
                case 0: {
                    int n = str.length();
                    for (int i = 0; i < n; ++i) {
                        this.drawChar(g, str.charAt(i), x + this.subStringWidth(str, 0, i - 1) + this.space, y, anchor, angle);
                    }
                    break;
                }
                case 6: {
                    int n = str.length();
                    for (int i = 0; i < n; ++i) {
                        this.drawChar(g, str.charAt(i), x, y - this.subStringWidth(str, 0, i - 1) - this.space, anchor, angle);
                    }
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    int n = str.length();
                    for (int i = 0; i < n; ++i) {
                        this.drawChar(g, str.charAt(i), x, y + this.subStringWidth(str, 0, i - 1) + this.space, anchor, angle);
                    }
                    break;
                }
            }
        }
    }

    public int gethText() {
        return this.h;
    }

    static {
        byte by = FONT = 0;
        FONT = (byte)(by + 1);
        FONT_1 = by;
        byte by2 = FONT;
        FONT = (byte)(by2 + 1);
        FONT_2 = by2;
        byte by3 = FONT;
        FONT = (byte)(by3 + 1);
        FONT_3 = by3;
        sb = new StringBuffer().append(" !").append('\"').append("#$%&").append('\'').append("()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[").append('\\').append("]^_`abcdefghijklmnopqrstuvwxyz{|}~");
        font_1_Width = new byte[]{6, 2, 5, 6, 5, 8, 7, 2, 3, 3, 3, 6, 2, 3, 2, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 2, 2, 5, 5, 5, 5, 10, 7, 6, 7, 6, 5, 5, 7, 6, 2, 5, 6, 6, 9, 6, 7, 6, 7, 7, 6, 6, 6, 7, 11, 6, 6, 6, 3, 3, 3, 5, 6, 3, 5, 6, 5, 6, 6, 5, 6, 6, 2, 3, 6, 2, 10, 6, 6, 6, 6, 4, 6, 5, 6, 5, 9, 5, 7, 5, 4, 1, 4, 5, 7};
        font_2_Width = new byte[]{3, 3, 7, 10, 9, 16, 14, 4, 5, 5, 8, 12, 4, 6, 3, 9, 11, 6, 9, 10, 11, 10, 11, 9, 10, 10, 4, 4, 11, 12, 11, 8, 15, 13, 10, 12, 13, 10, 9, 13, 12, 3, 7, 11, 9, 15, 12, 15, 10, 14, 10, 10, 11, 12, 12, 21, 14, 15, 14, 5, 7, 5, 9, 14, 15, 11, 12, 11, 11, 12, 7, 11, 10, 3, 5, 11, 3, 17, 10, 11, 10, 11, 7, 10, 6, 10, 11, 17, 11, 11, 10, 7, 2, 7, 12, 17};
    }
}

