/*
 * Decompiled with CFR 0.152.
 */
package ClassFrame;

import ClassFrame.Sound;
import GamePlay.CanvasGame;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;

public class Resource {
    private CanvasGame cParent;
    public static final int c_WHITE = 0xFFFFFF;
    public static final int c_BG = 0xFFFFFF;
    public static final int c_Menu = 0xFFFFFF;
    public static final int c_Focus = 0;
    public static final Font f0 = Font.getFont((int)0, (int)0, (int)16);
    public static final Font f_NORMAL = Font.getFont((int)0, (int)0, (int)16);
    public static final Font f_MENU = Font.getFont((int)0, (int)1, (int)16);
    public static final Font f_BOLD = Font.getFont((int)0, (int)1, (int)16);
    public static final Font f_ITALIC = Font.getFont((int)0, (int)2, (int)16);
    public static final Font f_BOLD_ITALIC = Font.getFont((int)0, (int)3, (int)16);
    public static final Font f_UNDERLINE = Font.getFont((int)0, (int)4, (int)16);
    public static final Font bigBoldFont = Font.getFont((int)0, (int)1, (int)16);
    private static int count = 0;
    public static final int IMG_SPLASH = count++;
    public static final int IMG_TXT_SOUND = count++;
    public static final int IMG_BG_MENU = count++;
    public static final int IMG_BG_OTHER = count++;
    public static final int IMG_VOLUME = count++;
    public static final int IMG_SEEK_BAR = count++;
    public static final int IMG_GUIDE = count++;
    public static final int IMG_TXT_ABOUT = count++;
    public static final int IMG_ABOUT = count++;
    public static final int IMG_EXIT = count++;
    public static final int IMG_SPL = count++;
    public static final int IMG_THIETLAP = count++;
    public static final int IMG_GIOITHIEU = count++;
    public static final int IMG_KILUC = count++;
    public static final int IMG_txt_hd = count++;
    public static final int IMG_BT_VAO = count++;
    public static final int IMG_BT_RA = count++;
    public static final int IMG_BT_CH\u01a0IGAME = count++;
    public static final int IMG_BT_THOAT = count++;
    public static final int IMG_BT_CHOIMOI = count++;
    public static final int IMG_BT_CHOITIEP = count++;
    public static final int IMG_BT_DAUTRUONG = count++;
    public static final int IMG_BT_HUONGDAN = count++;
    public static final int IMG_BT_KILUC = count++;
    public static final int IMG_BT_THIETLAP = count++;
    public static final int IMG_BT_THANH = count++;
    public static final int IMG_ND_GAME = count++;
    public static final int IMG_BG_T1 = count++;
    public static final int IMG_BG_T2 = count++;
    public static final int IMG_BG_T3 = count++;
    public static final int IMG_BG_D1 = count++;
    public static final int IMG_BG_D2 = count++;
    public static final int IMG_BG_D3 = count++;
    public static final int IMG_TAM_DUNG = count++;
    public static final int IMG_ITEM2 = count++;
    public static final int IMG_ITEM3 = count++;
    public static final int IMG_NHA1 = count++;
    public static final int IMG_NHA2 = count++;
    public static final int IMG_NHA3 = count++;
    public static final int IMG_NHA4 = count++;
    public static final int IMG_NHA5 = count++;
    public static final int IMG_NHA6 = count++;
    public static final int IMG_LAI = count++;
    public static final int IMG_LO = count++;
    public static final int IMG_BIEN = count++;
    public static final int IMG_BIEN2 = count++;
    public static final int IMG_BONG = count++;
    public static final int IMG_MUITEN = count++;
    public static final int IMG_FRAME = count++;
    public static final int IMG_NEXT = count++;
    public static final int IMG_PAUSE = count++;
    public static final int IMG_WIN = count++;
    public static final int IMG_WIN_TEXT_BOX = count++;
    public static final int IMG_GAME_OVER = count++;
    public static final int IMG_GAME_OVER_TEXT_BOX = count++;
    public static final int IMG_TEXT_BOX = count++;
    public static final int IMG_BUTTON_MENU = count++;
    public static final int IMG_TXT_BUTTON_MENU = count++;
    public static final int IMG_BUTTONLT = count++;
    public static final int IMG_TXT_BUTTONLT = count++;
    public static final int IMG_BUTTON_PAUSE = count++;
    public static final int IMG_BUTTON_RESTART = count++;
    public static final int IMG_TEXTBOX_FOCUS = count++;
    public static final int IMG_TEXTBOX_NORMAL = count++;
    public static final int IMG_SMALL_NUMBER = count++;
    public static final int IMG_SMALL_NUMBER1 = count++;
    public static final int IMG_BUTTON_RUN = count++;
    public static final int IMG_DIEM = count++;
    private static final String MIDTYPE = "audio/midi";
    private static final String WAVTYPE = "audio/x-wav";
    private static final String MP3TYPE = "audio/mpeg";
    public static final String[] imgNames = new String[]{"/PNG/splash.png", "/PNG/sound_txt.png", "/PNG/bg_menu.png", "/PNG/bg_other.png", "/PNG/am_luong.png", "/PNG/am_thanh.png", "/PNG/huong_dan.png", "/PNG/txt_gioithieu.png", "/PNG/about.png", "/PNG/thoat.png", "/PNG/spl.png", "/PNG/thietlap.png", "/PNG/gioithieu.png", "/PNG/kiluc.png", "/PNG/txt_huong_dan.png", "/PNG/button/btvao.png", "/PNG/button/btra.png", "/PNG/button/btchoigame.png", "/PNG/button/btthoat.png", "/PNG/button/choimoibt.png", "/PNG/button/choitiepbt.png", "/PNG/button/dautruong.png", "/PNG/button/Huongdan.png", "/PNG/button/kyluc_icon.png", "/PNG/button/thietlap_icon.png", "/PNG/button/thanh.png", "/PNG/BG_PLAY/dantruyen.png", "/PNG/BG_PLAY/bgtren_1.png", "/PNG/BG_PLAY/bgtren_2.png", "/PNG/BG_PLAY/bgtren_3.png", "/PNG/BG_PLAY/bgduoi_1.png", "/PNG/BG_PLAY/bgduoi_2.png", "/PNG/BG_PLAY/bgduoi_3.png", "/PNG/tamdung.png", "/PNG/icon2.png", "/PNG/icon3.png", "/PNG/edit/h1.png", "/PNG/edit/h2.png", "/PNG/edit/h3.png", "/PNG/edit/h4.png", "/PNG/edit/h5.png", "/PNG/edit/h6.png", "/PNG/edit/lai.png", "/PNG/edit/lo.png", "/PNG/edit/bien.png", "/PNG/edit/bien2.png", "/PNG/edit/1.png", "/PNG/edit/muiten.png", "/PNG/frame/frame.png", "/PNG/frame/next.png", "/PNG/frame/pause.png", "/PNG/frame/win.png", "/PNG/frame/win_textbox.png", "/PNG/frame/game_over.png", "/PNG/frame/game_over_textbox.png", "/PNG/frame/textbox.png", "/PNG/button/button_menu.png", "/PNG/button/txt_butt_menu.png", "/PNG/button/buttonlt.png", "/PNG/button/txt_butt_lt.png", "/PNG/button/button_pause.png", "/PNG/button/button_restart.png", "/PNG/button/textbox_focus.png", "/PNG/button/textbox_normal.png", "/PNG/small_num.png", "/PNG/small_num10.png", "/PNG/button/GO.png", "/PNG/diem.png"};
    private static final int MAX_IMG = imgNames.length;
    private Image[] img;
    private static final String[] soundsNames = new String[]{"/sound/play.mid"};
    public static final int SOUND_PLAY = 0;
    public static final int MAX_SOUND = soundsNames.length;
    private Sound[] sounds;
    public static final int[] splashArrayImages = new int[]{IMG_SPLASH, IMG_TXT_SOUND, IMG_BUTTONLT, IMG_TXT_BUTTONLT};
    public static final int[] menuArrayImages = new int[]{IMG_BG_MENU, IMG_BT_CHOIMOI, IMG_BT_CHOITIEP, IMG_BT_CH\u01a0IGAME, IMG_BT_DAUTRUONG, IMG_BT_HUONGDAN, IMG_BT_KILUC, IMG_BT_RA, IMG_BT_THANH, IMG_BT_THIETLAP, IMG_BT_THOAT, IMG_ND_GAME, IMG_BT_VAO};
    public static final int[] guideArrayImages = new int[]{IMG_BG_OTHER, IMG_GUIDE, IMG_BUTTONLT, IMG_TXT_BUTTONLT, IMG_txt_hd};
    public static final int[] aboutArrayImages = new int[]{IMG_BG_OTHER, IMG_GIOITHIEU, IMG_TXT_ABOUT, IMG_ABOUT, IMG_BUTTONLT, IMG_TXT_BUTTONLT};
    public static final int[] exitArrayImages = new int[]{IMG_SPL, IMG_SPLASH, IMG_EXIT, IMG_BUTTONLT, IMG_TXT_BUTTONLT};
    public static final int[] highScoreArrayImages = new int[]{IMG_BG_OTHER, IMG_KILUC, IMG_BUTTONLT, IMG_TXT_BUTTONLT};
    public static final int[] settingArrayImages = new int[]{IMG_BG_OTHER, IMG_THIETLAP, IMG_VOLUME, IMG_SEEK_BAR, IMG_BUTTONLT, IMG_TXT_BUTTONLT};
    public static final int[] gamePlayArrayImages = new int[]{IMG_SMALL_NUMBER, IMG_SMALL_NUMBER1, IMG_NHA1, IMG_NHA2, IMG_NHA3, IMG_NHA4, IMG_NHA5, IMG_NHA6, IMG_BIEN, IMG_LO, IMG_LAI, IMG_MUITEN, IMG_BIEN2, IMG_BONG, IMG_ITEM3, IMG_BUTTON_PAUSE, IMG_BUTTON_RESTART, IMG_BUTTON_RUN, IMG_GIOITHIEU, IMG_DIEM, IMG_TAM_DUNG};
    public static final int[] pauseArrayImages = new int[]{IMG_PAUSE, IMG_FRAME, IMG_BUTTONLT, IMG_TXT_BUTTONLT};
    public static final int[] gameoverArrayImages = new int[]{IMG_GAME_OVER, IMG_FRAME, IMG_BUTTONLT, IMG_TXT_BUTTONLT};
    public static final int[] winArrayImages = new int[]{IMG_WIN, IMG_FRAME, IMG_BUTTONLT, IMG_TXT_BUTTONLT};
    public static final int[] nextlevelArrayImages = new int[]{IMG_NEXT, IMG_FRAME, IMG_BUTTONLT, IMG_TXT_BUTTONLT};
    public static final int[] TextBoxWinArrayImages = new int[]{IMG_FRAME, IMG_TEXTBOX_FOCUS, IMG_TEXTBOX_NORMAL, IMG_TEXT_BOX, IMG_WIN_TEXT_BOX, IMG_BUTTONLT, IMG_TXT_BUTTONLT};
    public static final int[] TextBoxGameOverArrayImages = new int[]{IMG_FRAME, IMG_TEXTBOX_FOCUS, IMG_TEXTBOX_NORMAL, IMG_TEXT_BOX, IMG_GAME_OVER_TEXT_BOX, IMG_BUTTONLT, IMG_TXT_BUTTONLT};

    public Resource(CanvasGame _canvas) {
        this.cParent = _canvas;
        this.img = new Image[MAX_IMG];
        this.sounds = new Sound[MAX_SOUND];
    }

    public Image getIMG(int _code) {
        return this.img[_code];
    }

    public boolean load(int i) {
        try {
            this.img[i] = Image.createImage((String)imgNames[i]);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            System.out.println(i);
            return false;
        }
        return true;
    }

    public void unLoad(int i) {
        this.img[i] = null;
    }

    public void loadArray(int[] imgs) {
        if (imgs == null) {
            return;
        }
        for (int i = 0; i < imgs.length; ++i) {
            this.load(imgs[i]);
        }
    }

    public void unLoadArray(int[] imgs) {
        if (imgs == null) {
            return;
        }
        for (int i = 0; i < imgs.length; ++i) {
            this.unLoad(imgs[i]);
        }
    }

    public void loadSounds() {
        for (int i = 0; i < MAX_SOUND; ++i) {
            this.loadSound(i);
        }
    }

    public void unLoadSounds() {
        for (int i = 0; i < MAX_SOUND; ++i) {
            this.unLoadSound(i);
        }
    }

    private void loadSound(int i) {
        if (this.sounds[i] != null) {
            return;
        }
        try {
            String abc = soundsNames[i].substring(soundsNames[i].length() - 3, soundsNames[i].length());
            if (abc.equals("mid")) {
                this.sounds[i] = Sound.createSound(this.getClass().getResourceAsStream(soundsNames[i]), MIDTYPE);
            } else if (abc.equals("wav")) {
                this.sounds[i] = Sound.createSound(this.getClass().getResourceAsStream(soundsNames[i]), WAVTYPE);
            } else if (abc.equals("mp3")) {
                this.sounds[i] = Sound.createSound(this.getClass().getResourceAsStream(soundsNames[i]), MP3TYPE);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void unLoadSound(int i) {
        if (this.sounds[i] != null) {
            this.sounds[i].release();
            this.sounds[i] = null;
        }
    }

    public void playSound(int name, int repeat) {
        try {
            String abc = soundsNames[name].substring(soundsNames[name].length() - 3, soundsNames[name].length());
            if (abc.equals("mid")) {
                this.sounds[name] = null;
            }
            this.loadSound(name);
            if (abc.equals("mid")) {
                this.sounds[name].setVolumeLevel(CanvasGame.musicLevel);
            } else if (abc.equals("wav")) {
                if (CanvasGame.musicLevel >= 50) {
                    this.sounds[name].setVolumeLevel(CanvasGame.musicLevel / 3);
                } else {
                    this.sounds[name].setVolumeLevel(CanvasGame.musicLevel / 7);
                }
            }
            this.sounds[name].repeat(repeat);
            this.sounds[name].start();
        }
        catch (MediaException ex) {
            System.out.println(ex.toString() + "3");
        }
    }

    public Sound getSound(int code) {
        return this.sounds[code];
    }

    public void setSounds(Sound sounds, int code) {
        this.sounds[code] = sounds;
    }
}

