/*
 * Decompiled with CFR 0.152.
 */
package ClassFrame;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    public static final String controlType = "VolumeControl";
    private Player player;
    private VolumeControl vc;

    public static Sound createSound(InputStream stream, String type) throws IOException, MediaException {
        Sound sound = new Sound();
        Player p = Manager.createPlayer((InputStream)stream, (String)type);
        p.prefetch();
        VolumeControl vc = (VolumeControl)p.getControl(controlType);
        sound.setPlayer(p);
        sound.setVolumeControl(vc);
        return sound;
    }

    public void release() {
        this.vc = null;
        try {
            if (this.player != null) {
                if (this.player.getState() == 400) {
                    this.player.stop();
                }
                if (this.player.getState() == 300) {
                    this.player.deallocate();
                }
                if (this.player.getState() == 200 || this.player.getState() == 100) {
                    this.player.close();
                }
                this.player = null;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void start() throws MediaException {
        if (this.player != null) {
            this.player.start();
        }
    }

    public void stop() {
        try {
            if (this.player != null) {
                this.player.stop();
            }
        }
        catch (MediaException ex) {
            System.out.println(ex.toString() + "3");
        }
    }

    public void repeat(int code) {
        this.player.setLoopCount(code);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public VolumeControl getVc() {
        return this.vc;
    }

    public void setVolumeControl(VolumeControl vc) {
        this.vc = vc;
    }

    public int getVolumeLevel() {
        return this.vc.getLevel();
    }

    public void setVolumeLevel(int volumeLevel) {
        this.vc.setLevel(volumeLevel);
    }
}

