/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Button;
import game.DisplayableCanvas;
import game.DrawString;
import game.HomingFishMidlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public final class MainMenu {
    DisplayableCanvas dc;
    int MENU_MODE;
    int WIDTH;
    int HEIGHT;
    Image imgLogo;
    Image imgSplash;
    Image imgAboutLogo;
    Font font = Font.getFont((int)0, (int)1, (int)16);
    boolean isContinue;
    boolean onoffs = true;
    boolean onoffv = true;
    Button butContinue;
    Button butNewGame;
    Button butOption;
    Button butHelp;
    Button butAbout;
    Button butExit;
    Button butSoundon;
    Button butSoundoff;
    Button butVibrateon;
    Button butVibrateoff;
    Button buttonHome;
    Image imghelppatch;
    int selectIndex = 1;
    byte optionIndex;
    int levelindex;
    boolean ispress;
    private RecordStore soundSettings;

    public MainMenu(DisplayableCanvas object, DrawString object2) {
        this.dc = object;
        this.WIDTH = ((DisplayableCanvas)object).WIDTH;
        this.HEIGHT = ((DisplayableCanvas)object).HEIGHT;
        object = this;
        try {
            ((MainMenu)object).soundSettings = RecordStore.openRecordStore((String)"FishSettings", (boolean)true);
            if (((MainMenu)object).soundSettings.getNumRecords() > 0) {
                object2 = ((MainMenu)object).soundSettings.getRecord(1);
                object2 = new DataInputStream(new ByteArrayInputStream((byte[])object2));
                ((MainMenu)object).onoffs = ((DataInputStream)object2).readBoolean();
                ((MainMenu)object).onoffv = ((DataInputStream)object2).readBoolean();
                ((FilterInputStream)object2).close();
            } else {
                object2 = new ByteArrayOutputStream(60);
                DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object2);
                ((MainMenu)object).onoffs = true;
                ((MainMenu)object).onoffv = true;
                dataOutputStream.writeBoolean(((MainMenu)object).onoffs);
                dataOutputStream.writeBoolean(((MainMenu)object).onoffv);
                dataOutputStream.flush();
                dataOutputStream.close();
                object2 = ((ByteArrayOutputStream)object2).toByteArray();
                dataOutputStream.close();
                ((MainMenu)object).soundSettings.addRecord((byte[])object2, 0, ((Object)object2).length);
            }
            ((MainMenu)object).soundSettings.closeRecordStore();
            return;
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    public final void resetSplash() {
        try {
            this.imgLogo = Image.createImage((String)"/res/menu/logo.png");
            this.imgSplash = Image.createImage((String)"/res/menu/splash.png");
        }
        catch (Exception exception) {
            Exception io = exception;
            exception.printStackTrace();
        }
        this.MENU_MODE = 0;
    }

    public final void resetMainMenu() {
        if (this.butContinue == null) {
            this.butContinue = new Button(0, 0, "/res/menu/continue1.png", "/res/menu/continue0.png");
            this.butNewGame = new Button(0, 0, "/res/menu/play1.png", "/res/menu/play0.png");
            this.butOption = new Button(0, 0, "/res/menu/option1.png", "/res/menu/option0.png");
            this.butHelp = new Button(0, 0, "/res/menu/help1.png", "/res/menu/help0.png");
            this.butAbout = new Button(0, 0, "/res/menu/about1.png", "/res/menu/about0.png");
            this.butExit = new Button(0, 0, "/res/menu/exit1.png", "/res/menu/exit0.png");
            this.butSoundon = new Button(0, 0, "/res/menu/soundon0.png", "/res/menu/soundon1.png");
            this.butSoundoff = new Button(0, 0, "/res/menu/soundoff0.png", "/res/menu/soundoff1.png");
            this.butVibrateon = new Button(0, 0, "/res/menu/vibrateon0.png", "/res/menu/vibrateon1.png");
            this.butVibrateoff = new Button(0, 0, "/res/menu/vibrateoff0.png", "/res/menu/vibrateoff1.png");
            this.buttonHome = new Button(this.WIDTH - 52, this.HEIGHT - 17, "/res/menu/home0.png", "/res/menu/home1.png");
            this.butSoundon.setXY((this.WIDTH >> 1) - this.butSoundon.width / 2, 110);
            this.butSoundoff.setXY((this.WIDTH >> 1) - this.butSoundoff.width / 2, 110);
            this.butVibrateon.setXY((this.WIDTH >> 1) - this.butVibrateon.width / 2, 155);
            this.butVibrateoff.setXY((this.WIDTH >> 1) - this.butVibrateoff.width / 2, 155);
        }
        if (this.isContinue) {
            this.butContinue.setXY(this.WIDTH - this.butContinue.width >> 1, 55);
            this.butNewGame.setXY(this.WIDTH - this.butNewGame.width >> 1, this.butContinue.y + 32);
            this.butOption.setXY(this.WIDTH - this.butOption.width >> 1, this.butNewGame.y + 32);
            this.butHelp.setXY(this.WIDTH - this.butHelp.width >> 1, this.butOption.y + 32);
            this.butAbout.setXY(this.WIDTH - this.butAbout.width >> 1, this.butHelp.y + 32);
            this.butExit.setXY(this.WIDTH - this.butExit.width >> 1, this.butAbout.y + 32);
        } else {
            this.butNewGame.setXY(this.WIDTH - this.butNewGame.width >> 1, 55);
            this.butOption.setXY(this.WIDTH - this.butOption.width >> 1, this.butNewGame.y + 38);
            this.butHelp.setXY(this.WIDTH - this.butHelp.width >> 1, this.butOption.y + 38);
            this.butAbout.setXY(this.WIDTH - this.butAbout.width >> 1, this.butHelp.y + 38);
            this.butExit.setXY(this.WIDTH - this.butExit.width >> 1, this.butAbout.y + 38);
        }
        this.MENU_MODE = 1;
    }

    public final void resetMode(int n) {
        switch (n) {
            case 0: {
                this.resetSplash();
                break;
            }
            case 1: {
                if (this.imgSplash == null) {
                    try {
                        this.imgSplash = Image.createImage((String)"/res/menu/menuBg.png");
                        this.imghelppatch = Image.createImage((String)"/res/menu/helplayer.png");
                        Image.createImage((String)"/res/menu/gameTitle.png");
                    }
                    catch (Exception exception) {
                        Exception exception2 = exception;
                        exception.printStackTrace();
                    }
                }
                this.resetMainMenu();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                MainMenu mainMenu = this;
                try {
                    if (mainMenu.imgAboutLogo != null) break;
                    mainMenu.imgAboutLogo = Image.createImage((String)"/res/menu/aboutLogo.png");
                    break;
                }
                catch (Exception exception) {}
            }
        }
        this.MENU_MODE = n;
        this.dc.refreshTheBannerAd();
    }

    void selection() {
        switch (this.selectIndex) {
            case 0: {
                this.clearImage();
                this.dc.continueGame();
                this.dc.getClass();
                this.dc.GAME_MODE = 5;
                return;
            }
            case 1: {
                this.clearImage();
                this.dc.initGame();
                this.isContinue = true;
                return;
            }
            case 2: {
                this.resetMode(2);
                return;
            }
            case 3: {
                this.resetMode(3);
                return;
            }
            case 4: {
                this.resetMode(4);
                return;
            }
            case 5: {
                HomingFishMidlet homingFishMidlet = this.dc.midlet;
                homingFishMidlet.destroyApp(true);
                homingFishMidlet.notifyDestroyed();
                return;
            }
            case 6: {
                this.dc.onClickBannerAd();
                return;
            }
            case 7: {
                this.clearImage();
                this.dc.initGame();
                this.isContinue = true;
            }
        }
    }

    private void clearImage() {
        this.imgSplash = null;
        this.imghelppatch = null;
        this.imgAboutLogo = null;
        this.butContinue = null;
        this.butNewGame = null;
        this.butOption = null;
        this.butHelp = null;
        this.butAbout = null;
        this.butExit = null;
        this.butSoundon = null;
        this.butSoundoff = null;
        this.butVibrateon = null;
        this.butVibrateoff = null;
        this.buttonHome = null;
        System.gc();
        System.out.println("Menu Cleared");
    }

    public final void run() {
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter <= 60) break;
                this.imgLogo = null;
                this.imgSplash = null;
                this.resetMode(1);
            }
        }
    }
}

