/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class HighScore {
    private GameCanvas canvas;
    protected final byte MAX_HIGHSCORE_NAME_CHARACTERS = (byte)4;
    protected int nCurrentCharacter;
    protected int nCurrentCharacterIndex = 1;
    protected int nCurrentEditedPlaceX;
    protected boolean bHighscoreEditing;
    protected int nCurrentEditedPlaceY;
    protected int nCarretBlink;
    protected int nCarretUnblink;
    protected byte[] highScoreName;
    private byte[] allowedChars = null;
    private byte[] upperCaseChars = new byte[]{32, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private byte[] loverCaseChars = new byte[]{32, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    public byte scoreType;

    public HighScore(GameCanvas _canvas) {
        this.canvas = _canvas;
        this.highScoreName = new byte[4];
    }

    public void setScoreType(byte _scoreType) {
        this.scoreType = _scoreType;
    }

    public void update() {
        if (this.bHighscoreEditing) {
            ++this.nCarretUnblink;
            this.nCarretUnblink %= 2;
            if (this.nCarretUnblink == 0) {
                ++this.nCarretBlink;
                this.nCarretBlink %= 2;
            }
            this.canvas.requestPaint(this.canvas.PREQ_HIGHSCORE_PAINT);
        }
    }

    protected void highScoreEditing(boolean _bEnabled) {
        this.bHighscoreEditing = _bEnabled;
        if (this.bHighscoreEditing) {
            byte bPlayer = this.canvas.board.getPlayer();
            if (this.canvas.playerScore < this.canvas.computerScore) {
                bPlayer = this.canvas.board.getComputer();
            }
            this.nCurrentEditedPlaceY = Resources.isQualified(this.scoreType, Math.abs(this.canvas.playerScore - this.canvas.computerScore), bPlayer);
            this.nCurrentEditedPlaceX = 0;
            this.nCarretBlink = 0;
            if (this.nCurrentEditedPlaceY > -1) {
                for (int i = 0; i < this.highScoreName.length; ++i) {
                    this.highScoreName[i] = 65;
                }
                this.allowedChars = this.upperCaseChars;
            } else {
                this.bHighscoreEditing = false;
                this.canvas.board.newGame();
                this.canvas.playerScore = this.canvas.board.getScore(this.canvas.board.getPlayer());
                this.canvas.computerScore = this.canvas.board.getScore(this.canvas.board.getComputer());
            }
        } else {
            this.nCurrentEditedPlaceX = 0;
            this.nCurrentEditedPlaceY = -1;
            this.nCarretBlink = -1;
            this.canvas.board.newGame();
            this.canvas.playerScore = this.canvas.board.getScore(this.canvas.board.getPlayer());
            this.canvas.computerScore = this.canvas.board.getScore(this.canvas.board.getComputer());
        }
    }

    public boolean isEditing() {
        return this.bHighscoreEditing;
    }

    private byte getCharacterIndex(byte _c) {
        int i;
        for (i = 0; i < this.loverCaseChars.length; ++i) {
            if (_c != this.loverCaseChars[i]) continue;
            return (byte)i;
        }
        for (i = 0; i < this.upperCaseChars.length; ++i) {
            if (_c != this.upperCaseChars[i]) continue;
            return (byte)i;
        }
        return -1;
    }

    public void keyPressed(int _key) {
        switch (_key) {
            case -1: 
            case 1: 
            case 50: {
                System.out.println("hhhhhhhhhhhhhhhhhh");
                Resources.playFile(3);
                if (this.bHighscoreEditing) {
                    ++this.nCurrentCharacterIndex;
                    this.nCurrentCharacterIndex %= this.allowedChars.length;
                    this.nCurrentCharacter = this.allowedChars[this.nCurrentCharacterIndex];
                    this.highScoreName[this.nCurrentEditedPlaceX] = (byte)this.nCurrentCharacter;
                    break;
                }
                this.canvas.menu.menuUp();
                break;
            }
            case -2: 
            case 6: 
            case 56: {
                System.out.println("llllllllllllllllllllllllll");
                Resources.playFile(3);
                if (this.bHighscoreEditing) {
                    --this.nCurrentCharacterIndex;
                    this.nCurrentCharacterIndex %= this.allowedChars.length;
                    if (this.nCurrentCharacterIndex < 0) {
                        this.nCurrentCharacterIndex = this.allowedChars.length - 1;
                    }
                    this.nCurrentCharacter = this.allowedChars[this.nCurrentCharacterIndex];
                    this.highScoreName[this.nCurrentEditedPlaceX] = (byte)this.nCurrentCharacter;
                    break;
                }
                this.canvas.menu.menuDown();
                break;
            }
            case -4: 
            case 54: {
                if (this.bHighscoreEditing) {
                    this.nCurrentEditedPlaceX = this.nCurrentEditedPlaceX >= 3 ? 0 : ++this.nCurrentEditedPlaceX;
                    this.nCurrentCharacterIndex = this.getCharacterIndex(this.highScoreName[this.nCurrentEditedPlaceX]);
                    break;
                }
                this.canvas.menu.menuRight();
                break;
            }
            case -3: 
            case 52: {
                if (this.bHighscoreEditing) {
                    this.nCurrentEditedPlaceX = this.nCurrentEditedPlaceX > 0 ? --this.nCurrentEditedPlaceX : 3;
                    this.nCurrentCharacterIndex = this.getCharacterIndex(this.highScoreName[this.nCurrentEditedPlaceX]);
                    break;
                }
                this.canvas.menu.menuLeft();
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 35: 
            case 53: {
                if (this.bHighscoreEditing) {
                    Resources.playFile(1);
                    byte playerType = this.canvas.board.getPlayer();
                    if (this.canvas.playerScore < this.canvas.computerScore) {
                        playerType = this.canvas.board.getComputer();
                    }
                    Resources.storeHighscore(this.scoreType, playerType, new String(this.highScoreName), Math.abs(this.canvas.playerScore - this.canvas.computerScore));
                    this.highScoreEditing(false);
                }
                this.canvas.menu.menuSelect();
                this.canvas.requestPaint(this.canvas.PREQ_HIGHSCORE_PAINT);
                this.canvas.requestPaint(this.canvas.PREQ_MSGBOX_PAINT);
                break;
            }
            case 42: {
                if (!this.bHighscoreEditing) break;
                this.allowedChars = this.allowedChars == this.upperCaseChars ? this.loverCaseChars : this.upperCaseChars;
                this.nCurrentCharacter = this.allowedChars[this.nCurrentCharacterIndex];
                this.highScoreName[this.nCurrentEditedPlaceX] = (byte)this.nCurrentCharacter;
            }
        }
    }

    public void drawHighscorePlayer(Graphics _g, byte _playerType, int _x, int _y) {
        int clipXPos = _x;
        int clipYPos = _y - 2;
        _g.setClip(clipXPos, clipYPos, 11, 11);
        int pictureXPos = clipXPos;
        int pictureYPos = clipYPos;
        Board cfr_ignored_0 = this.canvas.board;
        if (_playerType == 0) {
            pictureXPos -= 11;
        }
        _g.drawImage(Resources.images[12], pictureXPos, pictureYPos, 20);
        _g.setClip(0, 0, this.canvas.getWidth(), 320);
    }

    public void paint(Graphics _g) {
        if (this.canvas.paintRequested[this.canvas.PREQ_HIGHSCORE_PAINT]) {
            this.canvas.donePaint(this.canvas.PREQ_HIGHSCORE_PAINT);
            System.out.println("PREQ_HIGHSCORE_PAINT ");
            this.canvas.abc.setAlign((byte)0);
            this.canvas.abc.drawString(_g, Resources.getText((short)57), this.canvas.msgboxX + 85, this.canvas.msgboxY + 2, this.canvas.boardWidth, 10, -1);
            this.canvas.abc.setAlign((byte)1);
            if (this.scoreType == 0) {
                this.canvas.abc.drawString(_g, Resources.getText((short)58), this.canvas.msgboxX - 115, this.canvas.msgboxY + 2, this.canvas.boardWidth + 30, 60, -1);
            } else if (this.scoreType == 1) {
                this.canvas.abc.drawString(_g, Resources.getText((short)59), this.canvas.msgboxX - 115, this.canvas.msgboxY + 2, this.canvas.boardWidth + 30, 60, -1);
            } else if (this.scoreType == 2) {
                this.canvas.abc.drawString(_g, Resources.getText((short)60), this.canvas.msgboxX - 115, this.canvas.msgboxY + 2, this.canvas.boardWidth + 30, 60, -1);
            } else if (this.scoreType == 3) {
                this.canvas.abc.drawString(_g, Resources.getText((short)61), this.canvas.msgboxX - 115, this.canvas.msgboxY + 2, this.canvas.boardWidth + 30, 60, -1);
            } else if (this.scoreType == 4) {
                this.canvas.abc.drawString(_g, Resources.getText((short)62), this.canvas.msgboxX - 115, this.canvas.msgboxY + 2, this.canvas.boardWidth + 30, 60, -1);
            }
            int startScoreX = this.canvas.boardX + 12;
            int startScoreY = this.canvas.boardY + 24;
            int currentScoreX = startScoreX;
            int currentScoreY = startScoreY;
            String scoreRecord = null;
            int toDisplay = Resources.scores[this.scoreType].size();
            if (this.bHighscoreEditing) {
                ++toDisplay;
            }
            if (toDisplay > Resources.MAX_HIGHSCORES) {
                toDisplay = Resources.MAX_HIGHSCORES;
            }
            int rc = 0;
            for (int i = 0; i < toDisplay; ++i) {
                int blink;
                byte bPlayer;
                String sName;
                int iScore;
                if (this.bHighscoreEditing && i == this.nCurrentEditedPlaceY) {
                    iScore = Math.abs(this.canvas.playerScore - this.canvas.computerScore);
                    sName = new String(this.highScoreName);
                    bPlayer = this.canvas.board.getPlayer();
                    if (this.canvas.playerScore < this.canvas.computerScore) {
                        bPlayer = this.canvas.board.getComputer();
                    }
                    blink = this.nCarretBlink == 0 ? this.nCurrentEditedPlaceX : -2;
                } else {
                    scoreRecord = (String)Resources.scores[this.scoreType].elementAt(rc);
                    iScore = Resources.getHighScoreValue(scoreRecord);
                    sName = Resources.getHighScoreName(scoreRecord);
                    bPlayer = Resources.getHighScorePlayer(scoreRecord);
                    blink = -1;
                    ++rc;
                }
                currentScoreX = startScoreX;
                this.canvas.abc.setAlign((byte)1);
                this.canvas.abc.drawInt(_g, iScore, currentScoreX + 64, currentScoreY + 1, 30, 10);
                currentScoreX = this.canvas.boardX + 121 - 40;
                this.canvas.abc.setAlign((byte)0);
                this.canvas.abc.drawString(_g, sName, currentScoreX + 75, currentScoreY - 4, 50, 10, blink);
                if (this.scoreType != 4) {
                    this.drawHighscorePlayer(_g, bPlayer, currentScoreX + 45, currentScoreY + 8);
                }
                currentScoreY += 17;
            }
        }
    }
}

