/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.hospital.animated;

import com.rocktasticgames.hospital.main.MainActivity;
import com.rocktasticgames.hospital.utils.ColorMatrixColorFilter;
import com.rocktasticgames.hospital.utils.GraphicsContainer;
import javax.microedition.lcdui.Image;

public class AnimatedElement {
    public static final long FLY_TIME = 200L;
    public static final int WIGGLE_DEGREE = 30;
    public static final long WIGGLE_TIME = 600L;
    public static final float STAMP_SMALL = 0.5f;
    public static final float STAMP_LARGE = 2.0f;
    public static final long STAMP_SMALL_TIME = 150L;
    public static final long STAMP_LARGE_TIME = 300L;
    public static final long STAMP_BACK_TIME = 150L;
    public static final long FADE_TIME = 200L;
    public static final long BOUNCE_TIME = 700L;
    public static final float BOUNCE_DIST = 0.03f;
    public static final float GRAVITY = 2.4489796E-7f;
    protected float x;
    protected float y;
    protected float parent_width;
    protected float parent_height;
    private long animate_time;
    private int animation;
    protected Image bmp;
    private boolean fly_out = false;
    protected ColorMatrixColorFilter filter;

    public AnimatedElement(MainActivity mainActivity, String string, float f, float f2, float f3, float f4, int n, long l) {
        this.x = f;
        this.y = f2;
        this.parent_width = f3;
        this.parent_height = f4;
        this.animation = n;
        this.animate_time = l;
        try {
            this.bmp = Image.createImage((String)("/" + string + ".png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AnimatedElement(MainActivity mainActivity, String string, float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.parent_width = f3;
        this.parent_height = f4;
        this.animation = 0;
        this.animate_time = 0L;
        try {
            this.bmp = Image.createImage((String)("/" + string + ".png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AnimatedElement(float f, float f2, float f3, float f4, int n, long l) {
        this.x = f;
        this.y = f2;
        this.parent_width = f3;
        this.parent_height = f4;
        this.animation = n;
        this.animate_time = l;
    }

    public AnimatedElement(Image image, float f, float f2, float f3, float f4, int n, long l) {
        this.x = f;
        this.y = f2;
        this.parent_width = f3;
        this.parent_height = f4;
        this.animation = n;
        this.animate_time = l;
        this.bmp = image;
    }

    public AnimatedElement clone() {
        return new AnimatedElement(this.bmp, this.x, this.y, this.parent_width, this.parent_height, this.animation, this.animate_time);
    }

    public long getElapsed(long l) {
        return l - this.animate_time;
    }

    public int getAnimation() {
        return this.animation;
    }

    public void recycle() {
        if (this.bmp != null) {
            this.bmp = null;
            System.gc();
        }
    }

    public boolean inRange(float f, float f2) {
        if (this.fly_out) {
            return false;
        }
        return (float)Math.abs((int)(1000.0f * (this.x - f))) / 1000.0f < (float)this.bmp.getWidth() / this.parent_width / 2.0f && (float)Math.abs((int)(1000.0f * (this.y - f2))) / 1000.0f < (float)this.bmp.getHeight() / this.parent_height / 2.0f;
    }

    public int getWidth() {
        return this.bmp.getWidth();
    }

    public int getHeight() {
        return this.bmp.getHeight();
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getX(long l) {
        long l2 = this.fly_out ? this.animate_time + 200L - l : l - this.animate_time;
        if (l2 < 200L) {
            if (this.animation == 3) {
                return this.x * this.parent_width - (this.x * this.parent_width + (float)(this.getWidth() / 2)) * (float)(200L - l2) / 200.0f;
            }
            if (this.animation == 4) {
                return this.x * this.parent_width + ((1.0f - this.x) * this.parent_width + (float)(this.getWidth() / 2)) * (float)(200L - l2) / 200.0f;
            }
        }
        return this.x * this.parent_width;
    }

    public float getY(long l) {
        long l2 = this.fly_out ? this.animate_time + 200L - l : l - this.animate_time;
        if (l2 < 200L) {
            if (this.animation == 5) {
                return this.y * this.parent_height - (this.y * this.parent_height + (float)(this.getHeight() / 2)) * (float)(200L - l2) / 200.0f;
            }
            if (this.animation == 6) {
                return this.y * this.parent_height + ((1.0f - this.y) * this.parent_height + (float)(this.getHeight() / 2)) * (float)(200L - l2) / 200.0f;
            }
        }
        return this.y * this.parent_height;
    }

    public boolean isAnimatingOut() {
        return this.fly_out;
    }

    public void animateOut(long l) {
        this.animate_time = l;
        this.fly_out = true;
    }

    public void animate(int n, long l) {
        this.fly_out = false;
        this.animation = n;
        this.animate_time = l;
    }

    public void setPNG(String string) {
        try {
            this.bmp = Image.createImage((String)("/" + string + ".png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPNG(Image image) {
        this.bmp = image;
    }

    public void setFilter(ColorMatrixColorFilter colorMatrixColorFilter) {
        this.filter = colorMatrixColorFilter;
    }

    public ColorMatrixColorFilter getFilter() {
        return this.filter;
    }

    public boolean render(GraphicsContainer graphicsContainer, long l) {
        long l2 = this.fly_out ? this.animate_time + 200L - l : l - this.animate_time;
        boolean bl = false;
        graphicsContainer.translate((int)(this.x * this.parent_width), (int)(this.y * this.parent_height));
        switch (this.animation) {
            case 7: {
                if (l2 < 0L) {
                    graphicsContainer.translate(-graphicsContainer.getTranslateX(), -graphicsContainer.getTranslateY());
                    return false;
                }
                l2 = Math.abs(l2 % 700L - 350L);
                graphicsContainer.translate(0, (int)((-0.03f + (float)(l2 * l2) * 2.4489796E-7f) * this.parent_width));
                break;
            }
            case 8: {
                if (l2 < 0L) {
                    graphicsContainer.translate(-graphicsContainer.getTranslateX(), -graphicsContainer.getTranslateY());
                    return false;
                }
                bl = true;
                break;
            }
            case 1: {
                if (l2 < 0L) {
                    graphicsContainer.translate(-graphicsContainer.getTranslateX(), -graphicsContainer.getTranslateY());
                    return false;
                }
                if (l2 < 150L) {
                    float f = 1.0f - 0.5f * (float)l2 / 150.0f;
                    break;
                }
                if (l2 < 450L) {
                    float f = 0.5f + 1.5f * (float)(l2 - 150L) / 300.0f;
                    break;
                }
                if (l2 < 600L) {
                    float f = 2.0f - 1.0f * (float)(l2 - 300L - 150L) / 150.0f;
                    break;
                }
                float f = 1.0f;
                bl = true;
                break;
            }
            case 3: {
                if (l2 < 200L) {
                    graphicsContainer.translate((int)(-(this.x * this.parent_width + (float)(this.getWidth() / 2)) * (float)(200L - l2) / 200.0f), 0);
                    break;
                }
                if (l2 < 0L) break;
                bl = true;
                break;
            }
            case 4: {
                if (l2 < 200L) {
                    graphicsContainer.translate((int)(((1.0f - this.x) * this.parent_width + (float)(this.getWidth() / 2)) * (float)(200L - l2) / 200.0f), 0);
                    break;
                }
                if (l2 < 0L) break;
                bl = true;
                break;
            }
            case 5: {
                if (l2 < 200L) {
                    graphicsContainer.translate(0, (int)(-(this.y * this.parent_height + (float)(this.getHeight() / 2)) * (float)(200L - l2) / 200.0f));
                    break;
                }
                if (l2 < 0L) break;
                bl = true;
                break;
            }
            case 6: {
                if (l2 < 200L) {
                    graphicsContainer.translate(0, (int)(((1.0f - this.y) * this.parent_height + (float)(this.getHeight() / 2)) * (float)(200L - l2) / 200.0f));
                    break;
                }
                if (l2 < 0L) break;
                bl = true;
                break;
            }
            case 0: {
                if (l2 < 0L) {
                    graphicsContainer.translate(-graphicsContainer.getTranslateX(), -graphicsContainer.getTranslateY());
                    return false;
                }
                bl = true;
            }
        }
        this.drawTime(graphicsContainer, l);
        graphicsContainer.translate(-graphicsContainer.getTranslateX(), -graphicsContainer.getTranslateY());
        return bl;
    }

    protected void drawTime(GraphicsContainer graphicsContainer, long l) {
        this.draw(graphicsContainer);
    }

    protected void draw(GraphicsContainer graphicsContainer) {
        if (this.filter != null) {
            graphicsContainer.drawImage(this.filter.applyTo(this.bmp), 0, 0, 3);
        } else {
            graphicsContainer.drawImage(this.bmp, 0, 0, 3);
        }
    }

    public static class Animation {
        public static final int NONE = 0;
        public static final int STAMP = 1;
        public static final int FLY_LEFT = 3;
        public static final int FLY_RIGHT = 4;
        public static final int FLY_TOP = 5;
        public static final int FLY_BOTTOM = 6;
        public static final int BOUNCE = 7;
        public static final int FADE = 8;
    }
}

