/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.hospital.views;

import com.rocktasticgames.hospital.animated.AnimatedElement;
import com.rocktasticgames.hospital.main.MainActivity;
import com.rocktasticgames.hospital.utils.GraphicsContainer;
import com.rocktasticgames.hospital.utils.MotionEvent;
import com.rocktasticgames.hospital.views.MenuView;
import javax.microedition.lcdui.Image;

public class SoundView {
    private Image bg;
    private AnimatedElement on;
    private AnimatedElement off;
    private MainActivity activity;
    private boolean loaded = false;
    private int select_option = 0;
    private long start_time;

    public SoundView(MainActivity mainActivity) {
        this.activity = mainActivity;
        this.start_time = System.currentTimeMillis();
        try {
            this.bg = Image.createImage((String)"/opening_bg_sky.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        this.on.recycle();
        this.off.recycle();
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        if (n == 1 || n == 6) {
            return animatedElement;
        }
        if (n == 2) {
            return this.on;
        }
        return this.off;
    }

    private void loadResources(float f, float f2, float f3) {
        this.activity.registerDimensions(f2, f3);
        this.on = new AnimatedElement(this.activity, "soundon", 0.3f, 0.5f, f2, f3, 3, 300L);
        this.off = new AnimatedElement(this.activity, "soundoff", 0.7f, 0.5f, f2, f3, 4, 300L);
        if (this.activity.getSharedPref().getBoolean("sound_on", true)) {
            this.activity.getCanvas().setFocus(this.on);
        } else {
            this.activity.getCanvas().setFocus(this.off);
        }
        this.loaded = true;
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        float f = this.activity.getCanvas().getRZWidth();
        float f2 = this.activity.getCanvas().getRZHeight();
        if (!this.loaded) {
            this.loadResources(f / f2, f, f2);
        }
        long l = System.currentTimeMillis() - this.start_time;
        graphicsContainer.setColor(-1);
        graphicsContainer.fillScreen();
        boolean bl = false;
        if (!this.on.render(graphicsContainer, l)) {
            bl = true;
        }
        if (!this.off.render(graphicsContainer, l)) {
            bl = true;
        }
        if (bl) {
            this.activity.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        this.activity.invalidate();
        switch (n) {
            case 1: {
                switch (this.select_option) {
                    case 1: {
                        this.on.setFilter(null);
                        this.activity.getPrefEditor().putBoolean("music_on", true);
                        this.activity.getPrefEditor().putBoolean("sound_on", true);
                        this.activity.getPrefEditor().commit();
                        this.activity.onSoundComplete();
                        break;
                    }
                    case 2: {
                        this.off.setFilter(null);
                        this.activity.getPrefEditor().putBoolean("music_on", false);
                        this.activity.getPrefEditor().putBoolean("sound_on", false);
                        this.activity.getPrefEditor().commit();
                        this.activity.onSoundComplete();
                    }
                }
                this.select_option = 0;
                return false;
            }
            case 2: {
                if (this.on.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                    this.select_option = 1;
                    this.on.setFilter(MenuView.filter_dark);
                } else if (this.off.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                    this.select_option = 2;
                    this.off.setFilter(MenuView.filter_dark);
                }
                return true;
            }
            case 3: {
                switch (this.select_option) {
                    case 1: {
                        if (this.on.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.on.setFilter(null);
                        break;
                    }
                    case 2: {
                        if (this.off.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.off.setFilter(null);
                    }
                }
                return true;
            }
        }
        return true;
    }

    public static class MenuOption {
        public static final int NONE = 0;
        public static final int ON = 1;
        public static final int OFF = 2;
    }
}

