/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.buttons;

import com.apr.game.buttons.Button;
import javax.microedition.lcdui.Image;

public abstract class ButtonMultiple
extends Button {
    protected byte value;
    protected String attribute;
    protected String name;
    protected String[] values;

    public ButtonMultiple(String name, String attribute, String[] values, Image image) {
        super(image, name);
        this.name = name;
        this.attribute = attribute;
        this.values = values;
        this.value = 0;
    }

    public void right() {
        this.value = (byte)(this.value + 1);
        if (this.value >= this.values.length) {
            this.value = 0;
        }
        this.setStringValue();
        this.saveValue();
        this.setSetting();
    }

    public void left() {
        this.value = (byte)(this.value - 1);
        if (this.value < 0) {
            this.value = (byte)(this.values.length - 1);
        }
        this.setStringValue();
        this.saveValue();
        this.setSetting();
    }

    public void setStringValue() {
        this.text = null;
        this.text = this.name + ":" + this.values[this.value];
    }

    public void fire() {
        this.right();
    }

    public abstract void loadValue();

    public abstract void setSetting();

    public abstract void saveValue();
}

