/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.displayable;

import com.apr.game.displayable.Displayable;
import javax.microedition.lcdui.Graphics;
import net.jscience.math.kvm.MathFP;

public final class ProgressBar
extends Displayable {
    private static final int COLOR_LINE = 0;
    private static final int COLOR_BAR = 0xFFFFFF;
    private int currentFP;
    private int increaseFP;
    private int x;
    private int y;
    private int w;
    private int h;

    public ProgressBar(int x, int y, int w, int h, int goal) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.increaseFP = MathFP.div(MathFP.toFP(w), MathFP.toFP(goal));
    }

    public void enter() {
        this.currentFP = MathFP.toFP(0);
    }

    public void render(Graphics g) {
        g.setColor(0);
        g.fillRect(this.x, this.y, this.w, this.h);
        g.setColor(0xFFFFFF);
        g.fillRect(this.x, this.y, MathFP.toInt(this.currentFP), this.h);
        g.setColor(0);
        g.drawRect(this.x, this.y, this.w, this.h);
    }

    public void exit() {
    }

    public void increase() {
        this.currentFP = MathFP.add(this.currentFP, this.increaseFP);
    }
}

