/*
 * Decompiled with CFR 0.152.
 */
package logic;

public final class Board {
    public byte[] board;
    private boolean turn;

    public Board(int size, boolean turn) {
        this.board = new byte[size * size];
        this.turn = turn;
    }

    public Board(Board b) {
        this.board = new byte[b.size()];
        this.copy(b);
    }

    public boolean getTurn() {
        return this.turn;
    }

    public void copy(Board b) {
        for (int i = 0; i < this.board.length; ++i) {
            this.board[i] = b.board[i];
        }
        this.turn = b.turn;
    }

    private void set(int index, byte value) {
        this.board[index] = value;
        this.turn = !this.turn;
    }

    public void makeMove(int index) {
        if (this.turn) {
            this.set(index, (byte)1);
        } else {
            this.set(index, (byte)2);
        }
    }

    public byte get(int index) {
        if (index < 0 || index > this.board.length) {
            return -1;
        }
        return this.board[index];
    }

    public int size() {
        return this.board.length;
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.board.length; ++i) {
            s = s + this.board[i];
        }
        return s;
    }
}

