/*
 * Decompiled with CFR 0.152.
 */
package logic;

import com.apr.game.Utils;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class TTTConstants
extends Utils {
    public static final Boolean FALSE = new Boolean(false);
    public static final Boolean TRUE = new Boolean(true);
    public static final String[] COLORS_STRING = new String[]{"yellow", "orange", "green", "blue"};
    public static final boolean TURN_X = true;
    public static final boolean TURN_O = false;
    public static final byte NO_WIN = -1;
    public static final int YELLOW = 0xFFFF00;
    public static String SOUND_STRING = "sound";
    public static String VIBRATION_STRING = "vibration";
    public static String CURRENT_SIZE_STRING = "board_size";
    public static String FINISH_ROW_STRING = "finish";
    public static String GAME_POINTS_STRING = "game_points";
    public static String TIMED_GAME_STRING = "timed_gamed";
    public static String TURN_TIME_STRING = "turn_time";
    public static String COMPUTER_OPONENT_STRING = "computer_oponent";
    public static String COMPUTER_LEVEL_STRING = "level";
    public static String WHO_STARTS_STRING = "who_starts";
    public static String X_NAME_STRING = "x_name";
    public static String O_NAME_STRING = "o_name";
    public static String X_COLOR_STRING = "x_color";
    public static String O_COLOR_STRING = "o_color";
    public static String PLAYER_PIECE_STRING = "player_piece";
    public static final byte EMPTY = 0;
    public static final byte X = 1;
    public static final byte O = 2;
    public static final byte SWITCH = 3;
    public static final byte RANDOM = 4;
    public static final byte[] BOARD_SIZES = new byte[]{3, 4, 5};
    public static final byte[] TIMES = new byte[]{20, 30, 40};
    public static final byte[] FINISH_OPTIONS = new byte[]{3, 4, 5};
    public static boolean TOURNAMENT = true;
    public static byte BOARD_SIZE = 0;
    public static byte FINISH_CRITERIA = 0;
    public static byte GAME_POINTS = (byte)10;
    public static boolean TIMED_GAME = false;
    public static byte TURN_TIME = 0;
    public static boolean COMPUTER_OPONENT = true;
    public static byte COMPUTER_LEVEL = 1;
    public static byte WHO_STARTS = 0;
    public static String X_NAME;
    public static String O_NAME;
    public static byte X_COLOR;
    public static byte O_COLOR;
    public static byte PLAYER_PIECE;

    public static void loadValues() {
        TTTConstants.loadSound();
        TTTConstants.loadVibration();
        TTTConstants.loadSize();
        TTTConstants.loadFinish();
        TTTConstants.loadGamePoints();
        TTTConstants.loadTimedGame();
        TTTConstants.loadTurnTime();
        TTTConstants.loadComputerOponent();
        TTTConstants.loadComputerLevel();
        TTTConstants.loadWhoStarts();
        TTTConstants.loadXName();
        TTTConstants.loadOName();
        TTTConstants.loadXColor();
        TTTConstants.loadOColor();
    }

    public static void loadSound() {
        Boolean value = TTTConstants.checkBoolean(SOUND_STRING);
        if (value != null) {
            Utils.soundOn = value;
        }
    }

    public static void loadVibration() {
        Boolean value = TTTConstants.checkBoolean(VIBRATION_STRING);
        if (value != null) {
            Utils.vibrate = value;
        }
    }

    public static void loadSize() {
        Byte value = TTTConstants.checkByte(CURRENT_SIZE_STRING);
        if (value != null) {
            BOARD_SIZE = value;
        }
    }

    public static void loadFinish() {
        Byte value = TTTConstants.checkByte(FINISH_ROW_STRING);
        if (value != null) {
            FINISH_CRITERIA = value;
        }
    }

    public static void loadGamePoints() {
        Byte value = TTTConstants.checkByte(GAME_POINTS_STRING);
        if (value != null) {
            GAME_POINTS = value;
        }
    }

    public static void loadTimedGame() {
        Boolean value = TTTConstants.checkBoolean(TIMED_GAME_STRING);
        if (value != null) {
            TIMED_GAME = value;
        }
    }

    public static void loadTurnTime() {
        Byte value = TTTConstants.checkByte(TURN_TIME_STRING);
        if (value != null) {
            TURN_TIME = value;
        }
    }

    public static void loadComputerOponent() {
        Boolean value = TTTConstants.checkBoolean(COMPUTER_OPONENT_STRING);
        if (value != null) {
            COMPUTER_OPONENT = value;
        }
    }

    public static void loadComputerLevel() {
        Byte value = TTTConstants.checkByte(COMPUTER_LEVEL_STRING);
        if (value != null) {
            COMPUTER_LEVEL = value;
        }
    }

    public static void loadWhoStarts() {
        Byte value = TTTConstants.checkByte(WHO_STARTS_STRING);
        if (value != null) {
            WHO_STARTS = value;
        }
    }

    public static void loadXName() {
        String value = TTTConstants.checkString(X_NAME_STRING);
        if (value != null) {
            X_NAME = value;
        }
    }

    public static void loadOName() {
        String value = TTTConstants.checkString(O_NAME_STRING);
        if (value != null) {
            O_NAME = value;
        }
    }

    public static void loadXColor() {
        Byte value = TTTConstants.checkByte(X_COLOR_STRING);
        if (value != null) {
            X_COLOR = value;
        }
    }

    public static void loadOColor() {
        Byte value = TTTConstants.checkByte(O_COLOR_STRING);
        if (value != null) {
            O_COLOR = value;
        }
    }

    public static void loadPlayerPiece() {
        Byte value = TTTConstants.checkByte(PLAYER_PIECE_STRING);
        if (value != null) {
            PLAYER_PIECE = value;
        }
    }

    public static void save(String attribute, boolean value) {
        try {
            RecordStore record = RecordStore.openRecordStore((String)attribute, (boolean)true);
            String str = String.valueOf(value);
            int rId = 1;
            RecordEnumeration re = record.enumerateRecords(null, null, false);
            if (re.numRecords() == 0) {
                record.addRecord(str.getBytes(), 0, str.length());
            } else {
                while (re.hasNextElement()) {
                    rId = re.nextRecordId();
                }
                record.setRecord(rId, str.getBytes(), 0, str.length());
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public static void save(String attribute, byte value) {
        try {
            RecordStore record = RecordStore.openRecordStore((String)attribute, (boolean)true);
            String str = String.valueOf(value);
            int rId = 1;
            RecordEnumeration re = record.enumerateRecords(null, null, false);
            if (re.numRecords() == 0) {
                record.addRecord(str.getBytes(), 0, str.length());
            } else {
                while (re.hasNextElement()) {
                    rId = re.nextRecordId();
                }
                record.setRecord(rId, str.getBytes(), 0, str.length());
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    private static Boolean checkBoolean(String name) {
        try {
            String s = "";
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)false);
            RecordEnumeration rse = rs.enumerateRecords(null, null, false);
            while (rse.hasNextElement()) {
                s = new String(rs.getRecord(rse.nextRecordId()));
            }
            if (s.equals("false")) {
                return FALSE;
            }
            if (s.equals("true")) {
                return TRUE;
            }
            return null;
        }
        catch (RecordStoreException ex) {
            return null;
        }
    }

    private static Byte checkByte(String name) {
        try {
            String s = "";
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)false);
            RecordEnumeration rse = rs.enumerateRecords(null, null, false);
            while (rse.hasNextElement()) {
                s = new String(rs.getRecord(rse.nextRecordId()));
            }
            return new Byte((byte)Integer.valueOf(s).intValue());
        }
        catch (RecordStoreException ex) {
            return null;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static String checkString(String name) {
        try {
            String s = "";
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)false);
            RecordEnumeration rse = rs.enumerateRecords(null, null, false);
            while (rse.hasNextElement()) {
                s = new String(rs.getRecord(rse.nextRecordId()));
            }
            return s;
        }
        catch (RecordStoreException ex) {
            return null;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    static {
        X_COLOR = 0;
        O_COLOR = 0;
        PLAYER_PIECE = 0;
    }
}

