/*
 * Decompiled with CFR 0.152.
 */
package logic;

import java.util.Vector;
import logic.Board;
import logic.TTTConstants;

public class TTTRules
extends TTTConstants {
    private static final byte[][] FINISH_3 = new byte[][]{{0, 1, 2}, {3, 4, 5}, {6, 7, 8}, {0, 3, 6}, {1, 4, 7}, {2, 5, 8}, {0, 4, 8}, {2, 4, 6}};
    private static final byte[][] FINISH_4_BY_4 = new byte[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 9, 10, 11}, {12, 13, 14, 15}, {0, 4, 8, 12}, {1, 5, 9, 13}, {2, 6, 10, 14}, {3, 7, 11, 15}, {0, 5, 10, 15}, {3, 6, 9, 12}};
    private static final byte[][] FINISH_4_BY_3 = new byte[][]{{0, 1, 2}, {1, 2, 3}, {4, 5, 6}, {5, 6, 7}, {8, 9, 10}, {9, 10, 11}, {12, 13, 14}, {13, 14, 15}, {0, 4, 8}, {4, 8, 12}, {1, 5, 9}, {5, 9, 13}, {2, 6, 10}, {6, 10, 14}, {3, 7, 11}, {7, 11, 15}, {0, 5, 10}, {5, 10, 15}, {1, 6, 11}, {4, 9, 14}, {3, 6, 9}, {6, 9, 12}, {2, 5, 8}, {7, 10, 13}};
    private static final byte[][] FINISH_5_BY_5 = new byte[][]{{0, 1, 2, 3, 4}, {5, 6, 7, 8, 9}, {10, 11, 12, 13, 14}, {15, 16, 17, 18, 19}, {20, 21, 22, 23, 24}, {0, 5, 10, 15, 20}, {1, 6, 11, 16, 21}, {2, 7, 12, 17, 22}, {3, 8, 13, 18, 23}, {4, 9, 14, 19, 24}, {0, 6, 12, 18, 24}, {4, 8, 12, 16, 20}};
    private static final byte[][] FINISH_5_BY_4 = new byte[][]{{0, 1, 2, 3}, {1, 2, 3, 4}, {5, 6, 7, 8}, {6, 7, 8, 9}, {10, 11, 12, 13}, {11, 12, 13, 14}, {15, 16, 17, 18}, {16, 17, 18, 19}, {20, 21, 22, 23}, {21, 22, 23, 24}, {0, 5, 10, 15}, {5, 10, 15, 20}, {1, 6, 11, 16}, {6, 11, 16, 21}, {2, 7, 12, 17}, {7, 12, 17, 22}, {3, 8, 13, 18}, {8, 13, 18, 23}, {4, 9, 14, 19}, {9, 14, 19, 24}, {0, 6, 12, 18}, {6, 12, 18, 24}, {4, 8, 12, 16}, {8, 12, 16, 20}, {3, 7, 11, 15}, {9, 13, 17, 21}, {1, 7, 13, 19}, {5, 11, 17, 23}};
    public static byte[] WIN_COMBINATION;

    public static Vector GET_MOVES(Board board) {
        Vector<Byte> list = new Vector<Byte>();
        for (byte i = 0; i < board.size(); i = (byte)(i + 1)) {
            if (board.get(i) != 0) continue;
            list.addElement(new Byte(i));
        }
        return list;
    }

    public static byte IS_FINISH(Board board, int board_size, int win_size) {
        if (board_size == 5 && win_size == 5) {
            return TTTRules.FIND(board, FINISH_5_BY_5);
        }
        if (board_size == 4 && win_size == 4) {
            return TTTRules.FIND(board, FINISH_4_BY_4);
        }
        if (board_size == 4 && win_size == 3) {
            return TTTRules.FIND(board, FINISH_4_BY_3);
        }
        if (board_size == 5 && win_size == 4) {
            return TTTRules.FIND(board, FINISH_5_BY_4);
        }
        return TTTRules.FIND(board, FINISH_3);
    }

    public static byte[][] GET_COMBINATIONS(int board_size, int win_size) {
        if (board_size == 5 && win_size == 5) {
            return FINISH_5_BY_5;
        }
        if (board_size == 4 && win_size == 4) {
            return FINISH_4_BY_4;
        }
        if (board_size == 5 && win_size == 4) {
            return FINISH_5_BY_4;
        }
        return FINISH_3;
    }

    private static byte FIND(Board board, byte[][] checkings) {
        for (int i = 0; i < checkings.length; ++i) {
            if (!TTTRules.ALL_EQUAL(board, checkings[i])) continue;
            WIN_COMBINATION = checkings[i];
            return board.get(checkings[i][0]);
        }
        if (TTTRules.NO_EMPTY_SQUARES(board)) {
            WIN_COMBINATION = null;
            return -1;
        }
        WIN_COMBINATION = null;
        return 0;
    }

    private static boolean ALL_EQUAL(Board board, byte[] pieces) {
        if (board.get(pieces[0]) == 0) {
            return false;
        }
        for (int i = 0; i < pieces.length - 1; ++i) {
            if (board.get(pieces[i]) == board.get(pieces[i + 1])) continue;
            return false;
        }
        return true;
    }

    private static boolean NO_EMPTY_SQUARES(Board board) {
        for (int i = 0; i < board.size(); ++i) {
            if (board.get(i) != 0) continue;
            return false;
        }
        return true;
    }
}

