/*
 * Decompiled with CFR 0.152.
 */
package states;

import com.apr.game.displayable.ActionButton;
import com.apr.game.displayable.Background;
import com.apr.game.states.StateMoving;
import game.Locale;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;

public final class StateInfoTTT
extends StateMoving {
    private static final byte OFFSET = 2;
    private byte prevState;
    private byte nextState;
    private byte state;
    private Background background;
    private ActionButton prevButton;
    private ActionButton nextButton;
    private ActionButton backButton;
    private String[] data;
    private String name;
    private String top;
    private int startY;

    public StateInfoTTT(byte type, byte prevState, byte nextState, String name, Background background, int increase, int startY) {
        super(type, increase);
        this.prevState = prevState;
        this.nextState = nextState;
        this.background = background;
        this.startY = startY;
        this.name = name;
        this.backButton = new ActionButton(Locale.getString("BackImage"), 2);
        this.nextButton = new ActionButton(Locale.getString("NextImage"), 1);
        this.prevButton = new ActionButton(Locale.getString("PrevImage"), 0);
    }

    public void enter() throws IOException, MediaException {
        int chr;
        super.enter();
        this.prevButton.enter();
        this.nextButton.enter();
        this.backButton.enter();
        InputStream is = this.getClass().getResourceAsStream("/text/" + this.name + "_he.txt");
        InputStreamReader isr = new InputStreamReader(is, "UTF-8");
        StringBuffer sb = new StringBuffer();
        int lines = -1;
        int i = 0;
        boolean first = false;
        while ((chr = isr.read()) != -1) {
            if (chr == 10) {
                if (!first) {
                    this.top = sb.toString();
                    first = true;
                    i = 0;
                } else if (lines == -1) {
                    lines = Integer.parseInt(sb.toString());
                    this.data = new String[lines];
                    i = 0;
                } else {
                    this.data[i] = sb.toString();
                    ++i;
                }
                sb.delete(0, sb.length());
                continue;
            }
            if (chr > 10000 || chr == 13) continue;
            sb.append((char)chr);
        }
    }

    public void exit() throws MediaException {
        this.data = null;
        this.prevButton.exit();
        this.nextButton.exit();
        this.backButton.exit();
    }

    public byte nextState() {
        return this.state;
    }

    public void render(Graphics g) {
        this.background.render(g);
        if (this.data == null) {
            return;
        }
        font.print(g, this.offset + HALF_W, 0, this.top, (byte)0);
        for (int i = 0; i < this.data.length; ++i) {
            fontSmall.print(g, this.offset + HALF_W, this.startY + fontSmall.getH() * i, this.data[i], (byte)0);
        }
        this.prevButton.render(g);
        this.nextButton.render(g);
        this.backButton.render(g);
    }

    public void moveLeftAction() {
        this.state = this.prevState;
        this.currentStart = 1;
        this.prevButton.press();
        this.startEnding();
    }

    public void moveRightAction() {
        this.state = this.nextState;
        this.currentStart = 0;
        this.nextButton.press();
        this.startEnding();
    }

    public void fire() {
        this.state = (byte)-1;
        this.backButton.press();
        this.startEnding();
    }

    public void moveLeft() {
        this.moveLeftAction();
    }

    public void moveRight() {
        this.moveRightAction();
    }

    public void pressFour() {
        this.moveLeftAction();
    }

    public void pressSix() {
        this.moveRightAction();
    }

    public void pressFive() {
        this.fire();
    }

    protected void checkClick(int x, int y) {
        if (StateInfoTTT.inBounds(x, y, this.prevButton.getX(), this.prevButton.getY(), this.prevButton.getW(), this.prevButton.getH())) {
            this.moveLeftAction();
        }
        if (StateInfoTTT.inBounds(x, y, this.nextButton.getX(), this.nextButton.getY(), this.nextButton.getW(), this.nextButton.getH())) {
            this.moveRightAction();
        }
        if (StateInfoTTT.inBounds(x, y, this.backButton.getX(), this.backButton.getY(), this.backButton.getW(), this.backButton.getH())) {
            this.fire();
        }
    }
}

