/*
 * Decompiled with CFR 0.152.
 */
package states;

import buttons.ButtonBoardSize;
import buttons.ButtonComputerLevel;
import buttons.ButtonComputerOponent;
import buttons.ButtonFinish;
import buttons.ButtonGamePoints;
import buttons.ButtonOColor;
import buttons.ButtonPlayerPiece;
import buttons.ButtonSound;
import buttons.ButtonTurnTime;
import buttons.ButtonVibration;
import buttons.ButtonWhoStarts;
import buttons.ButtonXColor;
import com.apr.game.buttons.Button;
import com.apr.game.buttons.Buttons;
import com.apr.game.displayable.Background;
import com.apr.game.displayable.Title;
import com.apr.game.states.State;
import com.apr.game.states.StateMachine;
import game.Locale;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import logic.TTTConstants;
import states.options.StateOptionsPart;

public class StateOptions
extends StateMachine {
    private static final byte STATE_PART_1 = 1;
    private static final byte STATE_PART_2 = 2;
    private static final byte STATE_PART_3 = 3;

    public StateOptions(byte type, byte nextState, int increase, Image imgButtonShadow) throws IOException, MediaException {
        super(type, nextState);
        Background background = new Background("/images/options/back_settings.jpg");
        Title title = new Title(Locale.getString("OptionsImage"));
        State[] iStates = new State[3];
        ButtonSound buttonSound = new ButtonSound(Locale.getString("Options.Sound"), TTTConstants.SOUND_STRING, imgButtonShadow);
        ButtonVibration buttonVibration = new ButtonVibration(Locale.getString("Options.Vibration"), TTTConstants.VIBRATION_STRING, imgButtonShadow);
        ButtonGamePoints buttonNumGames = new ButtonGamePoints(Locale.getString("Options.GamePoints"), TTTConstants.GAME_POINTS_STRING, 10, 99, imgButtonShadow);
        String[] strLevel = new String[]{Locale.getString("EasyImage"), Locale.getString("MediumImage"), Locale.getString("HardImage")};
        ButtonComputerLevel buttonLevel = new ButtonComputerLevel(Locale.getString("Options.Difficulty"), TTTConstants.COMPUTER_LEVEL_STRING, strLevel, imgButtonShadow);
        Buttons buttons1 = new Buttons(new Button[]{buttonSound, buttonVibration, buttonNumGames, buttonLevel});
        iStates[0] = new StateOptionsPart(1, 3, 2, increase, imgButtonShadow, background, title, buttons1);
        String[] strComputerOponent = new String[]{"/images/options/computer.png", "/images/options/player.png"};
        ButtonComputerOponent buttonComputerOponent = new ButtonComputerOponent(Locale.getString("Options.Oponent"), TTTConstants.COMPUTER_OPONENT_STRING, strComputerOponent, imgButtonShadow);
        String[] strTurn = new String[]{"/images/options/no_time.png", "/images/options/20.png", "/images/options/30.png", "/images/options/40.png"};
        ButtonTurnTime buttonTurnTime = new ButtonTurnTime(Locale.getString("Options.TurnTime"), TTTConstants.TURN_TIME_STRING, strTurn, imgButtonShadow);
        String[] strFinish = new String[]{"Normal", "3inLine"};
        ButtonFinish buttonFinish = new ButtonFinish(Locale.getString("Options.Finish"), TTTConstants.FINISH_ROW_STRING, strFinish, imgButtonShadow);
        String[] strBoard = new String[]{"/images/options/3x3.png", "/images/options/4x4.png", "/images/options/5x5.png"};
        ButtonBoardSize buttonBoardSize = new ButtonBoardSize(Locale.getString("Options.Size"), TTTConstants.CURRENT_SIZE_STRING, strBoard, imgButtonShadow, buttonFinish);
        Buttons buttons2 = new Buttons(new Button[]{buttonComputerOponent, buttonTurnTime, buttonBoardSize, buttonFinish});
        iStates[1] = new StateOptionsPart(2, 1, 3, increase, imgButtonShadow, background, title, buttons2);
        String[] strWhoStarts = new String[]{"/images/x_blue_small.png", "/images/o_blue_small.png", "/images/options/switch.png", "/images/options/random.png"};
        ButtonWhoStarts buttonWhoStarts = new ButtonWhoStarts(Locale.getString("Options.WhoStarts"), TTTConstants.WHO_STARTS_STRING, strWhoStarts, imgButtonShadow);
        String[] strPlayerPiece = new String[]{"/images/x_blue_small.png", "/images/o_blue_small.png"};
        ButtonPlayerPiece buttonPlayerPiece = new ButtonPlayerPiece(Locale.getString("Options.PlayerPiece"), TTTConstants.PLAYER_PIECE_STRING, strPlayerPiece, imgButtonShadow);
        String[] strXColor = new String[]{"/images/options/random.png", "/images/x_yellow_small.png", "/images/x_orange_small.png", "/images/x_green_small.png", "/images/x_blue_small.png"};
        ButtonXColor buttonXColor = new ButtonXColor(Locale.getString("Options.XColor"), TTTConstants.X_COLOR_STRING, strXColor, imgButtonShadow);
        String[] strOColor = new String[]{"/images/options/random.png", "/images/o_yellow_small.png", "/images/o_orange_small.png", "/images/o_green_small.png", "/images/o_blue_small.png"};
        ButtonOColor buttonOColor = new ButtonOColor(Locale.getString("Options.OColor"), TTTConstants.O_COLOR_STRING, strOColor, imgButtonShadow);
        Buttons buttons3 = new Buttons(new Button[]{buttonWhoStarts, buttonPlayerPiece, buttonXColor, buttonOColor});
        iStates[2] = new StateOptionsPart(3, 2, 1, increase, imgButtonShadow, background, title, buttons3);
        this.addStates(iStates);
        this.setDefaultState(iStates[0]);
    }
}

