/*
 * Decompiled with CFR 0.152.
 */
package states.play;

import com.apr.game.displayable.Displayable;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class DropDownMenu
extends Displayable {
    protected static int GOAL_Y = 0;
    protected static int INCREASE_Y = 10;
    protected static final byte STATE_NORMAL = 0;
    protected static final byte STATE_MOVING = 1;
    protected static final byte STATE_EXITING = 2;
    protected byte state = 0;
    protected String[] items;
    protected boolean[] available;
    protected int y;
    protected byte selected;
    protected boolean done;
    protected Image imgBack;

    public DropDownMenu(String[] items) throws IOException {
        this.items = items;
        this.imgBack = Image.createImage((String)"/images/game/dropdown_back.png");
        this.available = new boolean[items.length];
    }

    public void enter() throws IOException {
    }

    public void setNotAvailable(int index) {
        this.available[index] = false;
        int amount = 0;
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.available[i]) continue;
            ++amount;
        }
        GOAL_Y = H - font.getH() * amount;
    }

    public void init() {
        this.state = 1;
        GOAL_Y = H - font.getH() * this.items.length;
        this.y = H;
        this.selected = 0;
        INCREASE_Y *= -1;
        this.done = false;
        for (int i = 0; i < this.available.length; ++i) {
            this.available[i] = true;
        }
    }

    public void exit() {
    }

    public void update() throws IOException {
        if (this.state != 0) {
            this.y += INCREASE_Y;
            if (this.state == 1 && this.y <= GOAL_Y) {
                this.state = 0;
            } else if (this.state == 2 && this.y >= GOAL_Y) {
                this.done = true;
            }
        }
    }

    public void render(Graphics g) {
        g.drawImage(this.imgBack, W - this.imgBack.getWidth(), this.y, 0);
        g.setColor(0xFFFF00);
        int index = 0;
        for (int i = 0; i < this.items.length; ++i) {
            if (i == this.selected) {
                g.fillRect(W - this.imgBack.getWidth(), this.y + index * font.getH(), this.imgBack.getWidth(), font.getH());
            }
            if (!this.available[i]) continue;
            font.print(g, W, this.y + index * font.getH(), this.items[i], (byte)2);
            ++index;
        }
    }

    public void up() {
        this.selected = (byte)(this.selected - 1);
        if (this.selected < 0) {
            this.selected = (byte)(this.items.length - 1);
        }
        while (!this.available[this.selected]) {
            this.selected = (byte)(this.selected - 1);
        }
    }

    public void down() {
        this.selected = (byte)(this.selected + 1);
        if (this.selected >= this.items.length) {
            this.selected = 0;
        }
        while (!this.available[this.selected]) {
            this.selected = (byte)(this.selected + 1);
        }
    }

    public byte getSelected() {
        return this.selected;
    }

    public void startEnding() {
        if (this.state == 2) {
            return;
        }
        this.state = (byte)2;
        INCREASE_Y *= -1;
        GOAL_Y = H;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean checkClick(int lx, int ly) {
        int index = 0;
        for (int i = 0; i < this.items.length; i = (int)((byte)(i + 1))) {
            if (!this.available[i]) continue;
            if (DropDownMenu.inBounds(lx, ly, W - this.imgBack.getWidth(), this.y + index * font.getH(), this.imgBack.getWidth(), font.getH())) {
                System.out.println(i);
                this.selected = (byte)i;
                return true;
            }
            ++index;
        }
        return false;
    }
}

