/*
 * Decompiled with CFR 0.152.
 */
package states.play;

import com.apr.game.Game;
import com.apr.game.animations.Animation;
import com.apr.game.animations.Point;
import javax.microedition.lcdui.Graphics;
import net.jscience.math.kvm.MathFP;

public final class MovingText
extends Animation {
    private Point start;
    private int xFP;
    private int yFP;
    private Point destination;
    private int dxFP;
    private int dyFP;
    private int curTime;
    private int maxTime;
    private String line1;
    private String line2;

    public MovingText(String line1, String line2, Point start, Point destination, int time) {
        this.line1 = line1;
        this.line2 = line2;
        this.start = start;
        this.destination = destination;
        this.maxTime = time + 2 * Game.frameRate;
        this.enter();
    }

    public void enter() {
        this.xFP = MathFP.toFP(this.start.x);
        this.yFP = MathFP.toFP(this.start.y);
        this.dxFP = MathFP.div(MathFP.mul(MathFP.toFP(this.destination.x - this.start.x), MathFP.toFP(Game.frameRate)), MathFP.toFP(this.maxTime));
        this.dyFP = MathFP.div(MathFP.mul(MathFP.toFP(this.destination.y - this.start.y), MathFP.toFP(Game.frameRate)), MathFP.toFP(this.maxTime));
        this.done = false;
        this.curTime = 0;
    }

    public void update(int time) {
        this.curTime += time;
        if (this.curTime >= this.maxTime) {
            this.done = true;
            return;
        }
        this.xFP = MathFP.add(this.xFP, this.dxFP);
        this.yFP = MathFP.add(this.yFP, this.dyFP);
    }

    public void render(Graphics g) {
        fontSmall.print(g, MathFP.toInt(this.xFP), MathFP.toInt(this.yFP), this.line1, (byte)0);
        font.print(g, MathFP.toInt(this.xFP), MathFP.toInt(this.yFP) + fontSmall.getH(), this.line2, (byte)0);
    }

    public void setText(String line2) {
        this.line2 = line2;
    }
}

