/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.animations;

import com.apr.game.Game;
import com.apr.game.animations.Animation;
import com.apr.game.animations.Point;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.jscience.math.kvm.MathFP;

public final class Moving
extends Animation {
    private int xFP;
    private int yFP;
    private Point destination;
    private Point start;
    private int dxFP;
    private int dyFP;
    private int curTime;
    private int maxTime;
    private Image image;

    public Moving(Image image, Point start, Point destination, int time) {
        this.image = image;
        this.start = start;
        this.destination = destination;
        this.maxTime = time + 2 * Game.frameRate;
        this.enter();
    }

    public void enter() {
        this.xFP = MathFP.toFP(this.start.x);
        this.yFP = MathFP.toFP(this.start.y);
        this.dxFP = MathFP.div(MathFP.mul(MathFP.toFP(this.destination.x - this.start.x), MathFP.toFP(Game.frameRate)), MathFP.toFP(this.maxTime));
        this.dyFP = MathFP.div(MathFP.mul(MathFP.toFP(this.destination.y - this.start.y), MathFP.toFP(Game.frameRate)), MathFP.toFP(this.maxTime));
        this.done = false;
        this.curTime = 0;
    }

    public void update(int time) {
        this.curTime += time;
        if (this.curTime >= this.maxTime) {
            this.done = true;
            return;
        }
        this.xFP = MathFP.add(this.xFP, this.dxFP);
        this.yFP = MathFP.add(this.yFP, this.dyFP);
    }

    public void render(Graphics g) {
        g.drawImage(this.image, MathFP.toInt(this.xFP), MathFP.toInt(this.yFP), 0);
    }
}

