/*
 * Decompiled with CFR 0.152.
 */
package states.play;

import com.apr.game.Utils;
import com.apr.game.displayable.ProgressBar;
import com.apr.game.states.State;
import game.Locale;
import game.TTTGame;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;
import logic.Board;
import logic.GameState;
import logic.TTTRules;

public class StateComputer
extends State
implements Runnable {
    private static final int ONE_TO_FINISH = 10;
    private static final int TWO_TO_FINISH = 5;
    private static final int THREE_TO_FINISH = 2;
    private static final int MAX_STATES = 10000;
    private byte nextState;
    private byte piece;
    private static final int MAX_TIME = 5000;
    private int maxDepth;
    private int curTime;
    private Thread thread;
    private ProgressBar bar;
    private boolean showBar;
    private int board_size;
    private int win_size;
    private String strThinking;

    public StateComputer(byte id, byte nextState, byte piece) {
        super(id);
        this.nextState = nextState;
        this.piece = piece;
        this.bar = new ProgressBar(State.W - 50, 5, 50, 10, 5000 / TTTGame.frameRate);
        this.board_size = GameState.BOARD_TYPE;
        if (GameState.FINISH_CRITERIA == 0) {
            this.win_size = this.board_size;
        } else if (this.board_size == 4) {
            this.win_size = 4;
        } else if (this.board_size == 5) {
            this.win_size = 4;
        }
        this.strThinking = Locale.getString("Game.Thinking");
    }

    public void enter() throws IOException, MediaException {
        this.done = false;
        this.showBar = false;
        this.bar.enter();
        this.curTime = 0;
        if (GameState.COMPUTER_LEVEL == 0 || StateComputer.nextInt(10) == 0) {
            Vector moves = TTTRules.GET_MOVES(GameState.board);
            Byte move = (Byte)moves.elementAt(Utils.nextInt(moves.size()));
            GameState.currentMove = move;
            moves.removeAllElements();
            this.done = true;
            return;
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void exit() throws MediaException {
    }

    public byte nextState() {
        return this.nextState;
    }

    public void update(int time) {
        this.curTime += time;
        this.bar.increase();
    }

    public void render(Graphics g) {
        GameState.render(g);
        font.print(g, HALF_W, HALF_H, this.strThinking, (byte)0);
        if (this.showBar) {
            this.bar.render(g);
        }
    }

    public void run() {
        int remainingPieces = GameState.GET_EMPTY_POSITIONS();
        this.maxDepth = 1;
        int totalPieces = 1;
        while (remainingPieces > 0 && totalPieces < 10000) {
            totalPieces *= remainingPieces;
            ++this.maxDepth;
            --remainingPieces;
        }
        if (GameState.COMPUTER_LEVEL == 1) {
            this.maxDepth /= 2;
        }
        Byte bestMove = null;
        int maxValue = Integer.MIN_VALUE;
        Vector sucessors = TTTRules.GET_MOVES(GameState.board);
        if (sucessors.size() == 1) {
            this.showBar = false;
            bestMove = (Byte)sucessors.elementAt(0);
        } else {
            for (int i = 0; i < sucessors.size(); ++i) {
                Byte move = (Byte)sucessors.elementAt(i);
                Board nextBoard = new Board(GameState.board);
                nextBoard.makeMove(move.byteValue());
                int value = this.min_move(nextBoard, 1, maxValue, Integer.MAX_VALUE);
                if (value <= maxValue) continue;
                maxValue = value;
                bestMove = move;
            }
        }
        sucessors.removeAllElements();
        sucessors = null;
        GameState.currentMove = bestMove;
        this.done = true;
    }

    private int min_move(Board board, int depth, int alpha, int beta) {
        if (this.cutOffTest(board, depth)) {
            return this.eval(board);
        }
        Vector sucessors = TTTRules.GET_MOVES(board);
        if (sucessors.isEmpty()) {
            return this.eval(board);
        }
        for (int i = 0; i < sucessors.size(); ++i) {
            Byte move = (Byte)sucessors.elementAt(i);
            Board nextBoard = new Board(board);
            nextBoard.makeMove(move.byteValue());
            int value = this.max_move(nextBoard, depth + 1, alpha, beta);
            if (value < beta) {
                beta = value;
            }
            if (beta >= alpha) continue;
            return alpha;
        }
        sucessors.removeAllElements();
        return beta;
    }

    private int max_move(Board board, int depth, int alpha, int beta) {
        if (this.cutOffTest(board, depth)) {
            return this.eval(board);
        }
        Vector sucessors = TTTRules.GET_MOVES(board);
        if (sucessors.isEmpty()) {
            return this.eval(board);
        }
        for (int i = 0; i < sucessors.size(); ++i) {
            Byte move = (Byte)sucessors.elementAt(i);
            Board nextBoard = new Board(board);
            nextBoard.makeMove(move.byteValue());
            int value = this.min_move(nextBoard, depth + 1, alpha, beta);
            if (value > alpha) {
                alpha = value;
            }
            if (alpha <= beta) continue;
            return beta;
        }
        sucessors.removeAllElements();
        return alpha;
    }

    private boolean cutOffTest(Board board, int depth) {
        return TTTRules.IS_FINISH(board, this.board_size, this.win_size) != 0 || depth > this.maxDepth || Runtime.getRuntime().freeMemory() < 10000L || this.curTime >= 5000;
    }

    public int eval(Board board) {
        int score = 0;
        int sumPieces = 0;
        int sumOponent = 0;
        int sumEmpty = 0;
        byte oponent = this.piece == 1 ? (byte)2 : 1;
        byte[][] options = TTTRules.GET_COMBINATIONS(this.board_size, this.win_size);
        for (int i = 0; i < options.length; ++i) {
            sumPieces = 0;
            sumOponent = 0;
            sumEmpty = 0;
            for (int j = 0; j < options[i].length; ++j) {
                if (board.get(options[i][j]) == this.piece) {
                    sumPieces = (byte)(sumPieces + 1);
                    continue;
                }
                if (board.get(options[i][j]) == oponent) {
                    sumOponent = (byte)(sumOponent + 1);
                    continue;
                }
                sumEmpty = (byte)(sumEmpty + 1);
            }
            if (sumPieces == this.win_size) {
                return 100;
            }
            if (sumOponent == this.win_size) {
                return -100;
            }
            if (sumPieces + 1 == this.win_size && sumOponent == 0) {
                score += 10;
            }
            if (sumOponent + 1 == this.win_size && sumPieces == 0) {
                score -= 10;
            }
            if (sumPieces + 2 == this.win_size && sumOponent == 0) {
                score += 5;
            }
            if (sumOponent + 2 == this.win_size && sumPieces == 0) {
                score -= 5;
            }
            if (sumPieces + 3 == this.win_size && sumOponent == 0) {
                score += 2;
            }
            if (sumOponent + 1 != this.win_size || sumPieces != 0) continue;
            score -= 2;
        }
        return score;
    }
}

