/*
 * Decompiled with CFR 0.152.
 */
package states.play;

import com.apr.game.states.State;
import game.Locale;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;
import logic.GameState;

public class StateInitGame
extends State {
    private byte nextState;
    private static final int MAX_TIME = 1000;
    private int curTime;
    private byte turnX;
    private byte turnO;
    private String strStartGame;

    public StateInitGame(byte id, byte turnX, byte turnO) {
        super(id);
        this.turnX = turnX;
        this.turnO = turnO;
        this.strStartGame = Locale.getString("Game.StartGame");
    }

    public void enter() throws IOException, MediaException {
        this.done = false;
        GameState.startGame();
        this.nextState = GameState.isTurnX() ? this.turnX : this.turnO;
        this.curTime = 0;
    }

    public void update(int time) {
        this.curTime += time;
        if (this.curTime > 1000) {
            this.done = true;
        }
    }

    public void exit() throws MediaException {
    }

    public byte nextState() {
        return this.nextState;
    }

    public void render(Graphics g) {
        GameState.render(g);
        font.print(g, HALF_W, HALF_H, this.strStartGame, (byte)0);
    }
}

