/*
 * Decompiled with CFR 0.152.
 */
package states.play;

import com.apr.game.states.State;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;
import logic.GameState;

public class StateMove
extends State {
    private static final int MAX_TIME = 50;
    private byte nextState;
    private int curTime;
    private byte turnX;
    private byte turnO;
    private byte endGame;
    private byte index;
    private int x;
    private int y;
    private boolean cw;

    public StateMove(byte id, byte turnX, byte turnO, byte endGame) {
        super(id);
        this.turnX = turnX;
        this.turnO = turnO;
        this.endGame = endGame;
    }

    public void enter() throws IOException, MediaException {
        this.curTime = 0;
        this.done = false;
        if (GameState.isTurnX()) {
            this.cw = !this.cw;
        }
        this.index = 0;
        this.x = GameState.getPoint((int)GameState.currentMove).x;
        this.y = GameState.getPoint((int)GameState.currentMove).y;
        StateMove.vibrate(game.getMidlet());
    }

    public void update(int time) {
        this.curTime += time;
        if (this.curTime > 50) {
            this.index = (byte)(this.index + 1);
            this.curTime = 0;
            if (this.index >= GameState.NUM_ANIMS) {
                GameState.makeMove();
                byte result = GameState.isFinish();
                if (result == 0) {
                    this.nextState = GameState.isTurnX() ? this.turnX : this.turnO;
                } else {
                    GameState.WHO_WON = result;
                    this.nextState = this.endGame;
                }
                this.done = true;
            }
        }
    }

    public void exit() throws MediaException {
    }

    public byte nextState() {
        return this.nextState;
    }

    public void render(Graphics g) {
        GameState.render(g);
        if (this.done) {
            return;
        }
        if (GameState.isTurnX()) {
            if (this.cw) {
                g.drawImage(GameState.imgXsCW[this.index], this.x, this.y, 0);
            } else {
                g.drawImage(GameState.imgXsCC[this.index], this.x, this.y, 0);
            }
        } else if (this.cw) {
            g.drawImage(GameState.imgOsCW[this.index], this.x, this.y, 0);
        } else {
            g.drawImage(GameState.imgOsCC[this.index], this.x, this.y, 0);
        }
    }
}

