/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Button;
import game.DisplayableCanvas;
import game.DrawString;
import game.SystemFont;
import game.TipsygunMidlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public final class MainMenu {
    private RecordStore soundSettings;
    DisplayableCanvas dc;
    int MENU_MODE;
    int WIDTH;
    int HEIGHT;
    Image imgLogo;
    Image imgSplash;
    Image imgAboutLogo;
    Image imgOptionHeading;
    Image imgHelpHeading;
    Image imgaboutHeading;
    Image imgName;
    Image imgMenuBG1;
    Image imgGlass;
    Image imgHelpText;
    Font font = Font.getFont((int)0, (int)1, (int)16);
    boolean isContinue;
    boolean onoffs = true;
    boolean onoffv = true;
    Button butContinue;
    Button butNewGame;
    Button butOption;
    Button butHelp;
    Button butAbout;
    Button butExit;
    Button butSoundon;
    Button butSoundoff;
    Button butVibrateon;
    Button butVibrateoff;
    Button buttonHelpData;
    Button buttonHome;
    int selectIndex = 1;
    byte optionIndex = 0;

    public MainMenu(DisplayableCanvas displayableCanvas, DrawString drawString) {
        this.dc = displayableCanvas;
        this.WIDTH = displayableCanvas.WIDTH;
        this.HEIGHT = displayableCanvas.HEIGHT;
    }

    public final void resetSplash() {
        try {
            this.imgLogo = Image.createImage((String)"/res/menu/logo.png");
            this.imgSplash = Image.createImage((String)"/res/menu/splash.jpg");
            this.imgAboutLogo = Image.createImage((String)"/res/menu/aboutLogo.png");
        }
        catch (Exception exception) {
            Exception io = exception;
            exception.printStackTrace();
        }
        this.readSettings();
        this.MENU_MODE = 0;
    }

    public final void storeSettings() {
        try {
            this.soundSettings = RecordStore.openRecordStore((String)"GameSettings", (boolean)true);
            Object object = new ByteArrayOutputStream(60);
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
            dataOutputStream.writeBoolean(this.onoffs);
            dataOutputStream.writeBoolean(this.onoffv);
            dataOutputStream.flush();
            dataOutputStream.close();
            object = ((ByteArrayOutputStream)object).toByteArray();
            dataOutputStream.close();
            if (this.soundSettings.getNumRecords() > 0) {
                this.soundSettings.setRecord(1, (byte[])object, 0, ((Object)object).length);
            } else {
                this.soundSettings.addRecord((byte[])object, 0, ((Object)object).length);
            }
            this.soundSettings.closeRecordStore();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    public final void readSettings() {
        try {
            this.soundSettings = RecordStore.openRecordStore((String)"GameSettings", (boolean)true);
            if (this.soundSettings.getNumRecords() > 0) {
                Object object = this.soundSettings.getRecord(1);
                object = new DataInputStream(new ByteArrayInputStream((byte[])object));
                this.onoffs = ((DataInputStream)object).readBoolean();
                this.onoffv = ((DataInputStream)object).readBoolean();
                ((FilterInputStream)object).close();
            } else {
                Object object = new ByteArrayOutputStream(60);
                DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
                this.onoffs = true;
                this.onoffv = true;
                dataOutputStream.writeBoolean(this.onoffs);
                dataOutputStream.writeBoolean(this.onoffv);
                dataOutputStream.flush();
                dataOutputStream.close();
                object = ((ByteArrayOutputStream)object).toByteArray();
                dataOutputStream.close();
                this.soundSettings.addRecord((byte[])object, 0, ((Object)object).length);
            }
            this.soundSettings.closeRecordStore();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    public final void resetMainMenu() {
        if (this.imgSplash == null) {
            try {
                this.imgSplash = Image.createImage((String)"/res/menu/menuBg.jpg");
                this.imgMenuBG1 = Image.createImage((String)"/res/menu/menuBg1.jpg");
                this.imgGlass = Image.createImage((String)"/res/menu/beerglass.png");
            }
            catch (Exception exception) {}
        }
        if (this.butContinue == null) {
            this.butContinue = new Button(0, 0, "/res/menu/continue0.png", "/res/menu/continue1.png");
            this.butNewGame = new Button(0, 0, "/res/menu/play0.png", "/res/menu/play1.png");
            this.butOption = new Button(0, 0, "/res/menu/option0.png", "/res/menu/option1.png");
            this.butHelp = new Button(0, 0, "/res/menu/help0.png", "/res/menu/help1.png");
            this.butAbout = new Button(0, 0, "/res/menu/about0.png", "/res/menu/about1.png");
            this.butExit = new Button(0, 0, "/res/menu/exit0.png", "/res/menu/exit1.png");
            this.butSoundon = new Button(this.WIDTH - 160 + 28, 125, "/res/menu/soundon0.png", "/res/menu/soundon1.png");
            this.butSoundoff = new Button(this.WIDTH - 160 + 28, 125, "/res/menu/soundoff0.png", "/res/menu/soundoff1.png");
            this.butVibrateon = new Button(this.WIDTH - 160 + 8, this.butSoundon.y + 30, "/res/menu/vibrateon0.png", "/res/menu/vibrateon1.png");
            this.butVibrateoff = new Button(this.WIDTH - 160 + 8, this.butSoundon.y + 30, "/res/menu/vibrateoff0.png", "/res/menu/vibrateoff1.png");
            this.buttonHome = new Button(this.WIDTH - 50, this.HEIGHT - 15, "/res/menu/homeIcon0.png", "/res/menu/homeIcon1.png");
        }
        if (this.isContinue) {
            this.butContinue.setXY(this.WIDTH - 200 + (200 - this.butContinue.width >> 1), 55);
            this.butNewGame.setXY(this.WIDTH - 200 + (200 - this.butNewGame.width >> 1), this.butContinue.y + 32);
            this.butOption.setXY(this.WIDTH - 200 + (200 - this.butOption.width >> 1), this.butNewGame.y + 32);
            this.butHelp.setXY(this.WIDTH - 200 + (200 - this.butHelp.width >> 1), this.butOption.y + 32);
            this.butAbout.setXY(this.WIDTH - 200 + (200 - this.butAbout.width >> 1), this.butHelp.y + 32);
            this.butExit.setXY(this.WIDTH - 200 + (200 - this.butExit.width >> 1), this.butAbout.y + 32);
        } else {
            this.butNewGame.setXY(this.WIDTH - 200 + (200 - this.butNewGame.width >> 1), 56);
            this.butOption.setXY(this.WIDTH - 200 + (200 - this.butOption.width >> 1), this.butNewGame.y + 38);
            this.butHelp.setXY(this.WIDTH - 200 + (200 - this.butHelp.width >> 1), this.butOption.y + 38);
            this.butAbout.setXY(this.WIDTH - 200 + (200 - this.butAbout.width >> 1), this.butHelp.y + 38);
            this.butExit.setXY(this.WIDTH - 200 + (200 - this.butExit.width >> 1), this.butAbout.y + 38);
        }
        this.MENU_MODE = 1;
    }

    private void clearMenuImages() {
        System.out.println("cleared menu images");
        this.imgSplash = null;
        this.imgMenuBG1 = null;
        this.imgGlass = null;
        this.imgOptionHeading = null;
        this.imgHelpHeading = null;
        this.imgaboutHeading = null;
        this.imgName = null;
        this.imgMenuBG1 = null;
        this.butContinue = null;
        this.butNewGame = null;
        this.butOption = null;
        this.butHelp = null;
        this.butAbout = null;
        this.butExit = null;
        this.butSoundon = null;
        this.butSoundoff = null;
        this.butVibrateon = null;
        this.butVibrateoff = null;
        this.imgHelpText = null;
        System.gc();
    }

    public final void resetMode(int n) {
        switch (n) {
            case 0: {
                this.resetSplash();
                break;
            }
            case 1: {
                if (this.imgSplash == null) {
                    try {
                        this.imgSplash = Image.createImage((String)"/res/menu/menuBg.jpg");
                        this.imgMenuBG1 = Image.createImage((String)"/res/menu/menuBg1.jpg");
                        this.imgGlass = Image.createImage((String)"/res/menu/beerglass.png");
                        this.imgOptionHeading = Image.createImage((String)"/res/menu/option0.png");
                        this.imgHelpHeading = Image.createImage((String)"/res/menu/helpHeading.png");
                        this.imgaboutHeading = Image.createImage((String)"/res/menu/aboutHeading.png");
                        this.imgName = Image.createImage((String)"/res/menu/about_name.png");
                    }
                    catch (Exception exception) {
                        Exception exception2 = exception;
                        exception.printStackTrace();
                    }
                }
                this.resetMainMenu();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                Object object = this;
                try {
                    if (((MainMenu)object).imgHelpText == null) {
                        ((MainMenu)object).imgHelpText = Image.createImage((String)"/res/menu/helpText.png");
                        ((MainMenu)object).buttonHelpData = new Button(228, 70, 138, 170, -1, -1);
                        ((MainMenu)object).buttonHelpData.nameX = 228;
                        ((MainMenu)object).buttonHelpData.nameY = 70;
                        ((MainMenu)object).buttonHelpData.name = "empty";
                        SystemFont.findLines(((MainMenu)object).buttonHelpData.name, SystemFont.font1, ((MainMenu)object).buttonHelpData.width);
                    }
                    ((MainMenu)object).buttonHelpData.nameY = ((MainMenu)object).buttonHelpData.y;
                    break;
                }
                catch (Exception exception) {
                    object = exception;
                    exception.printStackTrace();
                }
            }
        }
        this.MENU_MODE = n;
        this.dc.resetAdSetXY();
    }

    void selection() {
        switch (this.selectIndex) {
            case 0: {
                this.clearMenuImages();
                this.dc.loadSprites();
                this.dc.continueGame();
                int n = this.dc.LASTPLAY_MODE;
                this.dc.getClass();
                if (n == 3) {
                    this.dc.getClass();
                    this.dc.resetMode(5);
                }
                this.dc.getClass();
                this.dc.GAME_MODE = 5;
                break;
            }
            case 1: {
                this.dc.level = 1;
                this.dc.score = 0;
                this.dc.lastScore = 0;
                for (int i = 0; i < this.dc.randLevel.length; ++i) {
                    this.dc.randLevel[i] = 0;
                }
                this.clearMenuImages();
                this.dc.continueGame();
                this.dc.initGame();
                this.dc.loadSprites();
                this.dc.lastScore = 0;
                this.isContinue = true;
                break;
            }
            case 2: {
                this.resetMode(2);
                break;
            }
            case 3: {
                this.resetMode(3);
                break;
            }
            case 4: {
                this.resetMode(4);
                break;
            }
            case 5: {
                this.dc.stopSound(0);
                this.dc.stopSound(1);
                this.dc.stopSound(2);
                this.storeSettings();
                TipsygunMidlet tipsygunMidlet = this.dc.midlet;
                tipsygunMidlet.destroyApp(true);
                tipsygunMidlet.notifyDestroyed();
                break;
            }
            case 6: {
                this.dc.onClickBannerAd();
            }
        }
        this.dc.resetAdSetXY();
    }

    public final void run() {
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter <= 60) break;
                this.imgSplash = null;
                this.imgMenuBG1 = null;
                this.imgGlass = null;
                this.resetMode(1);
                this.dc.refreshTheBannerAd();
            }
        }
    }
}

