/*
 * Decompiled with CFR 0.152.
 */
package se.krka.kahlua.luaj.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.luaj.kahluafork.compiler.LexState;
import se.krka.kahlua.stdlib.BaseLib;
import se.krka.kahlua.vm.JavaFunction;
import se.krka.kahlua.vm.LuaCallFrame;
import se.krka.kahlua.vm.LuaClosure;
import se.krka.kahlua.vm.LuaState;
import se.krka.kahlua.vm.LuaTable;

public class LuaCompiler
implements JavaFunction {
    private final int index;
    private static final int LOADSTRING = 0;
    private static final int LOADSTREAM = 1;
    private static final String[] names = new String[]{"loadstring", "loadstream"};
    private static final LuaCompiler[] functions = new LuaCompiler[names.length];

    private LuaCompiler(int index) {
        this.index = index;
    }

    public static void register(LuaState state) {
        state.lock();
        LuaTable env = state.getEnvironment();
        for (int i2 = 0; i2 < names.length; ++i2) {
            env.rawset(names[i2], (Object)functions[i2]);
        }
        state.unlock();
    }

    public int call(LuaCallFrame callFrame, int nArguments) {
        switch (this.index) {
            case 0: {
                return this.loadstring(callFrame, nArguments);
            }
            case 1: {
                return this.loadstream(callFrame, nArguments);
            }
        }
        return 0;
    }

    private int loadstream(LuaCallFrame callFrame, int nArguments) {
        try {
            BaseLib.luaAssert(nArguments >= 2, "not enough arguments");
            InputStream is = (InputStream)callFrame.get(0);
            BaseLib.luaAssert(is != null, "No inputstream given");
            String name = (String)callFrame.get(1);
            return callFrame.push(LuaCompiler.loadis(is, name, callFrame.getEnvironment()));
        }
        catch (RuntimeException e2) {
            return callFrame.push(null, e2.getMessage());
        }
        catch (IOException e3) {
            return callFrame.push(null, e3.getMessage());
        }
    }

    private int loadstring(LuaCallFrame callFrame, int nArguments) {
        try {
            BaseLib.luaAssert(nArguments >= 1, "not enough arguments");
            String source = (String)callFrame.get(0);
            BaseLib.luaAssert(source != null, "No source given");
            String name = (String)callFrame.get(1);
            if (name == null) {
                name = "<stdin>";
            }
            return callFrame.push(LuaCompiler.loadstring(source, name, callFrame.getEnvironment()));
        }
        catch (RuntimeException e2) {
            return callFrame.push(null, e2.getMessage());
        }
        catch (IOException e3) {
            return callFrame.push(null, e3.getMessage());
        }
    }

    public static LuaClosure loadis(InputStream inputStream, String name, LuaTable environment) throws IOException {
        BaseLib.luaAssert(name != null, "no name given the compilation unit");
        return new LuaClosure(LexState.compile(inputStream.read(), inputStream, name), environment);
    }

    public static LuaClosure loadstring(String source, String name, LuaTable environment) throws IOException {
        return LuaCompiler.loadis(new ByteArrayInputStream(source.getBytes("UTF-8")), name, environment);
    }

    static {
        for (int i2 = 0; i2 < names.length; ++i2) {
            LuaCompiler.functions[i2] = new LuaCompiler(i2);
        }
    }
}

