/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.util;

import com.slg.j2me.lib.sys.Application;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MultiLingual {
    public static int lang = -1;
    public static int lines = 0;
    public static int languages = 0;
    public static String[] language;
    public static String[] languageLongName;
    public static byte[][] textdata;
    public static String filename;

    public static final String getShortLanguageName() {
        return language[lang];
    }

    public static void load(String fn) {
        DataInputStream datain;
        filename = fn;
        InputStream inputstream = Application.instance.getClass().getResourceAsStream(fn);
        if (inputstream == null) {
            System.out.println("Assertion Failure: inputstream != null\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\util/MultiLingual.java[56]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((datain = new DataInputStream(inputstream)) == null) {
            System.out.println("Assertion Failure: datain != null\nD:\\FLWBF2_CODE\\FLWBF2_E61\\FLWBF2_Nokia_E61_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\util/MultiLingual.java[60]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            languages = datain.readShort();
            lines = datain.readShort();
            if (language == null) {
                language = new String[languages];
                languageLongName = new String[languages];
                textdata = new byte[lines][];
            }
            System.out.println("MultiLingual - " + languages + " language, " + lines + " lines.");
            for (int l = 0; l < language.length; ++l) {
                MultiLingual.language[l] = datain.readUTF();
                MultiLingual.languageLongName[l] = datain.readUTF();
                System.out.println("MultiLingual - " + l + ": " + language[l] + " - " + languageLongName[l]);
            }
            if (lang == -1) {
                MultiLingual.autodetectLanguage();
            }
            int total_bytes = 0;
            int total_chars = 0;
            int total_lines = 0;
            for (int l = 0; l <= lang; ++l) {
                for (int i = 0; i < lines; ++i) {
                    String line = datain.readUTF();
                    if (l != lang) continue;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(baos);
                    dos.writeUTF(line);
                    MultiLingual.textdata[i] = baos.toByteArray();
                    total_bytes += textdata[i].length;
                    total_chars += line.length();
                    ++total_lines;
                }
            }
            System.out.println("total_chars = " + total_chars);
            System.out.println("total_lines = " + total_lines);
            System.out.println("total_bytes = " + total_bytes);
            datain.close();
            datain = null;
            inputstream.close();
            inputstream = null;
        }
        catch (IOException err) {
            System.out.println("\n\n*******************************************************\nError reading " + fn + "\n*******************************************************\n\n");
        }
    }

    public static void autodetectLanguage() {
        String locale = System.getProperty("microedition.locale");
        System.out.println("MultiLingual.load - detected locale " + locale);
        for (int l = 0; l < languages; ++l) {
            if (!locale.startsWith(language[l])) continue;
            System.out.println("Matched Language " + language[l] + " - " + languageLongName[l]);
            lang = l;
            break;
        }
        if (lang == -1) {
            System.out.println("Failed to match any language. Defaulting to en");
            lang = 0;
        }
    }

    public static void setLanguage(int l) {
        lang = l;
        MultiLingual.load(filename);
    }

    public static void loadLocale(DataInputStream inputStream) throws IOException {
        System.out.println("MultiLingual.loadLocale");
        try {
            lang = inputStream.readShort();
            System.out.println("MultiLingual.loadLocale = " + lang);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveLocale(DataOutputStream dataStream) {
        System.out.println("MultiLingual.saveLocale");
        try {
            dataStream.writeShort(lang);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final String get(int index) {
        if (index >= 0 && index < lines) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(textdata[index]);
                DataInputStream dis = new DataInputStream(bais);
                return dis.readUTF();
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        return "XX LANGUAGE ERROR XX";
    }
}

