/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.rflib.audio;

import dk.progressivemedia.rflib.debug.PMDebug;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMSystem;
import dk.progressivemedia.rflib.system.PMTimer;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class PMAudio {
    public static boolean isEnabled = true;
    private static int numPreloadedMIDIs;
    private static int numPreloadedWAVEs;
    public static final int MAX_PRELOADED_MIDIS = 1;
    public static final int MAX_PRELOADED_WAVES = 1;
    public static final int MAX_PLAYS = 3;
    private static int numSounds;
    public static final int LOOP_INFINITE = -1;
    public static final int OTT = 0;
    public static final int MIDI = 1;
    public static final int SPMIDI = 2;
    public static final int MMF = 3;
    public static final int SMF = 4;
    public static final int SMAF = 5;
    public static final int WAV = 6;
    public static final int AMR = 7;
    public static final int MP3 = 8;
    private static int lastPlayed;
    private static long lastTimePlay;
    private static int[] loop;
    private static boolean[] setPlay;
    private static boolean[] setStop;
    private static boolean[] setVolume;
    private static int[] currVolume;
    private static int[] playerType;
    private static String[] fileName;
    private static int numCreatedPlayers;
    private static Player[] playerWAVE;
    private static Player[] playerMIDI;

    public static void initAudio(int n) {
        int n2 = 0;
        numSounds = n;
        setPlay = new boolean[n];
        setStop = new boolean[n];
        setVolume = new boolean[n];
        currVolume = new int[n];
        loop = new int[n];
        playerType = new int[n];
        lastPlayed = -1;
        playerWAVE = new Player[n];
        playerMIDI = new Player[n];
        numPreloadedMIDIs = 0;
        numPreloadedWAVEs = 0;
        fileName = new String[n];
        for (n2 = 0; n2 < numSounds; ++n2) {
            PMAudio.setPlay[n2] = false;
            PMAudio.setStop[n2] = false;
            PMAudio.setVolume[n2] = false;
            PMAudio.currVolume[n2] = 5;
            PMAudio.loop[n2] = 1;
            PMAudio.playerType[n2] = 999;
            PMAudio.playerWAVE[n2] = null;
            PMAudio.playerMIDI[n2] = null;
        }
    }

    public static void deInitAudio() {
        if (!isEnabled) {
            return;
        }
        int n = 0;
        for (n = 0; n < numSounds; ++n) {
            PMAudio.implementationStop(n, true);
        }
        for (n = 0; n < numSounds; ++n) {
            PMAudio.unload(n);
        }
    }

    public static int loadRegOnly(int n, String string, int n2, int n3) {
        if (PMAudio.isLoaded(n)) {
            return -2;
        }
        PMDebug.println("Load sound - id: " + n + " file: " + string);
        if (n >= numSounds) {
            return -3;
        }
        if (string == null) {
            return -1;
        }
        if (PMFile.loadScreen) {
            PMCanvas.drawLoading();
        }
        PMAudio.playerType[n] = n2;
        if (!string.equals(fileName[n])) {
            PMAudio.fileName[n] = string;
        }
        String string2 = "";
        return -4;
    }

    public static boolean play(int n) {
        return PMAudio.play(n, 1);
    }

    public static void setState(boolean bl) {
        isEnabled = bl;
    }

    public static boolean getState() {
        return isEnabled;
    }

    public static int load(int n, String string, int n2, int n3) {
        if (PMAudio.isLoaded(n)) {
            return -2;
        }
        if (n >= numSounds) {
            return -3;
        }
        if (string == null) {
            return -1;
        }
        if (PMFile.loadScreen) {
            PMCanvas.drawLoading();
        }
        PMAudio.playerType[n] = n2;
        if (!string.equals(fileName[n])) {
            PMAudio.fileName[n] = string;
        }
        String string2 = "";
        if (numCreatedPlayers >= 3) {
            // empty if block
        }
        Player player = null;
        try {
            InputStream inputStream = null;
            if (n2 == 6) {
                inputStream = string2.getClass().getResourceAsStream("/" + string + ".wav");
                PMAudio.playerWAVE[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/x-wav");
                player = playerWAVE[n];
            }
            if (n2 == 7) {
                inputStream = string2.getClass().getResourceAsStream("/" + string + ".amr");
                PMAudio.playerWAVE[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/amr");
                player = playerWAVE[n];
            }
            if (n2 == 8) {
                inputStream = string2.getClass().getResourceAsStream("/" + string + ".mp3");
                PMAudio.playerWAVE[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/mp3");
                player = playerWAVE[n];
            }
            if (n2 == 2) {
                inputStream = string2.getClass().getResourceAsStream("/" + string + ".mid");
                PMAudio.playerMIDI[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/sp-midi");
                player = playerMIDI[n];
            }
            if (n2 == 1) {
                inputStream = string2.getClass().getResourceAsStream("/" + string + ".mid");
                PMAudio.playerMIDI[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                player = playerMIDI[n];
            }
            player.realize();
            while (player.getState() != 200) {
                PMSystem.sleep(30L);
            }
            ++numCreatedPlayers;
            PMAudio.setVolume[n] = true;
            boolean bl = false;
            if (n2 == 1 || n2 == 2) {
                if (numPreloadedMIDIs < 1) {
                    player.prefetch();
                    ++numPreloadedMIDIs;
                    bl = true;
                }
            } else if (n2 == 6 || n2 == 7 || n2 == 8) {
                if (numPreloadedWAVEs < 1) {
                    player.prefetch();
                    ++numPreloadedWAVEs;
                    bl = true;
                }
            } else {
                return -2;
            }
            if (bl) {
                while (player.getState() != 300) {
                    PMSystem.sleep(30L);
                }
            }
        }
        catch (Exception exception) {
            PMDebug.println("PMAudio.load(): Exception! load failed.");
            if (player != null) {
                player.close();
                PMAudio.playerWAVE[n] = null;
                PMAudio.playerMIDI[n] = null;
                PMAudio.playerType[n] = 999;
                PMAudio.fileName[n] = "";
            }
            return -1;
        }
        return 0;
    }

    public static void unload(int n) {
        Player player = null;
        if (playerWAVE[n] != null) {
            player = playerWAVE[n];
            --numPreloadedWAVEs;
        }
        if (playerMIDI[n] != null) {
            player = playerMIDI[n];
            --numPreloadedMIDIs;
        }
        if (player != null) {
            player.close();
            while (player.getState() != 0) {
                PMSystem.sleep(30L);
            }
            PMAudio.playerMIDI[n] = null;
            PMAudio.playerWAVE[n] = null;
            --numCreatedPlayers;
        }
    }

    public static boolean isLoaded(int n) {
        if (playerWAVE[n] != null) {
            return true;
        }
        return playerMIDI[n] != null;
    }

    public static void restoreVolumeAll() {
        for (int i = 0; i < numSounds; ++i) {
            PMAudio.setVolume[i] = true;
        }
    }

    public static void setVolumeAll(int n) {
        for (int i = 0; i < numSounds; ++i) {
            PMAudio.setVolume(i, n);
        }
    }

    public static void setVolume(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        PMAudio.currVolume[n] = n2;
        PMAudio.setVolume[n] = true;
    }

    public static int getVolume(int n) {
        return currVolume[n];
    }

    public static boolean isPlaying(int n, int n2) {
        if (!isEnabled) {
            return false;
        }
        boolean bl = false;
        if ((n2 == playerType[n] || n2 == -1) && setPlay[n]) {
            return true;
        }
        if ((n2 == 6 || n2 == -1) && playerWAVE[n] != null) {
            boolean bl2 = bl = playerWAVE[n].getState() == 400;
        }
        if ((n2 == 1 || n2 == -1) && playerMIDI[n] != null) {
            bl = playerMIDI[n].getState() == 400;
        }
        return bl;
    }

    public static boolean play(int n, int n2) {
        if (!isEnabled) {
            return true;
        }
        long l = PMTimer.tick() - lastTimePlay;
        if (l < 100L) {
            return false;
        }
        lastTimePlay = PMTimer.tick();
        if (PMAudio.isPlaying(n, -1)) {
            return false;
        }
        int n3 = 0;
        if (playerType[n] == 6 || playerType[n] == 7 || playerType[n] == 8) {
            for (int i = 0; i < numSounds; ++i) {
                if (!PMAudio.isPlaying(i, playerType[i])) continue;
                ++n3;
            }
            if (n3 >= 3) {
                return false;
            }
        }
        PMAudio.setPlay[n] = true;
        PMAudio.loop[n] = n2;
        return true;
    }

    public static void stopAll() {
        PMDebug.println("PMAudio.stopAll()");
        if (!isEnabled) {
            return;
        }
        for (int i = 0; i < numSounds; ++i) {
            PMAudio.setStop[i] = true;
        }
    }

    public static void stop(int n) {
        PMDebug.println("PMAudio.stop()");
        if (!isEnabled) {
            return;
        }
        PMAudio.setStop[n] = true;
    }

    private static void implementationStop(int n, boolean bl) {
        block6: {
            Player player = null;
            player = playerMIDI[n] != null ? playerMIDI[n] : playerWAVE[n];
            try {
                if (player == null) break block6;
                try {
                    if (bl) {
                        if (player.getState() == 400) {
                            player.stop();
                            player.setMediaTime(0L);
                        }
                        break block6;
                    }
                    player.stop();
                    player.setMediaTime(0L);
                }
                catch (IllegalStateException illegalStateException) {}
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public static void update() {
        if (!isEnabled || setPlay == null) {
            return;
        }
        for (int i = 0; i < numSounds; ++i) {
            int n;
            if (setStop[i]) {
                PMAudio.setStop[i] = false;
                PMAudio.implementationStop(i, false);
                if (playerType[i] != 0) {
                    PMAudio.unload(i);
                }
                if (lastPlayed == i) {
                    lastPlayed = -1;
                }
            }
            if (setPlay[i]) {
                if (lastPlayed != -1) {
                    // empty if block
                }
                if (playerType[i] == 1) {
                    n = 0;
                    for (n = 0; n < numSounds; ++n) {
                        if (n == i) continue;
                        PMAudio.implementationStop(n, false);
                        PMAudio.setPlay[n] = false;
                    }
                    boolean bl = true;
                    while (bl) {
                        for (n = 0; n < numSounds; ++n) {
                            if (n != i && PMAudio.isPlaying(n, -1)) {
                                bl = true;
                                break;
                            }
                            bl = false;
                        }
                        PMSystem.sleep(5L);
                    }
                }
            }
            if (!PMAudio.isLoaded(i)) {
                if (playerType[i] == 0 || !setPlay[i]) continue;
                n = PMFile.loadScreen;
                PMFile.loadScreen = false;
                PMAudio.load(i, fileName[i], playerType[i], 0);
                PMFile.loadScreen = n;
            }
            Player player = null;
            player = playerMIDI[i] != null ? playerMIDI[i] : playerWAVE[i];
            if (setVolume[i]) {
                PMAudio.setVolume[i] = false;
                if (player != null) {
                    try {
                        VolumeControl volumeControl = (VolumeControl)player.getControl("VolumeControl");
                        if (volumeControl != null) {
                            volumeControl.setLevel(currVolume[i] * 10);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
            if (!setPlay[i]) continue;
            PMAudio.setPlay[i] = false;
            try {
                if (player == null || player.getState() == 400) continue;
                player.setLoopCount(loop[i]);
                player.start();
                lastPlayed = i;
                continue;
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }
}

