/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.rflib.debug;

import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMTimer;

public class PMProfiler {
    public static long[] ticks = new long[20];
    public static long[] tempTicks = new long[20];
    public static int[] count = new int[20];
    public static String[] names = new String[20];

    public static void reset() {
        ticks = new long[20];
        tempTicks = new long[20];
        count = new int[20];
        names = new String[20];
    }

    public static void start(String string) {
        for (int i = 0; i < names.length && names[i] != null && names[i] != string; ++i) {
        }
        PMProfiler.names[i] = string;
        PMProfiler.tempTicks[i] = PMTimer.tick();
    }

    public static void stop(String string) {
        int n;
        long l = PMTimer.tick();
        for (n = 0; n < names.length && names[n] != string; ++n) {
        }
        if (n >= names.length) {
            return;
        }
        int n2 = n;
        ticks[n2] = ticks[n2] + (l - tempTicks[n]);
        int n3 = n;
        count[n3] = count[n3] + 1;
    }

    public static void output() {
        PMCanvas.PMGraphics_setClip(0, 0, 320, 240);
        PMCanvas.PMGraphics_setColor(255, 255, 255);
        PMCanvas.PMGraphics_fillRect(0, 0, 320, 240);
        PMCanvas.PMGraphics_setColor(0, 0, 0);
        for (int i = 0; i < names.length && names[i] != null; ++i) {
            if (count[i] > 0) {
                PMCanvas.PMGraphics_drawString(names[i] + ": " + ticks[i] + " (" + ticks[i] / (long)count[i] + ")", 5, 5 + i * 17, 0);
                continue;
            }
            PMCanvas.PMGraphics_drawString(names[i] + ": " + ticks[i], 5, 5 + i * 17, 0);
        }
        PMCanvas.PMGraphics_flush();
    }
}

