/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.graphics.PMFont;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMStateManager;
import dk.progressivemedia.rflib.system.PMSystem;
import dk.progressivemedia.rflib.util.PMText;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.Promotion;
import dk.progressivemedia.skeleton.SaveGameHelper;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.SoundBufferPositional;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.TransitionEffect;
import dk.progressivemedia.skeleton.game.PauseMenu;
import dk.progressivemedia.skeleton.game.World;

public class StateGame {
    private static final int STATE_LOAD_LEVEL = 0;
    private static final int STATE_TRANSITION_IN = 1;
    private static final int STATE_RUNNING = 2;
    public static final int STATE_PAUSED = 3;
    private static final int STATE_TRANSITION_OUT = 4;
    public static final int INIT_PARAM_PROMOTION = 1;
    public static int mState;
    private static int mBackgroundColor;
    public static World mWorld;
    private static int mLoadingWidth;
    private static int mLoadingFrameCount;
    private static String mLoadingStr;
    private static String[] mLevelFilenames;
    private static final int EXIT_STATE_INVALID = -1;
    private static final int EXIT_STATE_WON = 0;
    private static final int EXIT_STATE_DEATH = 1;
    private static final int EXIT_STATE_RESTART = 2;
    private static final int EXIT_STATE_QUIT = 3;
    private static int mExitState;
    private static boolean mSuppresHUD;
    private static int mHUDAlpha;

    public static void init(int n) {
        PMFile.loadScreen = true;
        mLoadingStr = PMText.getText(131072);
        mLoadingWidth = PMFont.stringWidth(mLoadingStr, 0);
        mLoadingFrameCount = 3;
        PauseMenu.init();
        SoundBuffer.init();
        SoundBufferPositional.init();
        mExitState = -1;
        switch (Defines.mWorldLookup[GameState.mLevel]) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        mSuppresHUD = true;
        mHUDAlpha = 0;
        Timer.initTimer();
        Dialog.init(0, 0);
        Promotion.init();
        mState = 0;
        PMFile.loadScreen = false;
        Main.counter = 0;
    }

    public static void deinit() {
        mWorld = null;
        Dialog.deinit();
        Promotion.deinit();
        PMAudio.deInitAudio();
    }

    public static void update() {
        block30: {
            Timer.updateTimer();
            Promotion.update();
            Dialog.update();
            block0 : switch (mState) {
                case 0: {
                    PMCanvas.PMGraphics_setColor(0);
                    PMCanvas.PMGraphics_fillRect(0, 0, 320, 240);
                    if (mLoadingFrameCount > 0) {
                        PMCanvas.PMGraphics_drawString(160 - (mLoadingWidth >> 1), 111, mLoadingStr, 0);
                        --mLoadingFrameCount;
                        break;
                    }
                    if (GameState.mLevel != GameState.mLastPlayedLevel) {
                        GameState.resetState();
                    } else {
                        GameState.restoreStoredState();
                    }
                    if (GameState.mLastPlayedLevel >= 0 && Defines.mWorldLookup[GameState.mLevel] != Defines.mWorldLookup[GameState.mLastPlayedLevel]) {
                        PMImageManager.unloadAll();
                    }
                    GameState.mAllGoldCoinsCollected = false;
                    GameState.mAllChestsOpened = false;
                    switch (Defines.mWorldLookup[GameState.mLevel]) {
                        case 0: {
                            mBackgroundColor = 1480573;
                            break;
                        }
                        case 1: {
                            mBackgroundColor = 8516351;
                            break;
                        }
                        case 2: {
                            mBackgroundColor = 2271430;
                            break;
                        }
                        case 3: {
                            mBackgroundColor = 4840428;
                            break;
                        }
                        case 4: {
                            mBackgroundColor = 4409928;
                        }
                    }
                    mWorld = new World(mLevelFilenames[GameState.mLevel]);
                    mWorld.update();
                    GameState.mLastPlayedLevel = GameState.mLevel;
                    TransitionEffect.init(false);
                    mState = 1;
                    break;
                }
                case 1: {
                    PMCanvas.PMGraphics_setColor(mBackgroundColor);
                    PMCanvas.PMGraphics_fillRect(0, 0, 320, 240);
                    mWorld.draw(mHUDAlpha);
                    TransitionEffect.draw();
                    if (!TransitionEffect.update()) break;
                    mWorld.eventStarted();
                    mState = 2;
                    mSuppresHUD = false;
                    break;
                }
                case 2: {
                    PMCanvas.PMGraphics_setColor(mBackgroundColor);
                    PMCanvas.PMGraphics_fillRect(0, 0, 320, 240);
                    mWorld.update();
                    mWorld.draw(mHUDAlpha);
                    if (Dialog.isActive()) {
                        Dialog.draw();
                        break;
                    }
                    if (!InputProxy.isPressedCancel() && !InputProxy.isPressedBack()) break;
                    StateGame.startMenu(true);
                    break;
                }
                case 3: {
                    PMCanvas.PMGraphics_setColor(mBackgroundColor);
                    PMCanvas.PMGraphics_fillRect(0, 0, 320, 240);
                    mWorld.draw(mHUDAlpha);
                    if (InputProxy.isPressedCancel() && !Dialog.isActive()) {
                        PauseMenu.closeMenu();
                    }
                    if (PauseMenu.update()) {
                        mWorld.eventUnpaused();
                        mState = 2;
                        mSuppresHUD = false;
                        break;
                    }
                    PauseMenu.draw();
                    break;
                }
                case 4: {
                    PMCanvas.PMGraphics_setColor(mBackgroundColor);
                    PMCanvas.PMGraphics_fillRect(0, 0, 320, 240);
                    mWorld.draw(mHUDAlpha);
                    InputProxy.drawTouchInput(true);
                    TransitionEffect.draw();
                    if (!TransitionEffect.update()) break;
                    switch (mExitState) {
                        case 0: {
                            SaveGameHelper.saveSlot();
                            GameState.updateCollectionState();
                            if (GameState.mPlayCutscene != 0) {
                                PMStateManager.set(4, 0);
                                break block0;
                            }
                            int n = -1;
                            n = GameState.mAllCollectedInGame ? 6 : (GameState.mAllGoldCoinsCollected && GameState.mAllChestsOpened ? 3 : 4);
                            boolean bl = false;
                            if (!bl) {
                                PMStateManager.set(2, n);
                                break block0;
                            }
                            break block30;
                        }
                        case 1: {
                            if (GameState.mLives > 0) {
                                PMStateManager.set(2, 5);
                                break block0;
                            }
                            PMStateManager.set(3, 0);
                            break block0;
                        }
                        case 2: {
                            GameState.resetState();
                            StateGame.deinit();
                            StateGame.init(0);
                            break block0;
                        }
                        case 3: {
                            PMStateManager.set(2, 2);
                        }
                    }
                }
            }
        }
        PMSystem.nextFrame();
    }

    public static void transitionToMenu(boolean bl) {
        mExitState = bl ? 0 : 1;
        mState = 4;
        TransitionEffect.init(true);
        mSuppresHUD = true;
    }

    public static void transitionToMenuPauseMenu() {
        mExitState = 3;
        mState = 4;
        TransitionEffect.init(true);
        mSuppresHUD = true;
    }

    public static void restartLevel() {
        mExitState = 2;
        mState = 4;
        TransitionEffect.init(true);
        mSuppresHUD = true;
    }

    public static void startMenu(boolean bl) {
        if (mWorld.canPause()) {
            Touch.releasePos();
            Touch.flush();
            PauseMenu.openMenu(bl);
            mWorld.eventPaused();
            mState = 3;
            mSuppresHUD = true;
        }
    }

    private static void updateAlpha() {
    }

    static {
        mLevelFilenames = new String[]{"W01L01.bin", "W01L03.bin", "W01L05.bin", "W02L01.bin", "W02L02.bin", "W02L03.bin", "W02L04.bin", "W02L05.bin", "W03L01.bin", "W03L02.bin", "W03L03.bin", "W03L04.bin", "W03L05.bin", "W04L01.bin", "W04L02.bin", "W04L03.bin", "W04L04.bin", "W04L05.bin", "W05L01.bin", "W05L02.bin", "W05L03.bin", "W05L04.bin", "W05L05.bin"};
    }
}

