/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.enemies.Enemy5Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy5State;
import dk.progressivemedia.skeleton.game.enemies.Enemy5StateController;
import dk.progressivemedia.skeleton.game.enemies.Enemy5View;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy5StateFlying
extends Enemy5State {
    private boolean mGrowing;
    private int mInterp;
    private int mOffsetPrev;
    private int mOffset;

    public Enemy5StateFlying(Enemy5Data enemy5Data, Enemy5View enemy5View, Enemy5StateController enemy5StateController) {
        this.mData = enemy5Data;
        this.mView = enemy5View;
        this.mController = enemy5StateController;
    }

    public void enter() {
        this.mView.setAnimState(0);
        this.mGrowing = true;
        this.mInterp = 0;
        this.mOffsetPrev = 0;
        this.mOffset = 0;
    }

    public void exit() {
    }

    public void update() {
        Vector2 vector2 = this.mData.getPositionRef();
        Vector2 vector22 = this.mData.getMovementDirection();
        int n = this.mData.getMovementSpeed() * Timer.mDt >> 6;
        int n2 = this.mData.getMovementLength();
        if (this.mGrowing) {
            this.mInterp += n;
            if (this.mInterp > 65536) {
                this.mInterp = 65536;
                this.mGrowing = false;
            }
        } else {
            this.mInterp -= n;
            if (this.mInterp < 0) {
                this.mInterp = 0;
                this.mGrowing = true;
            }
        }
        this.mOffsetPrev = this.mOffset;
        this.mOffset = MathUtil.smoothStep(this.mInterp, n2);
        int n3 = vector2.mX;
        vector2.add(PMMath.MUL(vector22.mX, this.mOffset) - PMMath.MUL(vector22.mX, this.mOffsetPrev), PMMath.MUL(vector22.mY, this.mOffset) - PMMath.MUL(vector22.mY, this.mOffsetPrev));
        if (n3 < vector2.mX) {
            this.mData.setDirection(1);
        } else {
            this.mData.setDirection(0);
        }
    }
}

