/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.items;

import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class Keys {
    private static final int HALF_WIDTH = 8;
    private static final int HALF_WIDTH_FP = 524288;
    private static final int STATE_KEY_IDLE = 0;
    private static final int STATE_KEY_GONE = 1;
    private World mWorldRef;
    private Vector2[] mPositions;
    private int[] mStates;
    private Movie mAnimIdle;

    public Keys(Vector2[] vector2Array, World world) {
        this.mPositions = vector2Array;
        this.mWorldRef = world;
        this.mStates = new int[vector2Array.length];
        this.mAnimIdle = Movie.load((short)-24456);
        this.mAnimIdle.loadGfx();
        this.mAnimIdle.gotoTick(0);
        for (int i = 0; i < this.mPositions.length; ++i) {
            short s = (short)(1 << i);
            if ((GameState.mActiveKeysFound & s) == 0) continue;
            this.mStates[i] = 1;
        }
    }

    public void update() {
        this.mAnimIdle.update(Timer.mDt);
    }

    public void draw(Vector2 vector2) {
        for (int i = 0; i < this.mPositions.length; ++i) {
            if (this.mStates[i] == 1) continue;
            Vector2 vector22 = this.mPositions[i];
            long l = (long)vector22.mX * 5L >> 2;
            long l2 = (long)vector2.mX * 5L >> 2;
            int n = (int)((l >> 16) - (l2 >> 16));
            int n2 = 20;
            long l3 = (long)vector22.mY * 5L >> 2;
            long l4 = (long)vector2.mY * 5L >> 2;
            int n3 = (int)((l3 >> 16) - (l4 >> 16));
            int n4 = 20;
            if (!Camera.isInside(n - (n2 >> 1), n3 - (n4 >> 1), n2, n4) || this.mStates[i] != 0) continue;
            this.mAnimIdle.draw(n, n3);
        }
    }

    public int collision(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.mPositions.length; ++i) {
            if (this.mStates[i] != 0) continue;
            Vector2 vector2 = this.mPositions[i];
            int n5 = vector2.mX - 524288;
            int n6 = vector2.mX + 524288;
            int n7 = vector2.mY - 524288;
            int n8 = vector2.mY + 524288;
            if (n3 < n5 || n > n6 || n4 < n7 || n2 > n8) continue;
            this.mStates[i] = 1;
            this.mWorldRef.spawnParticle(2, vector2.mX, vector2.mY, 0, 0);
            return i;
        }
        return -1;
    }
}

