/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.pixeline;

import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.game.pixeline.PixelineState;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateController;
import dk.progressivemedia.skeleton.game.pixeline.PixelineViewController;
import dk.progressivemedia.skeleton.math.Vector2;

public class PixelineStateRunning
extends PixelineState {
    public PixelineStateRunning(PixelineData pixelineData, PixelineViewController pixelineViewController, PixelineStateController pixelineStateController) {
        this.mData = pixelineData;
        this.mView = pixelineViewController;
        this.mController = pixelineStateController;
    }

    public void enter() {
        Vector2 vector2 = this.mData.getVelocityRef();
        vector2.mY = 0;
        this.mView.setAnimState(1, false);
    }

    public void exit() {
    }

    public void update() {
        Vector2 vector2 = this.mData.getVelocityRef();
        int n = this.mData.getRunSpeedMax();
        if (!InputProxy.isHeldLeft() && !InputProxy.isHeldRight()) {
            if (vector2.mX > 0) {
                vector2.mX -= this.mData.getRunSpeedAcceleration();
                if (vector2.mX <= 0) {
                    vector2.mX = 0;
                    this.mController.requestStateChange(0);
                }
            } else {
                vector2.mX += this.mData.getRunSpeedAcceleration();
                if (vector2.mX >= 0) {
                    vector2.mX = 0;
                    this.mController.requestStateChange(0);
                }
            }
        } else if (this.mData.getDirection() == 0) {
            if (InputProxy.isHeldLeft()) {
                if (vector2.mX > -n) {
                    vector2.mX -= this.mData.getRunSpeedAcceleration();
                }
            } else if (InputProxy.isHeldRight()) {
                if (vector2.mX < -this.mData.getBrakeSpeedThreshold()) {
                    this.mController.requestStateChange(2);
                } else {
                    this.mData.setDirection(1);
                    vector2.mX = 0;
                }
            }
        } else if (InputProxy.isHeldRight()) {
            if (vector2.mX < n) {
                vector2.mX += this.mData.getRunSpeedAcceleration();
            }
        } else if (InputProxy.isHeldLeft()) {
            if (vector2.mX > this.mData.getBrakeSpeedThreshold()) {
                this.mController.requestStateChange(2);
            } else {
                this.mData.setDirection(0);
                vector2.mX = 0;
            }
        }
        if (PMCanvas.PMInput_isPressed(1) || this.mData.getJumpButtonPressed() || this.mData.getJumpButtonDown()) {
            vector2.mY = this.mData.getJumpVelocity();
            this.mController.requestStateChange(3);
            switch (this.mData.getTotemState()) {
                case 0: {
                    SoundBuffer.play(15, 100);
                    break;
                }
                case 1: {
                    SoundBuffer.play(10, 100);
                    break;
                }
                case 2: {
                    SoundBuffer.play(10, 100);
                    break;
                }
                case 3: {
                    SoundBuffer.play(8, 100);
                }
            }
        }
    }
}

