/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.math;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.rflib.util.PMRandom;

public class MathUtil {
    public static final int PI = 205887;
    public static final int TWO_PI = 411774;
    public static final int MAX_ANGLE = 23527424;
    public static final int TO_DEGREE = PMMath.DIV(0xB40000, 205887);

    public static int smoothStep(int n, int n2) {
        int n3 = PMMath.MUL(PMMath.MUL(n, n), 196608 - PMMath.MUL(131072, n));
        return PMMath.MUL(n3, n2);
    }

    public static int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static int abs(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public static int randomBounded(int n) {
        long l = (long)PMRandom.get16() * (long)(n + 1);
        return (int)(l >> 16);
    }

    public static int randomBounded(int n, int n2) {
        long l = (long)PMRandom.get16() * (long)(n2 - n + 1);
        return n + (int)(l >> 16);
    }

    public static int aTan2(int n, int n2) {
        int n3 = 51471;
        int n4 = n3 * 3;
        int n5 = n;
        if (n < 0) {
            n5 = -n;
        }
        ++n5;
        int n6 = 0;
        if (n2 >= 0) {
            int n7 = PMMath.DIV(n2 - n5, n2 + n5);
            n6 = n3 - PMMath.MUL(n3, n7);
        } else {
            int n8 = PMMath.DIV(n2 + n5, n5 - n2);
            n6 = n4 - PMMath.MUL(n3, n8);
        }
        if (n < 0) {
            return -n6;
        }
        return n6;
    }
}

