/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.script;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.debug.PMDebug;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.skeleton.Dialog;

public class Script {
    private short[] script;
    private int offset;
    private int time;
    private boolean fastforward;
    private int waitTick;
    private boolean waitKey;
    private boolean waitText;
    private int waitAudio;
    private int lastAudio;
    private boolean audioDelayed;
    private int delayedAudio;
    private static final int NUM_VARIABLES = 10;
    private int[] variables;

    public static Script load(short s) {
        Script script = new Script();
        script.script = PMFile.fileToShortArray(s);
        script.reset();
        return script;
    }

    public static Script load(String string) {
        Script script = new Script();
        script.script = PMFile.fileToShortArray(string);
        if (script.script == null) {
            return null;
        }
        script.reset();
        return script;
    }

    public void stop() {
        if (this.lastAudio >= 0) {
            PMAudio.stop(this.lastAudio);
        }
        if (Dialog.isOpen()) {
            Dialog.endDialog();
        }
        this.reset();
    }

    public boolean update(int n) {
        if (this.isDone()) {
            return true;
        }
        this.time += n;
        if (this.audioDelayed && Dialog.isReady()) {
            if (!PMAudio.isPlaying(this.delayedAudio, -1)) {
                PMAudio.play(this.delayedAudio, 1);
            }
            this.lastAudio = this.delayedAudio;
            this.waitAudio = this.delayedAudio;
            this.audioDelayed = false;
            this.delayedAudio = -1;
        }
        if (this.isWaiting()) {
            if (this.waitTick != 0 && this.waitTick < this.time) {
                this.waitTick = 0;
            }
            if (this.waitKey && PMCanvas.PMInput_isPressed(1)) {
                this.waitKey = false;
            }
            if (this.waitText) {
                if (Dialog.isTextDoneUser()) {
                    if (this.waitAudio >= 0) {
                        PMAudio.stop(this.waitAudio);
                        this.waitAudio = -1;
                    }
                    this.audioDelayed = false;
                    this.delayedAudio = -1;
                }
                if (Dialog.isTextDoneTime() || Dialog.isTextDoneUser()) {
                    this.waitText = false;
                }
            }
            if (this.waitAudio >= 0 && !PMAudio.isPlaying(this.waitAudio, -1)) {
                this.waitAudio = -1;
            }
        } else {
            this.action();
        }
        if (this.isDone()) {
            if (Dialog.isOpen()) {
                Dialog.endDialog();
            }
            return true;
        }
        return false;
    }

    public boolean isDone() {
        return this.offset >= this.script.length && !this.isWaiting();
    }

    public void draw() {
    }

    public static void unload() {
    }

    public void reset() {
        this.variables = new int[10];
        this.rewind();
    }

    private boolean isWaiting() {
        return this.waitKey || this.waitTick > 0 || this.waitText || this.waitAudio >= 0;
    }

    public void rewind() {
        this.offset = 1;
        this.waitTick = 0;
        this.waitText = false;
        this.waitKey = false;
        this.waitAudio = -1;
        this.lastAudio = -1;
        this.audioDelayed = false;
        this.delayedAudio = -1;
    }

    public void setVariable(int n, int n2) {
        if (n < 0 || n > 9) {
            return;
        }
        this.variables[n] = n2;
    }

    public void action() {
        while (this.offset < this.script.length) {
            switch (this.script[this.offset]) {
                case 0: {
                    PMDebug.println(6, "Script: Wait Time");
                    this.waitTick = this.time + this.script[this.offset + 1] * 10;
                    this.offset += 2;
                    break;
                }
                case 1: {
                    ++this.offset;
                    return;
                }
                case 2: {
                    PMDebug.println(6, "Script: Wait Key");
                    this.waitKey = true;
                    ++this.offset;
                    break;
                }
                case 3: {
                    PMDebug.println(6, "Script: Dialog Show");
                    if (!Dialog.isOpen()) {
                        Dialog.startDialog(3);
                    }
                    Dialog.pushText(this.script[this.offset + 1]);
                    this.offset += 2;
                    break;
                }
                case 4: {
                    PMDebug.println(6, "Script: Wait Dialog");
                    this.waitText = true;
                    this.offset += 2;
                    break;
                }
                case 5: {
                    PMDebug.println(6, "Script: Dialog Show");
                    this.audioDelayed = false;
                    if (!Dialog.isOpen()) {
                        Dialog.startDialog(3);
                        this.audioDelayed = true;
                        this.delayedAudio = this.script[this.offset + 2];
                    }
                    Dialog.pushText(this.script[this.offset + 1]);
                    if (!this.audioDelayed) {
                        int n = this.script[this.offset + 2];
                        PMAudio.play(n, 1);
                        this.lastAudio = n;
                        if (this.waitAudio == n) {
                            this.waitAudio = -1;
                        }
                    }
                    this.offset += 3;
                    break;
                }
                case 7: {
                    PMDebug.println(6, "Script: Wait Dialog");
                    this.waitText = true;
                    this.waitAudio = this.script[this.offset + 1];
                    this.offset += 2;
                    break;
                }
                case 8: {
                    PMDebug.println(6, "Script: If Variable");
                    if (!Script.expression(this.variables[this.script[this.offset + 1]], this.script[this.offset + 2], this.script[this.offset + 3])) {
                        this.offset += this.script[this.offset + 4];
                    }
                    this.offset += 5;
                }
            }
        }
    }

    private static boolean expression(int n, int n2, int n3) {
        if (n2 == 0) {
            return n > n3;
        }
        if (n2 == 2) {
            return n == n3;
        }
        if (n2 == 1) {
            return n < n3;
        }
        if (n2 == 3) {
            return n != n3;
        }
        return false;
    }
}

