/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.skeleton.TransitionTable;
import dk.progressivemedia.skeleton.math.MathUtil;

public class Transition {
    private int[] lookupTable;
    private int transitionType;
    private int value;
    private int src;
    private int dest;
    private int distance;
    private int step;
    private int length;

    public Transition(int n, int n2) {
        this.length = n2;
        this.actualValue(n);
        this.transitionType = 2;
        this.lookupTable = TransitionTable.CreateTable(n2, this.transitionType);
    }

    public Transition(int n, int n2, int n3) {
        this.length = n2;
        this.actualValue(n);
        n3 = 2;
        this.lookupTable = TransitionTable.CreateTable(n2, n3);
    }

    public void actualValue(int n) {
        this.value = n;
        this.src = n;
        this.dest = n;
        this.step = this.length;
        this.distance = 0;
    }

    public int actualValue() {
        return this.dest;
    }

    public void Value(int n) {
        if (!this.close(n)) {
            this.src = this.value;
            this.dest = n;
            this.distance = n - this.value;
            this.step = 0;
        }
    }

    private boolean close(int n) {
        int n2 = MathUtil.abs(this.dest - n);
        return n2 < 1;
    }

    public int Value() {
        return this.value;
    }

    public void update() {
        ++this.step;
        this.value = this.step < this.length ? this.src + (this.distance * (this.lookupTable[this.step] >> 8) >> 8) : this.dest;
    }

    public boolean isMoving() {
        return this.value != this.dest;
    }
}

