/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.dangers;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class Danger3s {
    private static final int WIDTH_FP = 0x200000;
    private static final int HEIGHT_3_TILES = 0;
    private static final int HEIGHT_5_TILES = 1;
    private static final int HEIGHT_7_TILES = 2;
    private static final int STATE_IDLE = 0;
    private static final int STATE_SHAKING = 1;
    private static final int STATE_FIRING = 2;
    private static final int STATE_COOLDOWN = 3;
    private Vector2[] mPositions;
    private Movie[] mAnimShaking;
    private Movie[] mAnimFiring;
    private int[] mState;
    private int[] mShakeTimer;
    private int[] mCooldownTimer;
    private int[] mHeight;
    private int[] mDamageHeight;
    private int mNumRumbles;
    private int mRumbleId;

    public Danger3s(Vector2[] vector2Array, int[] nArray) {
        this.mPositions = vector2Array;
        this.mAnimShaking = new Movie[this.mPositions.length];
        this.mAnimFiring = new Movie[this.mPositions.length];
        this.mState = new int[this.mPositions.length];
        this.mShakeTimer = new int[this.mPositions.length];
        this.mCooldownTimer = new int[this.mPositions.length];
        this.mHeight = new int[this.mPositions.length];
        this.mDamageHeight = new int[this.mPositions.length];
        for (int i = 0; i < this.mPositions.length; ++i) {
            this.mState[i] = 0;
            this.mShakeTimer[i] = 1000;
            this.mCooldownTimer[i] = 1000;
            block0 : switch (Defines.mWorldLookup[GameState.mLevel]) {
                case 0: {
                    this.mAnimShaking[i] = Movie.load((short)21206);
                    switch (nArray[i]) {
                        case 0: {
                            this.mAnimFiring[i] = Movie.load((short)726);
                            this.mHeight[i] = 0x300000;
                            break;
                        }
                        case 1: {
                            this.mAnimFiring[i] = Movie.load((short)-29251);
                            this.mHeight[i] = 0x500000;
                            break;
                        }
                        case 2: {
                            this.mAnimFiring[i] = Movie.load((short)1915);
                            this.mHeight[i] = 0x700000;
                        }
                    }
                    break;
                }
                case 1: {
                    this.mAnimShaking[i] = Movie.load((short)25269);
                    switch (nArray[i]) {
                        case 0: {
                            this.mAnimFiring[i] = Movie.load((short)12981);
                            this.mHeight[i] = 0x300000;
                            break;
                        }
                        case 1: {
                            this.mAnimFiring[i] = Movie.load((short)-16930);
                            this.mHeight[i] = 0x500000;
                            break;
                        }
                        case 2: {
                            this.mAnimFiring[i] = Movie.load((short)14104);
                            this.mHeight[i] = 0x700000;
                        }
                    }
                    break;
                }
                case 2: {
                    this.mAnimShaking[i] = Movie.load((short)29332);
                    switch (nArray[i]) {
                        case 0: {
                            this.mAnimFiring[i] = Movie.load((short)8852);
                            this.mHeight[i] = 0x300000;
                            break;
                        }
                        case 1: {
                            this.mAnimFiring[i] = Movie.load((short)-20993);
                            this.mHeight[i] = 0x500000;
                            break;
                        }
                        case 2: {
                            this.mAnimFiring[i] = Movie.load((short)10041);
                            this.mHeight[i] = 0x700000;
                        }
                    }
                    break;
                }
                case 3: {
                    this.mAnimShaking[i] = Movie.load((short)627);
                    switch (nArray[i]) {
                        case 0: {
                            this.mAnimFiring[i] = Movie.load((short)21107);
                            this.mHeight[i] = 0x300000;
                            break;
                        }
                        case 1: {
                            this.mAnimFiring[i] = Movie.load((short)-8936);
                            this.mHeight[i] = 0x500000;
                            break;
                        }
                        case 2: {
                            this.mAnimFiring[i] = Movie.load((short)22494);
                            this.mHeight[i] = 0x700000;
                        }
                    }
                    break;
                }
                case 4: {
                    this.mAnimShaking[i] = Movie.load((short)4690);
                    switch (nArray[i]) {
                        case 0: {
                            this.mAnimFiring[i] = Movie.load((short)16978);
                            this.mHeight[i] = 0x300000;
                            break block0;
                        }
                        case 1: {
                            this.mAnimFiring[i] = Movie.load((short)-12999);
                            this.mHeight[i] = 0x500000;
                            break block0;
                        }
                        case 2: {
                            this.mAnimFiring[i] = Movie.load((short)18431);
                            this.mHeight[i] = 0x700000;
                        }
                    }
                }
            }
            this.mAnimShaking[i].gotoTick(0);
            this.mAnimFiring[i].gotoTick(0);
            this.mDamageHeight[i] = 0;
        }
        this.mNumRumbles = 0;
        this.mRumbleId = -1;
    }

    public void update() {
        if (this.mNumRumbles > 0 && !PMAudio.isPlaying(6, -1)) {
            PMAudio.play(6, -1);
        }
        if (this.mNumRumbles <= 0 && PMAudio.isPlaying(6, -1)) {
            PMAudio.stop(6);
        }
        for (int i = 0; i < this.mPositions.length; ++i) {
            if (this.mState[i] == 1) {
                this.mAnimShaking[i].update(64 * Timer.mDt >> 6);
                int n = i;
                this.mShakeTimer[n] = this.mShakeTimer[n] - Timer.mDt;
                if (this.mShakeTimer[i] > 0) continue;
                this.mState[i] = 2;
                continue;
            }
            if (this.mState[i] == 2) {
                this.mAnimShaking[i].update(64 * Timer.mDt >> 6);
                this.mAnimFiring[i].update(64 * Timer.mDt >> 6);
                if (this.mAnimFiring[i].isDone()) {
                    this.mState[i] = 3;
                    this.mShakeTimer[i] = 1000;
                    this.mAnimShaking[i].gotoTick(0);
                    this.mAnimFiring[i].gotoTick(0);
                    this.mDamageHeight[i] = 0;
                    --this.mNumRumbles;
                }
                if (this.mDamageHeight[i] >= this.mHeight[i]) continue;
                int n = i;
                this.mDamageHeight[n] = this.mDamageHeight[n] + (635500 * Timer.mDt >> 6);
                if (this.mDamageHeight[i] < this.mHeight[i]) continue;
                SoundBuffer.play(7, 500);
                continue;
            }
            if (this.mState[i] != 3) continue;
            int n = i;
            this.mCooldownTimer[n] = this.mCooldownTimer[n] - Timer.mDt;
            if (this.mCooldownTimer[i] > 0) continue;
            this.mState[i] = 0;
            this.mCooldownTimer[i] = 1000;
        }
    }

    public void draw(Vector2 vector2) {
        block6: for (int i = 0; i < this.mPositions.length; ++i) {
            Vector2 vector22 = this.mPositions[i];
            long l = (long)vector22.mX * 5L >> 2;
            long l2 = (long)vector22.mY * 5L >> 2;
            long l3 = (long)vector2.mX * 5L >> 2;
            long l4 = (long)vector2.mY * 5L >> 2;
            int n = (int)((l >> 16) - (l3 >> 16));
            int n2 = (int)((l2 >> 16) - (l4 >> 16));
            int n3 = 40;
            int n4 = this.mHeight[i] * 5 >> 2;
            if (!Camera.isInside(n, n2, n3, n4 >>= 16)) continue;
            switch (this.mState[i]) {
                case 0: {
                    this.mAnimShaking[i].draw(n, n2);
                }
                case 1: {
                    this.mAnimShaking[i].draw(n, n2);
                    continue block6;
                }
                case 2: {
                    this.mAnimShaking[i].draw(n, n2);
                    this.mAnimFiring[i].draw(n, n2 + 8);
                    continue block6;
                }
                case 3: {
                    this.mAnimShaking[i].draw(n, n2);
                }
            }
        }
    }

    public boolean collision(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.mPositions.length; ++i) {
            Vector2 vector2 = this.mPositions[i];
            int n5 = vector2.mX;
            int n6 = vector2.mX + 0x200000;
            int n7 = vector2.mY;
            int n8 = vector2.mY + this.mHeight[i];
            int n9 = vector2.mY + this.mDamageHeight[i];
            if (n3 < n5 || n > n6 || n4 < n7 || n2 > n8) {
                if (this.mState[i] != 1) continue;
                this.mState[i] = 0;
                this.mShakeTimer[i] = 1000;
                this.mAnimShaking[i].gotoTick(0);
                this.mDamageHeight[i] = 0;
                --this.mNumRumbles;
                continue;
            }
            if (this.mState[i] == 0) {
                this.mState[i] = 1;
                ++this.mNumRumbles;
                continue;
            }
            if (this.mState[i] != 2 || n2 >= n9) continue;
            return true;
        }
        return false;
    }
}

