/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.pixeline;

import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.game.pixeline.PixelineState;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateController;
import dk.progressivemedia.skeleton.game.pixeline.PixelineViewController;
import dk.progressivemedia.skeleton.math.Vector2;

public class PixelineStateBraking
extends PixelineState {
    private static final int PARTICLE_DELAY = 99;
    private World mWorldRef;
    private int mTimer;

    public PixelineStateBraking(PixelineData pixelineData, PixelineViewController pixelineViewController, PixelineStateController pixelineStateController) {
        this.mData = pixelineData;
        this.mView = pixelineViewController;
        this.mController = pixelineStateController;
        this.mWorldRef = this.mData.getWorldRef();
    }

    public void enter() {
        this.mView.setAnimState(6, false);
        this.mTimer = 99;
        Vector2 vector2 = this.mData.getVelocityRef();
        if (this.mData.getDirection() == 0) {
            vector2.mX = -this.mData.getBrakeSpeedThreshold();
        } else if (this.mData.getDirection() == 1) {
            vector2.mX = this.mData.getBrakeSpeedThreshold();
        }
    }

    public void exit() {
    }

    public void update() {
        Vector2 vector2 = this.mData.getPositionRef();
        Vector2 vector22 = this.mData.getVelocityRef();
        Vector2 vector23 = this.mData.getDimensionRef();
        this.mTimer -= Timer.mDt;
        if (this.mTimer <= 0) {
            int n = vector2.mX - (vector22.mX > 0 ? vector23.mX >> 1 : -(vector23.mX >> 1));
            this.mWorldRef.spawnParticle(0, n, vector2.mY, 0, 0);
            this.mTimer = 99;
        }
        if (this.mData.getDirection() == 0 && InputProxy.isHeldLeft() || this.mData.getDirection() == 1 && InputProxy.isHeldRight()) {
            this.mController.requestStateChange(1);
        }
        if (vector22.mX > 0) {
            vector22.mX -= this.mData.getBrakeDeceleration();
            if (vector22.mX <= 0) {
                vector22.mX = 0;
                this.mController.requestStateChange(0);
            }
        } else {
            vector22.mX += this.mData.getBrakeDeceleration();
            if (vector22.mX >= 0) {
                vector22.mX = 0;
                this.mController.requestStateChange(0);
            }
        }
        if (PMCanvas.PMInput_isPressed(1) || this.mData.getJumpButtonPressed() || this.mData.getJumpButtonDown()) {
            vector22.mY = this.mData.getJumpVelocity();
            this.mController.requestStateChange(3);
            switch (this.mData.getTotemState()) {
                case 0: {
                    SoundBuffer.play(15, 100);
                    break;
                }
                case 1: {
                    SoundBuffer.play(10, 100);
                    break;
                }
                case 2: {
                    SoundBuffer.play(10, 100);
                    break;
                }
                case 3: {
                    SoundBuffer.play(8, 100);
                }
            }
        }
    }
}

